/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.forgejo;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.forgejo.Forgejo;

public class ForgejoMavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.ForgejoMavenDeployer, org.jreleaser.model.internal.deploy.maven.ForgejoMavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.ForgejoMavenDeployer deployer;

    public ForgejoMavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.ForgejoMavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.ForgejoMavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "forgejo";
    }

    public void deploy(String name) throws DeployException {
        this.deployPackages();
    }

    protected void deleteExistingPackages(String baseUrl, String token, Set<Deployable> deployables) throws DeployException {
        for (Deployable deployable : deployables) {
            if (!deployable.getFilename().endsWith(".pom")) continue;
            this.deletePackage(baseUrl, token, deployable);
        }
    }

    private void deletePackage(String baseUrl, String token, Deployable deployable) throws DeployException {
        URL url = null;
        try {
            url = new URI(baseUrl).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{deployable.getGav(), e.getMessage()}), (Throwable)e);
        }
        StringBuilder theUrl = new StringBuilder(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() != -1) {
            theUrl.append(url.getPort());
        }
        try {
            Forgejo api = new Forgejo(this.context.asImmutable(), theUrl.toString(), token, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout());
            api.deletePackage(this.deployer.getUsername(), "maven", deployable.getGroupId() + "-" + deployable.getArtifactId(), deployable.getVersion());
        }
        catch (Exception e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_forgejo_delete_package", (Object[])new Object[]{this.deployer.getUsername(), "maven", deployable.getGroupId() + "-" + deployable.getArtifactId(), deployable.getVersion()}));
        }
    }
}

