/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jmol.awt.JmolFrame;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.StatusBar;

public class DisplayPanel
extends JPanel
implements JmolFrame,
ComponentListener,
Printable {
    StatusBar status;
    Viewer vwr;
    private String displaySpeed;
    private Dimension startupDimension;
    boolean haveDisplay;
    Point border;
    boolean haveBorder;
    MeasurementTable measurementTable;
    JmolPanel jmolPanel;
    private JFrame frame;
    private boolean showPaintTime = true;
    final Dimension dimSize = new Dimension();
    private final Rectangle rectClip = new Rectangle();
    AbstractButton buttonRotate;
    AbstractButton buttonModelkit;
    ButtonGroup toolbarButtonGroup = new ButtonGroup();
    private HomeAction homeAction = new HomeAction();
    private DefineCenterAction defineCenterAction = new DefineCenterAction();
    private Action frontAction = new MoveToAction("front", "moveto 2.0 front");
    private Action topAction = new MoveToAction("top", "moveto 1.0 front;moveto 2.0 top");
    private Action bottomAction = new MoveToAction("bottom", "moveto 1.0 front;moveto 2.0 bottom");
    private Action rightAction = new MoveToAction("right", "moveto 1.0 front;moveto 2.0 right");
    private Action leftAction = new MoveToAction("left", "moveto 1.0 front;moveto 2.0 left");
    private Action hydrogensAction = new CheckBoxMenuItemAction("hydrogensCheck", "set showHydrogens");
    private Action measurementsAction = new CheckBoxMenuItemAction("measurementsCheck", "set showMeasurements");
    private Action perspectiveAction = new CheckBoxMenuItemAction("perspectiveCheck", "set PerspectiveDepth");
    private Action axesAction = new CheckBoxMenuItemAction("axesCheck", "set showAxes");
    private Action boundboxAction = new CheckBoxMenuItemAction("boundboxCheck", "set showBoundBox");
    private Action deleteAction = new SetStatusAction("delete", GT.$("Delete atoms"));
    private Action zoomAction = new SetStatusAction("zoom", null);
    private Action xlateAction = new SetStatusAction("xlate", null);
    private static int timeLast = 0;
    private static int timeCount;
    private static int timeTotal;
    private long timeBegin;
    private int lastMotionEventNumber;

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    DisplayPanel(JmolPanel jmol) {
        this.jmolPanel = jmol;
        this.frame = jmol.frame;
        this.status = jmol.status;
        this.border = jmol.jmolApp.border;
        this.haveDisplay = jmol.jmolApp.haveDisplay;
        this.startupDimension = new Dimension(jmol.startupWidth, jmol.startupHeight);
        this.setFocusable(true);
        if (System.getProperty("painttime", "false").equals("true")) {
            this.showPaintTime = true;
        }
        this.displaySpeed = System.getProperty("display.speed");
        if (this.displaySpeed == null) {
            this.displaySpeed = "ms";
        }
        this.setDoubleBuffered(false);
    }

    void setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.updateSize(false);
    }

    public void start() {
        this.addComponentListener(this);
    }

    boolean isRotateMode() {
        return this.buttonRotate != null && this.buttonRotate.isSelected();
    }

    void setRotateMode() {
        if (this.buttonRotate != null && !this.isRotateMode()) {
            this.buttonRotate.setSelected(true);
            this.vwr.setSelectionHalosEnabled(false);
        }
    }

    void setModelkitMode() {
        if (this.buttonModelkit != null) {
            this.buttonModelkit.setSelected(true);
        }
        this.vwr.setSelectionHalosEnabled(false);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateSize(true);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.updateSize(true);
    }

    private void updateSize(boolean doAll) {
        if (this.haveDisplay) {
            this.getSize(this.dimSize);
            this.vwr.setScreenDimension(this.dimSize.width, this.dimSize.height);
        } else {
            this.vwr.setScreenDimension(this.startupDimension.width, this.startupDimension.height);
        }
        if (!doAll) {
            return;
        }
        this.setRotateMode();
        if (this.haveDisplay) {
            this.status.setStatus(2, this.dimSize.width + " x " + this.dimSize.height);
        }
        this.vwr.refresh(3, "updateSize");
    }

    @Override
    public void paint(Graphics g) {
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        if (this.dimSize.width == 0) {
            return;
        }
        this.vwr.renderScreenImage((Object)g, this.dimSize.width, this.dimSize.height);
        if (this.border == null) {
            this.border = new Point();
        }
        if (!this.haveBorder) {
            this.setBorder();
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
        }
    }

    void setBorder() {
        if (this.dimSize.width < 50) {
            return;
        }
        this.border.x = this.startupDimension.width - this.dimSize.width;
        this.border.y = this.startupDimension.height - this.dimSize.height;
        this.haveBorder = true;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int pageHeight;
        float scaleHeight;
        float scale;
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex > 0) {
            return 1;
        }
        this.rectClip.y = 0;
        this.rectClip.x = 0;
        int screenWidth = this.rectClip.width = this.vwr.getScreenWidth();
        int screenHeight = this.rectClip.height = this.vwr.getScreenHeight();
        Object image = this.vwr.getScreenImageBuffer(null, true);
        int pageX = (int)pf.getImageableX();
        int pageY = (int)pf.getImageableY();
        int pageWidth = (int)pf.getImageableWidth();
        float scaleWidth = (float)pageWidth / (float)screenWidth;
        float f = scale = scaleWidth < (scaleHeight = (float)(pageHeight = (int)pf.getImageableHeight()) / (float)screenHeight) ? scaleWidth : scaleHeight;
        if (scale < 1.0f) {
            int width = (int)((float)screenWidth * scale);
            int height = (int)((float)screenHeight * scale);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage((Image)image, pageX, pageY, width, height, null);
        } else {
            g2.drawImage((Image)image, pageX, pageY, null);
        }
        this.vwr.releaseScreenImage();
        return 0;
    }

    public Action[] getActions() {
        return new Action[]{this.deleteAction, this.zoomAction, this.xlateAction, this.frontAction, this.topAction, this.bottomAction, this.rightAction, this.leftAction, this.defineCenterAction, this.hydrogensAction, this.measurementsAction, this.homeAction, this.perspectiveAction, this.axesAction, this.boundboxAction};
    }

    private void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    private void recordTime(int time) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = time;
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int motionEventNumber = this.vwr.getMotionEventNumber();
        if (this.lastMotionEventNumber != motionEventNumber) {
            this.lastMotionEventNumber = motionEventNumber;
            this.resetTimes();
        }
    }

    private void stopPaintClock() {
        int time = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(time);
        this.showTimes();
    }

    private String fmt(int num) {
        if (num < 0) {
            return "---";
        }
        if (num < 10) {
            return "  " + num;
        }
        if (num < 100) {
            return " " + num;
        }
        return "" + num;
    }

    private void showTimes() {
        int timeAverage;
        int n = timeAverage = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        if (this.displaySpeed.equalsIgnoreCase("fps")) {
            this.status.setStatus(3, this.fmt(1000 / timeLast) + "FPS : " + this.fmt(1000 / timeAverage) + "FPS");
        } else {
            this.status.setStatus(3, this.vwr.getP("_memory") + " Mb; " + this.fmt(timeLast) + "/" + timeAverage + " ms");
        }
    }

    public void setJmolSize(Dimension d) {
        this.dimSize.width = d.width;
        this.dimSize.height = d.height;
        this.setPreferredSize(d);
    }

    private class CheckBoxMenuItemAction
    extends AbstractAction {
        private final String action;

        public CheckBoxMenuItemAction(String name, String action) {
            super(name);
            this.action = action;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
            DisplayPanel.this.vwr.evalStringQuiet(this.action + " " + cbmi.isSelected());
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            super("home");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.homePosition();
            DisplayPanel.this.setRotateMode();
        }
    }

    class DefineCenterAction
    extends AbstractAction {
        public DefineCenterAction() {
            super("definecenter");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.evalStringQuiet("center (selected)");
            DisplayPanel.this.setRotateMode();
        }
    }

    private class MoveToAction
    extends AbstractAction {
        private final String action;

        public MoveToAction(String name, String action) {
            super(name);
            this.action = action;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DisplayPanel.this.vwr.getShowBbcage() || DisplayPanel.this.vwr.getBooleanProperty("showUnitCell")) {
                DisplayPanel.this.vwr.evalStringQuiet(this.action);
            } else {
                DisplayPanel.this.vwr.evalStringQuiet("boundbox on;" + this.action + ";delay 1;boundbox off");
            }
        }
    }

    private class SetStatusAction
    extends AbstractAction {
        private final String statusText;

        public SetStatusAction(String name, String status) {
            super(name);
            this.statusText = status;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DisplayPanel.this.vwr.setSelectionHalosEnabled(false);
            if (this.statusText != null) {
                DisplayPanel.this.status.setStatus(1, this.statusText);
            } else {
                DisplayPanel.this.status.setStatus(1, ((JComponent)e.getSource()).getToolTipText());
            }
        }
    }
}

