/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjarharmonybeans.internal.nls.Messages;
import groovyjarjaropenbeans.ExceptionListener;
import groovyjarjaropenbeans.Expression;
import groovyjarjaropenbeans.Statement;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDecoder {
    private ClassLoader defaultClassLoader = null;
    private InputStream inputStream;
    private ExceptionListener listener;
    private Object owner;
    private Stack<Elem> readObjs = new Stack();
    private int readObjIndex = 0;
    private SAXHandler saxHandler = null;

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null, null, null);
    }

    public XMLDecoder(InputStream inputStream, Object owner) {
        this(inputStream, owner, null, null);
    }

    public XMLDecoder(InputStream inputStream, Object owner, ExceptionListener listener) {
        this(inputStream, owner, listener, null);
    }

    public XMLDecoder(InputStream inputStream, Object owner, ExceptionListener listener, ClassLoader cl) {
        this.inputStream = inputStream;
        this.owner = owner;
        this.listener = listener == null ? new DefaultExceptionListener() : listener;
        this.defaultClassLoader = cl;
    }

    public void close() {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
        }
        catch (Exception e) {
            this.listener.exceptionThrown(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object readObject() {
        if (this.inputStream == null) {
            return null;
        }
        if (this.saxHandler == null) {
            this.saxHandler = new SAXHandler();
            try {
                SAXParserFactory.newInstance().newSAXParser().parse(this.inputStream, (DefaultHandler)this.saxHandler);
            }
            catch (Exception e) {
                this.listener.exceptionThrown(e);
            }
        }
        if (this.readObjIndex >= this.readObjs.size()) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.70"));
        }
        Elem elem = (Elem)this.readObjs.get(this.readObjIndex);
        if (!elem.isClosed) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.70"));
        }
        ++this.readObjIndex;
        return elem.result;
    }

    public void setExceptionListener(ExceptionListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    private static class Elem {
        String id;
        String idref;
        boolean isExecuted;
        boolean isExpression;
        boolean isBasicType;
        boolean isClosed;
        Object target;
        String methodName;
        boolean fromProperty;
        boolean fromIndex;
        boolean fromField;
        boolean fromOwner;
        Attributes attributes;
        Object result;

        private Elem() {
        }
    }

    private class SAXHandler
    extends DefaultHandler {
        boolean inJavaElem = false;
        HashMap<String, Object> idObjMap = new HashMap();

        private SAXHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.inJavaElem) {
                return;
            }
            if (XMLDecoder.this.readObjs.size() > 0) {
                Elem elem = (Elem)XMLDecoder.this.readObjs.peek();
                if (elem.isBasicType) {
                    String str = new String(ch, start, length);
                    elem.methodName = elem.methodName == null ? str : elem.methodName + str;
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.inJavaElem) {
                if ("java".equals(qName)) {
                    this.inJavaElem = true;
                } else {
                    XMLDecoder.this.listener.exceptionThrown(new Exception(Messages.getString("beans.72", qName)));
                }
                return;
            }
            if ("object".equals(qName)) {
                this.startObjectElem(attributes);
            } else if ("array".equals(qName)) {
                this.startArrayElem(attributes);
            } else if ("void".equals(qName)) {
                this.startVoidElem(attributes);
            } else if ("boolean".equals(qName) || "byte".equals(qName) || "char".equals(qName) || "class".equals(qName) || "double".equals(qName) || "float".equals(qName) || "int".equals(qName) || "long".equals(qName) || "short".equals(qName) || "string".equals(qName) || "null".equals(qName)) {
                this.startBasicElem(qName, attributes);
            }
        }

        private void startObjectElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            elem.idref = attributes.getValue("idref");
            elem.attributes = attributes;
            if (elem.idref == null) {
                this.obtainTarget(elem, attributes);
                this.obtainMethod(elem, attributes);
            }
            XMLDecoder.this.readObjs.push(elem);
        }

        private void obtainTarget(Elem elem, Attributes attributes) {
            String className = attributes.getValue("class");
            if (className != null) {
                try {
                    elem.target = this.classForName(className);
                }
                catch (ClassNotFoundException e) {
                    XMLDecoder.this.listener.exceptionThrown(e);
                }
            } else {
                Elem parent = this.latestUnclosedElem();
                if (parent == null) {
                    elem.target = XMLDecoder.this.owner;
                    return;
                }
                elem.target = this.execute(parent);
            }
        }

        private void obtainMethod(Elem elem, Attributes attributes) {
            elem.methodName = attributes.getValue("method");
            if (elem.methodName != null) {
                return;
            }
            elem.methodName = attributes.getValue("property");
            if (elem.methodName != null) {
                elem.fromProperty = true;
                return;
            }
            elem.methodName = attributes.getValue("index");
            if (elem.methodName != null) {
                elem.fromIndex = true;
                return;
            }
            elem.methodName = attributes.getValue("field");
            if (elem.methodName != null) {
                elem.fromField = true;
                return;
            }
            elem.methodName = attributes.getValue("owner");
            if (elem.methodName != null) {
                elem.fromOwner = true;
                return;
            }
            elem.methodName = "new";
        }

        private Class<?> classForName(String className) throws ClassNotFoundException {
            if ("boolean".equals(className)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(className)) {
                return Byte.TYPE;
            }
            if ("char".equals(className)) {
                return Character.TYPE;
            }
            if ("double".equals(className)) {
                return Double.TYPE;
            }
            if ("float".equals(className)) {
                return Float.TYPE;
            }
            if ("int".equals(className)) {
                return Integer.TYPE;
            }
            if ("long".equals(className)) {
                return Long.TYPE;
            }
            if ("short".equals(className)) {
                return Short.TYPE;
            }
            return Class.forName(className, true, XMLDecoder.this.defaultClassLoader == null ? Thread.currentThread().getContextClassLoader() : XMLDecoder.this.defaultClassLoader);
        }

        private void startArrayElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            elem.attributes = attributes;
            try {
                Class<?> compClass = this.classForName(attributes.getValue("class"));
                String lengthValue = attributes.getValue("length");
                if (lengthValue != null) {
                    int length = Integer.parseInt(attributes.getValue("length"));
                    elem.result = Array.newInstance(compClass, length);
                    elem.isExecuted = true;
                } else {
                    elem.target = compClass;
                    elem.methodName = "newArray";
                    elem.isExecuted = false;
                }
            }
            catch (Exception e) {
                XMLDecoder.this.listener.exceptionThrown(e);
            }
            XMLDecoder.this.readObjs.push(elem);
        }

        private void startVoidElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.id = attributes.getValue("id");
            elem.attributes = attributes;
            this.obtainTarget(elem, attributes);
            this.obtainMethod(elem, attributes);
            XMLDecoder.this.readObjs.push(elem);
        }

        private void startBasicElem(String tagName, Attributes attributes) {
            Elem elem = new Elem();
            elem.isBasicType = true;
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            elem.idref = attributes.getValue("idref");
            elem.attributes = attributes;
            elem.target = tagName;
            XMLDecoder.this.readObjs.push(elem);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.inJavaElem) {
                return;
            }
            if ("java".equals(qName)) {
                this.inJavaElem = false;
                return;
            }
            Elem toClose = this.latestUnclosedElem();
            if ("string".equals(toClose.target)) {
                Elem elem;
                StringBuilder sb = new StringBuilder();
                for (int index = XMLDecoder.this.readObjs.size() - 1; index >= 0 && toClose != (elem = (Elem)XMLDecoder.this.readObjs.get(index)); --index) {
                    if (!"char".equals(elem.target)) continue;
                    sb.insert(0, elem.methodName);
                }
                toClose.methodName = toClose.methodName != null ? toClose.methodName + sb.toString() : sb.toString();
            }
            this.execute(toClose);
            toClose.isClosed = true;
            while (XMLDecoder.this.readObjs.pop() != toClose) {
            }
            if (toClose.isExpression) {
                XMLDecoder.this.readObjs.push(toClose);
            }
        }

        private Elem latestUnclosedElem() {
            for (int i = XMLDecoder.this.readObjs.size() - 1; i >= 0; --i) {
                Elem elem = (Elem)XMLDecoder.this.readObjs.get(i);
                if (elem.isClosed) continue;
                return elem;
            }
            return null;
        }

        private Object execute(Elem elem) {
            if (elem.isExecuted) {
                return elem.result;
            }
            try {
                elem.result = elem.idref != null ? this.idObjMap.get(elem.idref) : (elem.isBasicType ? this.executeBasic(elem) : this.executeCommon(elem));
            }
            catch (Exception e) {
                XMLDecoder.this.listener.exceptionThrown(e);
            }
            if (elem.id != null) {
                this.idObjMap.put(elem.id, elem.result);
            }
            elem.isExecuted = true;
            return elem.result;
        }

        private Object executeCommon(Elem elem) throws Exception {
            ArrayList<Object> args = new ArrayList<Object>(5);
            while (XMLDecoder.this.readObjs.peek() != elem) {
                Elem argElem = (Elem)XMLDecoder.this.readObjs.pop();
                args.add(0, argElem.result);
            }
            String method = elem.methodName;
            if (elem.fromProperty) {
                method = (args.size() == 0 ? "get" : "set") + this.capitalize(method);
            }
            if (elem.fromIndex) {
                Integer index = Integer.valueOf(method);
                args.add(0, index);
                String string = method = args.size() == 1 ? "get" : "set";
            }
            if (elem.fromField) {
                Field f = ((Class)elem.target).getField(method);
                return new Expression(f, "get", new Object[]{null}).getValue();
            }
            if (elem.fromOwner) {
                return XMLDecoder.this.owner;
            }
            if (elem.target == XMLDecoder.this.owner) {
                if ("getOwner".equals(method)) {
                    return XMLDecoder.this.owner;
                }
                Class[] c = new Class[args.size()];
                for (int i = 0; i < args.size(); ++i) {
                    Object arg = args.get(i);
                    c[i] = arg == null ? null : arg.getClass();
                }
                try {
                    Method m = XMLDecoder.this.owner.getClass().getMethod(method, c);
                    return m.invoke(XMLDecoder.this.owner, args.toArray());
                }
                catch (NoSuchMethodException m) {
                    Method mostSpecificMethod = this.findMethod(XMLDecoder.this.owner instanceof Class ? (Class<?>)XMLDecoder.this.owner : XMLDecoder.this.owner.getClass(), method, c);
                    return mostSpecificMethod.invoke(XMLDecoder.this.owner, args.toArray());
                }
            }
            Expression exp = new Expression(elem.target, method, args.toArray());
            return exp.getValue();
        }

        private Method findMethod(Class<?> clazz, String methodName, Class<?>[] clazzes) throws Exception {
            Method[] methods = clazz.getMethods();
            ArrayList<Method> matchMethods = new ArrayList<Method>();
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                if (!methodName.equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != clazzes.length) continue;
                boolean match = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    boolean isAssignable;
                    boolean isNull = clazzes[i] == null;
                    boolean isPrimitive = this.isPrimitiveWrapper(clazzes[i], parameterTypes[i]);
                    boolean bl = isAssignable = isNull ? false : parameterTypes[i].isAssignableFrom(clazzes[i]);
                    if (isNull || isPrimitive || isAssignable) continue;
                    match = false;
                }
                if (!match) continue;
                matchMethods.add(method);
            }
            int size = matchMethods.size();
            if (size == 1) {
                return (Method)matchMethods.get(0);
            }
            if (size == 0) {
                throw new NoSuchMethodException(Messages.getString("beans.41", methodName));
            }
            Statement.MethodComparator comparator = new Statement.MethodComparator(methodName, clazzes);
            Method chosenOne = (Method)matchMethods.get(0);
            matchMethods.remove(0);
            int methodCounter = 1;
            for (Method method : matchMethods) {
                int difference = comparator.compare(chosenOne, method);
                if (difference > 0) {
                    chosenOne = method;
                    methodCounter = 1;
                    continue;
                }
                if (difference != 0) continue;
                ++methodCounter;
            }
            if (methodCounter > 1) {
                throw new NoSuchMethodException(Messages.getString("beans.62", methodName));
            }
            return chosenOne;
        }

        private boolean isPrimitiveWrapper(Class<?> wrapper, Class<?> base) {
            return base == Boolean.TYPE && wrapper == Boolean.class || base == Byte.TYPE && wrapper == Byte.class || base == Character.TYPE && wrapper == Character.class || base == Short.TYPE && wrapper == Short.class || base == Integer.TYPE && wrapper == Integer.class || base == Long.TYPE && wrapper == Long.class || base == Float.TYPE && wrapper == Float.class || base == Double.TYPE && wrapper == Double.class;
        }

        private String capitalize(String str) {
            StringBuilder buf = new StringBuilder(str);
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            return buf.toString();
        }

        private Object executeBasic(Elem elem) throws Exception {
            String tag = (String)elem.target;
            String value = elem.methodName;
            if ("null".equals(tag)) {
                return null;
            }
            if ("string".equals(tag)) {
                return value == null ? "" : value;
            }
            if ("class".equals(tag)) {
                return this.classForName(value);
            }
            if ("boolean".equals(tag)) {
                return Boolean.valueOf(value);
            }
            if ("byte".equals(tag)) {
                return Byte.valueOf(value);
            }
            if ("char".equals(tag)) {
                String codeAttr;
                if (value == null && elem.attributes != null && (codeAttr = elem.attributes.getValue("code")) != null) {
                    Character character = new Character((char)Integer.valueOf(codeAttr.substring(1), 16).intValue());
                    elem.methodName = character.toString();
                    return character;
                }
                return Character.valueOf(value.charAt(0));
            }
            if ("double".equals(tag)) {
                return Double.valueOf(value);
            }
            if ("float".equals(tag)) {
                return Float.valueOf(value);
            }
            if ("int".equals(tag)) {
                return Integer.valueOf(value);
            }
            if ("long".equals(tag)) {
                return Long.valueOf(value);
            }
            if ("short".equals(tag)) {
                return Short.valueOf(value);
            }
            throw new Exception(Messages.getString("beans.71", tag));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(e);
        }
    }

    private static class DefaultExceptionListener
    implements ExceptionListener {
        private DefaultExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Continue...");
        }
    }
}

