/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import groovy.contracts.Contracted;
import org.apache.groovy.contracts.ast.visitor.ASTNodeMetaData;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class ContractElementVisitor
extends BaseVisitor
implements ASTNodeMetaData {
    private ClassNode classNode;
    private boolean foundContractElement = false;

    public ContractElementVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    public void visitClass(ClassNode node) {
        if (!CandidateChecks.isContractsCandidate(node) && !CandidateChecks.isInterfaceContractsCandidate(node)) {
            return;
        }
        this.classNode = node;
        if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)node, Contracted.class.getName())) {
            this.foundContractElement = true;
            return;
        }
        this.foundContractElement |= this.classNode.getNodeMetaData((Object)"org.apache.groovy.contracts.CLOSURE_REPLACED") != null;
        if (!this.foundContractElement) {
            super.visitClass(node);
        }
        if (!this.foundContractElement && node.getSuperClass() != null) {
            this.visitClass(node.getSuperClass());
        }
        if (!this.foundContractElement) {
            for (ClassNode interfaceNode : node.getInterfaces()) {
                this.visitClass(interfaceNode);
                if (!this.foundContractElement) continue;
                return;
            }
        }
    }

    protected void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
        if (!CandidateChecks.couldBeContractElementMethodNode(this.classNode, methodNode) && !CandidateChecks.isPreconditionCandidate(this.classNode, methodNode)) {
            return;
        }
        this.foundContractElement |= methodNode.getNodeMetaData((Object)"org.apache.groovy.contracts.CLOSURE_REPLACED") != null;
    }

    public boolean isFoundContractElement() {
        return this.foundContractElement;
    }
}

