/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;

public final class Configurator {
    public static final String DISABLED_ASSERTIONS = "-da";
    public static final String ENABLED_ASSERTIONS = "-ea";
    public static final String PACKAGE_PREFIX = ":";
    public static final String ENABLE_PACKAGE_ASSERTIONS = "-ea:";
    public static final String DISABLE_PACKAGE_ASSERTIONS = "-da:";
    public static final String PACKAGE_POSTFIX = "...";
    private static Map<String, Boolean> assertionConfiguration;

    private static void initAssertionConfiguration() {
        assertionConfiguration = new HashMap<String, Boolean>();
        assertionConfiguration.put(null, Boolean.TRUE);
        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimemxBean.getInputArguments()) {
            String className;
            String packageName;
            if (DISABLED_ASSERTIONS.equals(arg)) {
                assertionConfiguration.put(null, Boolean.FALSE);
                continue;
            }
            if (arg.startsWith(ENABLE_PACKAGE_ASSERTIONS) && arg.endsWith(PACKAGE_POSTFIX)) {
                packageName = arg.substring(ENABLE_PACKAGE_ASSERTIONS.length(), arg.length() - PACKAGE_POSTFIX.length());
                assertionConfiguration.put(packageName, Boolean.TRUE);
                continue;
            }
            if (arg.startsWith(DISABLE_PACKAGE_ASSERTIONS) && arg.endsWith(PACKAGE_POSTFIX)) {
                packageName = arg.substring(DISABLE_PACKAGE_ASSERTIONS.length(), arg.length() - PACKAGE_POSTFIX.length());
                assertionConfiguration.put(packageName, Boolean.FALSE);
                continue;
            }
            if (arg.startsWith(ENABLE_PACKAGE_ASSERTIONS)) {
                className = arg.substring(ENABLE_PACKAGE_ASSERTIONS.length(), arg.length());
                assertionConfiguration.put(className, Boolean.TRUE);
                continue;
            }
            if (!arg.startsWith(DISABLE_PACKAGE_ASSERTIONS)) continue;
            className = arg.substring(DISABLE_PACKAGE_ASSERTIONS.length(), arg.length());
            assertionConfiguration.put(className, Boolean.FALSE);
        }
    }

    public static boolean checkAssertionsEnabled(String className) {
        return Configurator.internalMethod(className);
    }

    private static boolean internalMethod(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        if (assertionConfiguration.containsKey(className)) {
            return assertionConfiguration.get(className);
        }
        if (className.lastIndexOf(46) < 0) {
            return assertionConfiguration.get(null);
        }
        String packageName = className.substring(0, className.lastIndexOf(46));
        while (!assertionConfiguration.containsKey(packageName)) {
            int dotIndex = packageName.lastIndexOf(46);
            if (dotIndex < 0) {
                return assertionConfiguration.get(null);
            }
            packageName = packageName.substring(0, dotIndex);
        }
        if (assertionConfiguration.containsKey(packageName)) {
            return assertionConfiguration.get(packageName);
        }
        return assertionConfiguration.get(null);
    }

    static {
        Configurator.initAssertionConfiguration();
    }
}

