/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodCallTransformation;
import org.codehaus.groovy.ast.TransformingCodeVisitor;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.macro.methods.MacroGroovyMethods;
import org.codehaus.groovy.macro.runtime.MacroBuilder;
import org.codehaus.groovy.macro.transform.MacroClass;
import org.codehaus.groovy.macro.transform.MacroTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class MacroClassTransformation
extends MethodCallTransformation {
    private static final String MACRO_METHOD = "macro";
    private static final ClassNode MACROCLASS_TYPE = ClassHelper.make(MacroClass.class);

    protected GroovyCodeVisitor getTransformer(ASTNode[] nodes, SourceUnit sourceUnit) {
        MacroClassTransformer transformer = new MacroClassTransformer(sourceUnit);
        return new MacroClassTransformingCodeVisitor(transformer, sourceUnit);
    }

    private static class MacroClassTransformingCodeVisitor
    extends TransformingCodeVisitor {
        private final SourceUnit sourceUnit;

        MacroClassTransformingCodeVisitor(ClassCodeExpressionTransformer transformer, SourceUnit sourceUnit) {
            super(transformer);
            this.sourceUnit = sourceUnit;
        }

        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            ClassNode type = call.getType();
            if (type instanceof InnerClassNode && ((InnerClassNode)type).isAnonymous() && MACROCLASS_TYPE.getNameWithoutPackage().equals(type.getSuperClass().getNameWithoutPackage())) {
                try {
                    String source = this.convertInnerClassToSource(type);
                    MethodCallExpression macroCall = GeneralUtils.callX((Expression)GeneralUtils.propX((Expression)GeneralUtils.classX((ClassNode)ClassHelper.makeWithoutCaching(MacroBuilder.class, (boolean)false)), (String)"INSTANCE"), (String)MacroClassTransformation.MACRO_METHOD, (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)source), MacroGroovyMethods.buildSubstitutions(this.sourceUnit, (ASTNode)type), GeneralUtils.classX((ClassNode)ClassHelper.make(ClassNode.class))}));
                    macroCall.setSpreadSafe(false);
                    macroCall.setSafe(false);
                    macroCall.setImplicitThis(false);
                    call.putNodeMetaData(MacroTransformation.class, (Object)macroCall);
                    List classes = this.sourceUnit.getAST().getClasses();
                    Iterator iterator = classes.iterator();
                    while (iterator.hasNext()) {
                        ClassNode aClass = (ClassNode)iterator.next();
                        if (aClass != type && type != aClass.getOuterClass()) continue;
                        iterator.remove();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            super.visitConstructorCallExpression(call);
        }

        private String convertInnerClassToSource(ClassNode type) throws Exception {
            String source = GeneralUtils.convertASTToSource((ReaderSource)this.sourceUnit.getSource(), (ASTNode)type);
            source = source.substring(source.indexOf(123) + 1, source.lastIndexOf(125) - 1);
            return source;
        }
    }

    private static class MacroClassTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit sourceUnit;

        MacroClassTransformer(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public Expression transform(Expression exp) {
            MethodCallExpression call;
            if (exp instanceof ConstructorCallExpression && (call = (MethodCallExpression)exp.getNodeMetaData(MacroTransformation.class)) != null) {
                return call;
            }
            return super.transform(exp);
        }
    }
}

