<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw edge-services`
Edge Services API
  
- [Backend-stage management commands](#backend-stage-management-commands)
  - [Create backend stage](#create-backend-stage)
  - [Delete backend stage](#delete-backend-stage)
  - [Get backend stage](#get-backend-stage)
  - [List backend stages](#list-backend-stages)
  - [Update backend stage](#update-backend-stage)
- [Cache-stage management commands](#cache-stage-management-commands)
  - [Create cache stage](#create-cache-stage)
  - [Delete cache stage](#delete-cache-stage)
  - [Get cache stage](#get-cache-stage)
  - [List cache stages](#list-cache-stages)
  - [Update cache stage](#update-cache-stage)
- [DNS-stage management commands](#dns-stage-management-commands)
  - [Create DNS stage](#create-dns-stage)
  - [Delete DNS stage](#delete-dns-stage)
  - [Get DNS stage](#get-dns-stage)
  - [List DNS stages](#list-dns-stages)
  - [Update DNS stage](#update-dns-stage)
- [Pipeline management commands](#pipeline-management-commands)
  - [Create pipeline](#create-pipeline)
  - [Delete pipeline](#delete-pipeline)
  - [Get pipeline](#get-pipeline)
  - [List pipelines](#list-pipelines)
  - [Update pipeline](#update-pipeline)
- [Purge-request management commands](#purge-request-management-commands)
  - [Create purge request](#create-purge-request)
  - [Get purge request](#get-purge-request)
  - [List purge requests](#list-purge-requests)
- [TLS-stage management commands](#tls-stage-management-commands)
  - [Create TLS stage](#create-tls-stage)
  - [Delete TLS stage](#delete-tls-stage)
  - [Get TLS stage](#get-tls-stage)
  - [List TLS stages](#list-tls-stages)
  - [Update TLS stage](#update-tls-stage)

  
## Backend-stage management commands

Backend-stage management commands.


### Create backend stage

Create a new backend stage. You must specify either a `scaleway_s3` (for a Scaleway Object Storage bucket) or `scaleway_lb` (for a Scaleway Load Balancer) field to configure the origin.

**Usage:**

```
scw edge-services backend-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| scaleway-s3.bucket-name |  | Name of the Bucket |
| scaleway-s3.bucket-region |  | Region of the Bucket |
| scaleway-s3.is-website |  | Defines whether the bucket website feature is enabled |
| scaleway-lb.lbs.{index}.id |  | ID of the Load Balancer |
| scaleway-lb.lbs.{index}.zone |  | Zone of the Load Balancer |
| scaleway-lb.lbs.{index}.frontend-id |  | ID of the frontend linked to the Load Balancer |
| scaleway-lb.lbs.{index}.is-ssl |  | Defines whether the Load Balancer's frontend handles SSL connections |
| scaleway-lb.lbs.{index}.domain-name |  | Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer |



### Delete backend stage

Delete an existing backend stage, specified by its `backend_stage_id`. Deleting a backend stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services backend-stage delete <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the backend stage to delete |



### Get backend stage

Retrieve information about an existing backend stage, specified by its `backend_stage_id`. Its full details, including `scaleway_s3` or `scaleway_lb`, are returned in the response object.

**Usage:**

```
scw edge-services backend-stage get <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the requested backend stage |



### List backend stages

List all backend stages, for a Scaleway Organization or Scaleway Project. By default, the backend stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services backend-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of backend stages in the response |
| pipeline-id |  | Pipeline ID to filter for, only backend stages from this pipeline will be returned |
| project-id |  | Project ID to filter for, only backend stages from this Project will be returned |
| bucket-name |  | Bucket name to filter for, only backend stages from this Bucket will be returned |
| bucket-region |  | Bucket region to filter for, only backend stages with buckets in this region will be returned |
| lb-id |  | Load Balancer ID to filter for, only backend stages with this Load Balancer will be returned |



### Update backend stage

Update the parameters of an existing backend stage, specified by its `backend_stage_id`.

**Usage:**

```
scw edge-services backend-stage update <backend-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| backend-stage-id | Required | ID of the backend stage to update |
| scaleway-s3.bucket-name |  | Name of the Bucket |
| scaleway-s3.bucket-region |  | Region of the Bucket |
| scaleway-s3.is-website |  | Defines whether the bucket website feature is enabled |
| scaleway-lb.lbs.{index}.id |  | ID of the Load Balancer |
| scaleway-lb.lbs.{index}.zone |  | Zone of the Load Balancer |
| scaleway-lb.lbs.{index}.frontend-id |  | ID of the frontend linked to the Load Balancer |
| scaleway-lb.lbs.{index}.is-ssl |  | Defines whether the Load Balancer's frontend handles SSL connections |
| scaleway-lb.lbs.{index}.domain-name |  | Fully Qualified Domain Name (in the format subdomain.example.com) to use in HTTP requests sent towards your Load Balancer |



## Cache-stage management commands

Cache-stage management commands.


### Create cache stage

Create a new cache stage. You must specify the `fallback_ttl` field to customize the TTL of the cache.

**Usage:**

```
scw edge-services cache-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| fallback-ttl | Default: `3600s` | Time To Live (TTL) in seconds. Defines how long content is cached |
| backend-stage-id |  | Backend stage ID the cache stage will be linked to |



### Delete cache stage

Delete an existing cache stage, specified by its `cache_stage_id`. Deleting a cache stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services cache-stage delete <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the cache stage to delete |



### Get cache stage

Retrieve information about an existing cache stage, specified by its `cache_stage_id`. Its full details, including Time To Live (TTL), are returned in the response object.

**Usage:**

```
scw edge-services cache-stage get <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the requested cache stage |



### List cache stages

List all cache stages, for a Scaleway Organization or Scaleway Project. By default, the cache stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services cache-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of cache stages in the response |
| pipeline-id |  | Pipeline ID to filter for, only cache stages from this pipeline will be returned |
| project-id |  | Project ID to filter for, only cache stages from this Project will be returned |



### Update cache stage

Update the parameters of an existing cache stage, specified by its `cache_stage_id`. Parameters which can be updated include the `fallback_ttl` and `backend_stage_id`.

**Usage:**

```
scw edge-services cache-stage update <cache-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cache-stage-id | Required | ID of the cache stage to update |
| fallback-ttl |  | Time To Live (TTL) in seconds. Defines how long content is cached |
| backend-stage-id |  | Backend stage ID the cache stage will be linked to |



## DNS-stage management commands

DNS-stage management commands.


### Create DNS stage

Create a new DNS stage. You must specify the `fqdns` field to customize the domain endpoint, using a domain you already own.

**Usage:**

```
scw edge-services dns-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| fqdns.{index} |  | Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage |
| tls-stage-id |  | TLS stage ID the DNS stage will be linked to |
| cache-stage-id |  | Cache stage ID the DNS stage will be linked to |
| backend-stage-id |  | Backend stage ID the DNS stage will be linked to |



### Delete DNS stage

Delete an existing DNS stage, specified by its `dns_stage_id`. Deleting a DNS stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services dns-stage delete <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the DNS stage to delete |



### Get DNS stage

Retrieve information about an existing DNS stage, specified by its `dns_stage_id`. Its full details, including FQDNs, are returned in the response object.

**Usage:**

```
scw edge-services dns-stage get <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the requested DNS stage |



### List DNS stages

List all DNS stages, for a Scaleway Organization or Scaleway Project. By default, the DNS stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services dns-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of DNS stages in the response |
| pipeline-id |  | Pipeline ID to filter for, only DNS stages from this pipeline will be returned |
| project-id |  | Project ID to filter for, only DNS stages from this Project will be returned |
| fqdn |  | Fully Qualified Domain Name to filter for (in the format subdomain.example.com), only DNS stages with this FQDN will be returned |



### Update DNS stage

Update the parameters of an existing DNS stage, specified by its `dns_stage_id`.

**Usage:**

```
scw edge-services dns-stage update <dns-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| dns-stage-id | Required | ID of the DNS stage to update |
| fqdns.{index} |  | Fully Qualified Domain Name (in the format subdomain.example.com) attached to the stage |
| tls-stage-id |  | TLS stage ID the DNS stage will be linked to |
| cache-stage-id |  | Cache stage ID the DNS stage will be linked to |
| backend-stage-id |  | Backend stage ID the DNS stage will be linked to |



## Pipeline management commands

Pipeline management commands.


### Create pipeline

Create a new pipeline. You must specify a `dns_stage_id` to form a stage-chain that goes all the way to the backend stage (origin), so the HTTP request will be processed according to the stages you created.

**Usage:**

```
scw edge-services pipeline create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the pipeline |
| description | Required | Description of the pipeline |
| dns-stage-id |  | DNS stage ID the pipeline will be attached to |



### Delete pipeline

Delete an existing pipeline, specified by its `pipeline_id`. Deleting a pipeline is permanent, and cannot be undone. Note that all stages linked to the pipeline are also deleted.

**Usage:**

```
scw edge-services pipeline delete <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to delete |



### Get pipeline

Retrieve information about an existing pipeline, specified by its `pipeline_id`. Its full details, including errors, are returned in the response object.

**Usage:**

```
scw edge-services pipeline get <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the requested pipeline |



### List pipelines

List all pipelines, for a Scaleway Organization or Scaleway Project. By default, the pipelines returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services pipeline list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of pipelines in the response |
| name |  | Pipeline name to filter for, only pipelines with this string within their name will be returned |
| project-id |  | Project ID to filter for, only pipelines from this Project will be returned |
| has-backend-stage-lb |  | Filter on backend stage, only pipelines with a Load Balancer origin will be returned |
| organization-id |  | Organization ID to filter for, only pipelines from this Organization will be returned |



### Update pipeline

Update the parameters of an existing pipeline, specified by its `pipeline_id`. Parameters which can be updated include the `name`, `description` and `dns_stage_id`.

**Usage:**

```
scw edge-services pipeline update <pipeline-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | ID of the pipeline to update |
| name |  | Name of the pipeline |
| description |  | Description of the pipeline |
| dns-stage-id |  | DNS stage ID the pipeline will be attached to |



## Purge-request management commands

Purge-request management commands.


### Create purge request

Create a new purge request. You must specify either the `all` field (to purge all content) or a list of `assets` (to define the precise assets to purge).

**Usage:**

```
scw edge-services purge-request create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pipeline-id | Required | Pipeline ID in which the purge request will be created |
| assets.{index} |  | List of asserts to purge |
| all |  | Defines whether to purge all content |



### Get purge request

Retrieve information about a purge request, specified by its `purge_request_id`. Its full details, including `status` and `target`, are returned in the response object.

**Usage:**

```
scw edge-services purge-request get <purge-request-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| purge-request-id | Required | ID of the requested purge request |



### List purge requests

List all purge requests, for a Scaleway Organization or Scaleway Project. This enables you to retrieve a history of all previously-made purge requests. By default, the purge requests returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services purge-request list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of purge requests in the response |
| project-id |  | Project ID to filter for, only purge requests from this Project will be returned |
| pipeline-id |  | Pipeline ID to filter for, only purge requests from this pipeline will be returned |
| organization-id |  | Organization ID to filter for, only purge requests from this Project will be returned |



## TLS-stage management commands

TLS-stage management commands.


### Create TLS stage

Create a new TLS stage. You must specify either the `secrets` or `managed_certificate` fields to customize the SSL/TLS certificate of your endpoint. Choose `secrets` if you are using a pre-existing certificate held in Scaleway Secret Manager, or `managed_certificate` to let Scaleway generate and manage a Let's Encrypt certificate for your customized endpoint.

**Usage:**

```
scw edge-services tls-stage create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| secrets.{index}.secret-id |  | ID of the Secret |
| secrets.{index}.region |  | Region of the Secret |
| managed-certificate |  | True when Scaleway generates and manages a Let's Encrypt certificate for the TLS stage/custom endpoint |
| cache-stage-id |  | Cache stage ID the TLS stage will be linked to |
| backend-stage-id |  | Backend stage ID the TLS stage will be linked to |



### Delete TLS stage

Delete an existing TLS stage, specified by its `tls_stage_id`. Deleting a TLS stage is permanent, and cannot be undone.

**Usage:**

```
scw edge-services tls-stage delete <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the TLS stage to delete |



### Get TLS stage

Retrieve information about an existing TLS stage, specified by its `tls_stage_id`. Its full details, including secrets and certificate expiration date are returned in the response object.

**Usage:**

```
scw edge-services tls-stage get <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the requested TLS stage |



### List TLS stages

List all TLS stages, for a Scaleway Organization or Scaleway Project. By default, the TLS stages returned in the list are ordered by creation date in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw edge-services tls-stage list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order of TLS stages in the response |
| pipeline-id |  | Pipeline ID to filter for, only TLS stages from this pipeline will be returned |
| project-id |  | Project ID to filter for, only TLS stages from this Project will be returned |
| secret-id |  | Secret ID to filter for, only TLS stages with this Secret ID will be returned |
| secret-region |  | Secret region to filter for, only TLS stages with a Secret in this region will be returned |



### Update TLS stage

Update the parameters of an existing TLS stage, specified by its `tls_stage_id`. Both `tls_secrets_config` and `managed_certificate` parameters can be updated.

**Usage:**

```
scw edge-services tls-stage update <tls-stage-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| tls-stage-id | Required | ID of the TLS stage to update |
| tls-secrets-config.tls-secrets.{index}.secret-id |  | ID of the Secret |
| tls-secrets-config.tls-secrets.{index}.region |  | Region of the Secret |
| managed-certificate |  | True when Scaleway generates and manages a Let's Encrypt certificate for the TLS stage/custom endpoint |
| cache-stage-id |  | Cache stage ID the TLS stage will be linked to |
| backend-stage-id |  | Backend stage ID the TLS stage will be linked to |



