//
// Code generated by rdl 1.5.1 DO NOT EDIT.
//

package rdl

import (
	"encoding/json"
	"fmt"
)

var _ = json.Marshal
var _ = fmt.Printf

//
// Identifier - All names need to be of this restricted string type
//
type Identifier string

//
// NamespacedIdentifier - A Namespace is a dotted compound name, using reverse
// domain name order (i.e. "com.yahoo.auth")
//
type NamespacedIdentifier string

//
// TypeName - The identifier for an already-defined type
//
type TypeName string

//
// TypeRef - A type reference can be a simple name, or also a namespaced name.
//
type TypeRef string

//
// BaseType -
//
type BaseType int

//
// BaseType constants
//
const (
	_ BaseType = iota
	BaseTypeBool
	BaseTypeInt8
	BaseTypeInt16
	BaseTypeInt32
	BaseTypeInt64
	BaseTypeFloat32
	BaseTypeFloat64
	BaseTypeBytes
	BaseTypeString
	BaseTypeTimestamp
	BaseTypeSymbol
	BaseTypeUUID
	BaseTypeArray
	BaseTypeMap
	BaseTypeStruct
	BaseTypeEnum
	BaseTypeUnion
	BaseTypeAny
)

var namesBaseType = []string{
	BaseTypeBool:      "Bool",
	BaseTypeInt8:      "Int8",
	BaseTypeInt16:     "Int16",
	BaseTypeInt32:     "Int32",
	BaseTypeInt64:     "Int64",
	BaseTypeFloat32:   "Float32",
	BaseTypeFloat64:   "Float64",
	BaseTypeBytes:     "Bytes",
	BaseTypeString:    "String",
	BaseTypeTimestamp: "Timestamp",
	BaseTypeSymbol:    "Symbol",
	BaseTypeUUID:      "UUID",
	BaseTypeArray:     "Array",
	BaseTypeMap:       "Map",
	BaseTypeStruct:    "Struct",
	BaseTypeEnum:      "Enum",
	BaseTypeUnion:     "Union",
	BaseTypeAny:       "Any",
}

//
// NewBaseType - return a string representation of the enum
//
func NewBaseType(init ...interface{}) BaseType {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case BaseType:
			return v
		case int:
			return BaseType(v)
		case int32:
			return BaseType(v)
		case string:
			for i, s := range namesBaseType {
				if s == v {
					return BaseType(i)
				}
			}
		default:
			panic("Bad init value for BaseType enum")
		}
	}
	return BaseType(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e BaseType) String() string {
	return namesBaseType[e]
}

//
// SymbolSet - return an array of all valid string representations (symbols) of the enum
//
func (e BaseType) SymbolSet() []string {
	return namesBaseType
}

//
// MarshalJSON is defined for proper JSON encoding of a BaseType
//
func (e BaseType) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a BaseType
//
func (e *BaseType) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesBaseType {
			if s == s2 {
				*e = BaseType(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type BaseType: %s", s)
	}
	return err
}

//
// ExtendedAnnotation - ExtendedAnnotation - parsed and preserved, but has no
// defined meaning in RDL. Such annotations must begin with "x_", and may have
// an associated string literal value (the value will be "" if the annotation is
// just a flag).
//
type ExtendedAnnotation string

//
// TypeDef - TypeDef is the basic type definition.
//
type TypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewTypeDef - creates an initialized TypeDef instance, returns a pointer to it
//
func NewTypeDef(init ...*TypeDef) *TypeDef {
	var o *TypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(TypeDef)
	}
	return o
}

type rawTypeDef TypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a TypeDef
//
func (self *TypeDef) UnmarshalJSON(b []byte) error {
	var m rawTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := TypeDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *TypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("TypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("TypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("TypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("TypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	return nil
}

//
// AliasTypeDef - AliasTypeDef is used for type definitions that add no
// additional attributes, and thus just create an alias
//
type AliasTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewAliasTypeDef - creates an initialized AliasTypeDef instance, returns a pointer to it
//
func NewAliasTypeDef(init ...*AliasTypeDef) *AliasTypeDef {
	var o *AliasTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(AliasTypeDef)
	}
	return o
}

type rawAliasTypeDef AliasTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a AliasTypeDef
//
func (self *AliasTypeDef) UnmarshalJSON(b []byte) error {
	var m rawAliasTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := AliasTypeDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *AliasTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("AliasTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("AliasTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("AliasTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("AliasTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	return nil
}

//
// BytesTypeDef - Bytes allow the restriction by fixed size, or min/max size.
//
type BytesTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// Fixed size
	//
	Size *int32 `json:"size,omitempty" rdl:"optional"`

	//
	// Min size
	//
	MinSize *int32 `json:"minSize,omitempty" rdl:"optional"`

	//
	// Max size
	//
	MaxSize *int32 `json:"maxSize,omitempty" rdl:"optional"`
}

//
// NewBytesTypeDef - creates an initialized BytesTypeDef instance, returns a pointer to it
//
func NewBytesTypeDef(init ...*BytesTypeDef) *BytesTypeDef {
	var o *BytesTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(BytesTypeDef)
	}
	return o
}

type rawBytesTypeDef BytesTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a BytesTypeDef
//
func (self *BytesTypeDef) UnmarshalJSON(b []byte) error {
	var m rawBytesTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := BytesTypeDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *BytesTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("BytesTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("BytesTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("BytesTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("BytesTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	return nil
}

//
// StringTypeDef - Strings allow the restriction by regular expression pattern
// or by an explicit set of values. An optional maximum size may be asserted
//
type StringTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// A regular expression that must be matched. Mutually exclusive with values
	//
	Pattern string `json:"pattern,omitempty" rdl:"optional"`

	//
	// A set of allowable values
	//
	Values []string `json:"values,omitempty" rdl:"optional"`

	//
	// Min size
	//
	MinSize *int32 `json:"minSize,omitempty" rdl:"optional"`

	//
	// Max size
	//
	MaxSize *int32 `json:"maxSize,omitempty" rdl:"optional"`
}

//
// NewStringTypeDef - creates an initialized StringTypeDef instance, returns a pointer to it
//
func NewStringTypeDef(init ...*StringTypeDef) *StringTypeDef {
	var o *StringTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(StringTypeDef)
	}
	return o
}

type rawStringTypeDef StringTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a StringTypeDef
//
func (self *StringTypeDef) UnmarshalJSON(b []byte) error {
	var m rawStringTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := StringTypeDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *StringTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("StringTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("StringTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("StringTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("StringTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	return nil
}

//
// NumberVariantTag - generated to support Number
//
type NumberVariantTag int

//
// Supporting constants
//
const (
	_ NumberVariantTag = iota
	NumberVariantInt8
	NumberVariantInt16
	NumberVariantInt32
	NumberVariantInt64
	NumberVariantFloat32
	NumberVariantFloat64
)

//
// Number - A numeric is any of the primitive numeric types
//
type Number struct {
	Variant NumberVariantTag `json:"-" rdl:"union"`
	Int8    *int8            `json:"Int8,omitempty"`
	Int16   *int16           `json:"Int16,omitempty"`
	Int32   *int32           `json:"Int32,omitempty"`
	Int64   *int64           `json:"Int64,omitempty"`
	Float32 *float32         `json:"Float32,omitempty"`
	Float64 *float64         `json:"Float64,omitempty"`
}

func (u Number) String() string {
	switch u.Variant {
	case NumberVariantInt8:
		return fmt.Sprintf("%v", u.Int8)
	case NumberVariantInt16:
		return fmt.Sprintf("%v", u.Int16)
	case NumberVariantInt32:
		return fmt.Sprintf("%v", u.Int32)
	case NumberVariantInt64:
		return fmt.Sprintf("%v", u.Int64)
	case NumberVariantFloat32:
		return fmt.Sprintf("%v", u.Float32)
	case NumberVariantFloat64:
		return fmt.Sprintf("%v", u.Float64)
	default:
		return "<Number uninitialized>"
	}
}

//
// Validate for Number
//
func (p *Number) Validate() error {
	if p.Int8 != nil {
		p.Variant = NumberVariantInt8
	} else if p.Int16 != nil {
		p.Variant = NumberVariantInt16
	} else if p.Int32 != nil {
		p.Variant = NumberVariantInt32
	} else if p.Int64 != nil {
		p.Variant = NumberVariantInt64
	} else if p.Float32 != nil {
		p.Variant = NumberVariantFloat32
	} else if p.Float64 != nil {
		p.Variant = NumberVariantFloat64
	} else {
		return fmt.Errorf("Number: Missing required variant")
	}
	return nil
}

type rawNumber Number

//
// UnmarshalJSON for Number
//
func (p *Number) UnmarshalJSON(b []byte) error {
	var tmp rawNumber
	if err := json.Unmarshal(b, &tmp); err != nil {
		return err
	}
	*p = Number(tmp)
	return p.Validate()
}

//
// NumberTypeDef - A number type definition allows the restriction of numeric
// values.
//
type NumberTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// Min value
	//
	Min *Number `json:"min,omitempty" rdl:"optional"`

	//
	// Max value
	//
	Max *Number `json:"max,omitempty" rdl:"optional"`
}

//
// NewNumberTypeDef - creates an initialized NumberTypeDef instance, returns a pointer to it
//
func NewNumberTypeDef(init ...*NumberTypeDef) *NumberTypeDef {
	var o *NumberTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(NumberTypeDef)
	}
	return o
}

type rawNumberTypeDef NumberTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a NumberTypeDef
//
func (self *NumberTypeDef) UnmarshalJSON(b []byte) error {
	var m rawNumberTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := NumberTypeDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *NumberTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("NumberTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("NumberTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("NumberTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("NumberTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	return nil
}

//
// ArrayTypeDef - Array types can be restricted by item type and size
//
type ArrayTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// The type of the items, default to any type
	//
	Items TypeRef `json:"items" rdl:"default=Any"`

	//
	// If present, indicate the fixed size.
	//
	Size *int32 `json:"size,omitempty" rdl:"optional"`

	//
	// If present, indicate the min size
	//
	MinSize *int32 `json:"minSize,omitempty" rdl:"optional"`

	//
	// If present, indicate the max size
	//
	MaxSize *int32 `json:"maxSize,omitempty" rdl:"optional"`
}

//
// NewArrayTypeDef - creates an initialized ArrayTypeDef instance, returns a pointer to it
//
func NewArrayTypeDef(init ...*ArrayTypeDef) *ArrayTypeDef {
	var o *ArrayTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ArrayTypeDef)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *ArrayTypeDef) Init() *ArrayTypeDef {
	if self.Items == "" {
		self.Items = "Any"
	}
	return self
}

type rawArrayTypeDef ArrayTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a ArrayTypeDef
//
func (self *ArrayTypeDef) UnmarshalJSON(b []byte) error {
	var m rawArrayTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ArrayTypeDef(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ArrayTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("ArrayTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("ArrayTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("ArrayTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("ArrayTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	if self.Items == "" {
		return fmt.Errorf("ArrayTypeDef.items is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Items)
		if !val.Valid {
			return fmt.Errorf("ArrayTypeDef.items does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	return nil
}

//
// MapTypeDef - Map types can be restricted by key type, item type and size
//
type MapTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// The type of the keys, default to String.
	//
	Keys TypeRef `json:"keys" rdl:"default=String"`

	//
	// The type of the items, default to Any type
	//
	Items TypeRef `json:"items" rdl:"default=Any"`

	//
	// If present, indicates the fixed size.
	//
	Size *int32 `json:"size,omitempty" rdl:"optional"`

	//
	// If present, indicate the min size
	//
	MinSize *int32 `json:"minSize,omitempty" rdl:"optional"`

	//
	// If present, indicate the max size
	//
	MaxSize *int32 `json:"maxSize,omitempty" rdl:"optional"`
}

//
// NewMapTypeDef - creates an initialized MapTypeDef instance, returns a pointer to it
//
func NewMapTypeDef(init ...*MapTypeDef) *MapTypeDef {
	var o *MapTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(MapTypeDef)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *MapTypeDef) Init() *MapTypeDef {
	if self.Keys == "" {
		self.Keys = "String"
	}
	if self.Items == "" {
		self.Items = "Any"
	}
	return self
}

type rawMapTypeDef MapTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a MapTypeDef
//
func (self *MapTypeDef) UnmarshalJSON(b []byte) error {
	var m rawMapTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := MapTypeDef(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *MapTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("MapTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("MapTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("MapTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("MapTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	if self.Keys == "" {
		return fmt.Errorf("MapTypeDef.keys is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Keys)
		if !val.Valid {
			return fmt.Errorf("MapTypeDef.keys does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Items == "" {
		return fmt.Errorf("MapTypeDef.items is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Items)
		if !val.Valid {
			return fmt.Errorf("MapTypeDef.items does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	return nil
}

//
// StructFieldDef - Each field in a struct_field_spec is defined by this type
//
type StructFieldDef struct {

	//
	// The name of the field
	//
	Name Identifier `json:"name"`

	//
	// The type of the field
	//
	Type TypeRef `json:"type"`

	//
	// The field may be omitted even if specified
	//
	Optional bool `json:"optional,omitempty" rdl:"default=false"`

	//
	// If field is absent, what default value should be assumed.
	//
	Default interface{} `json:"default,omitempty" rdl:"optional"`

	//
	// The comment for the field
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// For map or array fields, the type of the items
	//
	Items TypeRef `json:"items,omitempty" rdl:"optional"`

	//
	// For map type fields, the type of the keys
	//
	Keys TypeRef `json:"keys,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewStructFieldDef - creates an initialized StructFieldDef instance, returns a pointer to it
//
func NewStructFieldDef(init ...*StructFieldDef) *StructFieldDef {
	var o *StructFieldDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(StructFieldDef)
	}
	return o
}

type rawStructFieldDef StructFieldDef

//
// UnmarshalJSON is defined for proper JSON decoding of a StructFieldDef
//
func (self *StructFieldDef) UnmarshalJSON(b []byte) error {
	var m rawStructFieldDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := StructFieldDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *StructFieldDef) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("StructFieldDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "Identifier", self.Name)
		if !val.Valid {
			return fmt.Errorf("StructFieldDef.name does not contain a valid Identifier (%v)", val.Error)
		}
	}
	if self.Type == "" {
		return fmt.Errorf("StructFieldDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("StructFieldDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	return nil
}

//
// StructTypeDef - A struct can restrict specific named fields to specific
// types. By default, any field not specified is allowed, and can be of any
// type. Specifying closed means only those fields explicitly
//
type StructTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// The fields in this struct. By default, open Structs can have any fields in
	// addition to these
	//
	Fields []*StructFieldDef `json:"fields"`

	//
	// indicates that only the specified fields are acceptable. Default is open
	// (any fields)
	//
	Closed bool `json:"closed,omitempty" rdl:"default=false"`
}

//
// NewStructTypeDef - creates an initialized StructTypeDef instance, returns a pointer to it
//
func NewStructTypeDef(init ...*StructTypeDef) *StructTypeDef {
	var o *StructTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(StructTypeDef)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *StructTypeDef) Init() *StructTypeDef {
	if self.Fields == nil {
		self.Fields = make([]*StructFieldDef, 0)
	}
	return self
}

type rawStructTypeDef StructTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a StructTypeDef
//
func (self *StructTypeDef) UnmarshalJSON(b []byte) error {
	var m rawStructTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := StructTypeDef(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *StructTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("StructTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("StructTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("StructTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("StructTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	if self.Fields == nil {
		return fmt.Errorf("StructTypeDef: Missing required field: fields")
	}
	return nil
}

//
// EnumElementDef - EnumElementDef defines one of the elements of an Enum
//
type EnumElementDef struct {

	//
	// The identifier representing the value
	//
	Symbol Identifier `json:"symbol"`

	//
	// the comment for the element
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewEnumElementDef - creates an initialized EnumElementDef instance, returns a pointer to it
//
func NewEnumElementDef(init ...*EnumElementDef) *EnumElementDef {
	var o *EnumElementDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(EnumElementDef)
	}
	return o
}

type rawEnumElementDef EnumElementDef

//
// UnmarshalJSON is defined for proper JSON decoding of a EnumElementDef
//
func (self *EnumElementDef) UnmarshalJSON(b []byte) error {
	var m rawEnumElementDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := EnumElementDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *EnumElementDef) Validate() error {
	if self.Symbol == "" {
		return fmt.Errorf("EnumElementDef.symbol is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "Identifier", self.Symbol)
		if !val.Valid {
			return fmt.Errorf("EnumElementDef.symbol does not contain a valid Identifier (%v)", val.Error)
		}
	}
	return nil
}

//
// EnumTypeDef - Define an enumerated type. Each value of the type is
// represented by a symbolic identifier.
//
type EnumTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// The enumeration of the possible elements
	//
	Elements []*EnumElementDef `json:"elements"`
}

//
// NewEnumTypeDef - creates an initialized EnumTypeDef instance, returns a pointer to it
//
func NewEnumTypeDef(init ...*EnumTypeDef) *EnumTypeDef {
	var o *EnumTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(EnumTypeDef)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *EnumTypeDef) Init() *EnumTypeDef {
	if self.Elements == nil {
		self.Elements = make([]*EnumElementDef, 0)
	}
	return self
}

type rawEnumTypeDef EnumTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a EnumTypeDef
//
func (self *EnumTypeDef) UnmarshalJSON(b []byte) error {
	var m rawEnumTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := EnumTypeDef(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *EnumTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("EnumTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("EnumTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("EnumTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("EnumTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	if self.Elements == nil {
		return fmt.Errorf("EnumTypeDef: Missing required field: elements")
	}
	return nil
}

//
// UnionTypeDef - Define a type as one of any other specified type.
//
type UnionTypeDef struct {

	//
	// The type this type is derived from. For base types, it is the same as the
	// name
	//
	Type TypeRef `json:"type"`

	//
	// The name of the type
	//
	Name TypeName `json:"name"`

	//
	// The comment for the type
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// The type names of constituent types. Union types get expanded, this is a
	// flat list
	//
	Variants []TypeRef `json:"variants"`
}

//
// NewUnionTypeDef - creates an initialized UnionTypeDef instance, returns a pointer to it
//
func NewUnionTypeDef(init ...*UnionTypeDef) *UnionTypeDef {
	var o *UnionTypeDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(UnionTypeDef)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *UnionTypeDef) Init() *UnionTypeDef {
	if self.Variants == nil {
		self.Variants = make([]TypeRef, 0)
	}
	return self
}

type rawUnionTypeDef UnionTypeDef

//
// UnmarshalJSON is defined for proper JSON decoding of a UnionTypeDef
//
func (self *UnionTypeDef) UnmarshalJSON(b []byte) error {
	var m rawUnionTypeDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := UnionTypeDef(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *UnionTypeDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("UnionTypeDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("UnionTypeDef.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("UnionTypeDef.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeName", self.Name)
		if !val.Valid {
			return fmt.Errorf("UnionTypeDef.name does not contain a valid TypeName (%v)", val.Error)
		}
	}
	if self.Variants == nil {
		return fmt.Errorf("UnionTypeDef: Missing required field: variants")
	}
	return nil
}

//
// TypeVariantTag - generated to support Type
//
type TypeVariantTag int

//
// Supporting constants
//
const (
	_ TypeVariantTag = iota
	TypeVariantBaseType
	TypeVariantStructTypeDef
	TypeVariantMapTypeDef
	TypeVariantArrayTypeDef
	TypeVariantEnumTypeDef
	TypeVariantUnionTypeDef
	TypeVariantStringTypeDef
	TypeVariantBytesTypeDef
	TypeVariantNumberTypeDef
	TypeVariantAliasTypeDef
)

//
// Type - A Type can be specified by any of the above specialized Types,
// determined by the value of the the 'type' field
//
type Type struct {
	Variant       TypeVariantTag `json:"-" rdl:"union"`
	BaseType      *BaseType      `json:"BaseType,omitempty"`
	StructTypeDef *StructTypeDef `json:"StructTypeDef,omitempty"`
	MapTypeDef    *MapTypeDef    `json:"MapTypeDef,omitempty"`
	ArrayTypeDef  *ArrayTypeDef  `json:"ArrayTypeDef,omitempty"`
	EnumTypeDef   *EnumTypeDef   `json:"EnumTypeDef,omitempty"`
	UnionTypeDef  *UnionTypeDef  `json:"UnionTypeDef,omitempty"`
	StringTypeDef *StringTypeDef `json:"StringTypeDef,omitempty"`
	BytesTypeDef  *BytesTypeDef  `json:"BytesTypeDef,omitempty"`
	NumberTypeDef *NumberTypeDef `json:"NumberTypeDef,omitempty"`
	AliasTypeDef  *AliasTypeDef  `json:"AliasTypeDef,omitempty"`
}

func (u Type) String() string {
	switch u.Variant {
	case TypeVariantBaseType:
		return fmt.Sprintf("%v", u.BaseType)
	case TypeVariantStructTypeDef:
		return fmt.Sprintf("%v", u.StructTypeDef)
	case TypeVariantMapTypeDef:
		return fmt.Sprintf("%v", u.MapTypeDef)
	case TypeVariantArrayTypeDef:
		return fmt.Sprintf("%v", u.ArrayTypeDef)
	case TypeVariantEnumTypeDef:
		return fmt.Sprintf("%v", u.EnumTypeDef)
	case TypeVariantUnionTypeDef:
		return fmt.Sprintf("%v", u.UnionTypeDef)
	case TypeVariantStringTypeDef:
		return fmt.Sprintf("%v", u.StringTypeDef)
	case TypeVariantBytesTypeDef:
		return fmt.Sprintf("%v", u.BytesTypeDef)
	case TypeVariantNumberTypeDef:
		return fmt.Sprintf("%v", u.NumberTypeDef)
	case TypeVariantAliasTypeDef:
		return fmt.Sprintf("%v", u.AliasTypeDef)
	default:
		return "<Type uninitialized>"
	}
}

//
// Validate for Type
//
func (p *Type) Validate() error {
	if p.BaseType != nil {
		p.Variant = TypeVariantBaseType
	} else if p.StructTypeDef != nil {
		p.Variant = TypeVariantStructTypeDef
	} else if p.MapTypeDef != nil {
		p.Variant = TypeVariantMapTypeDef
	} else if p.ArrayTypeDef != nil {
		p.Variant = TypeVariantArrayTypeDef
	} else if p.EnumTypeDef != nil {
		p.Variant = TypeVariantEnumTypeDef
	} else if p.UnionTypeDef != nil {
		p.Variant = TypeVariantUnionTypeDef
	} else if p.StringTypeDef != nil {
		p.Variant = TypeVariantStringTypeDef
	} else if p.BytesTypeDef != nil {
		p.Variant = TypeVariantBytesTypeDef
	} else if p.NumberTypeDef != nil {
		p.Variant = TypeVariantNumberTypeDef
	} else if p.AliasTypeDef != nil {
		p.Variant = TypeVariantAliasTypeDef
	} else {
		return fmt.Errorf("Type: Missing required variant")
	}
	return nil
}

type rawType Type

//
// UnmarshalJSON for Type
//
func (p *Type) UnmarshalJSON(b []byte) error {
	var tmp rawType
	if err := json.Unmarshal(b, &tmp); err != nil {
		return err
	}
	*p = Type(tmp)
	return p.Validate()
}

//
// ResourceInput - ResourceOutput defines input characteristics of a Resource
//
type ResourceInput struct {

	//
	// the formal name of the input
	//
	Name Identifier `json:"name"`

	//
	// The type of the input
	//
	Type TypeRef `json:"type"`

	//
	// The optional comment
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// true of this input is a path parameter
	//
	PathParam bool `json:"pathParam,omitempty" rdl:"default=false"`

	//
	// if present, the name of the query param name
	//
	QueryParam string `json:"queryParam,omitempty" rdl:"optional"`

	//
	// If present, the name of the header the input is associated with
	//
	Header string `json:"header,omitempty" rdl:"optional"`

	//
	// If present, the pattern associated with the pathParam (i.e. wildcard path
	// matches)
	//
	Pattern string `json:"pattern,omitempty" rdl:"optional"`

	//
	// If present, the default value for optional params
	//
	Default interface{} `json:"default,omitempty" rdl:"optional"`

	//
	// If present, indicates that the input is optional
	//
	Optional bool `json:"optional,omitempty" rdl:"default=false"`

	//
	// If present, indicates the queryparam is of flag style (no value)
	//
	Flag bool `json:"flag,omitempty" rdl:"default=false"`

	//
	// If present, indicates the parameter comes form the implementation context
	//
	Context string `json:"context,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewResourceInput - creates an initialized ResourceInput instance, returns a pointer to it
//
func NewResourceInput(init ...*ResourceInput) *ResourceInput {
	var o *ResourceInput
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ResourceInput)
	}
	return o
}

type rawResourceInput ResourceInput

//
// UnmarshalJSON is defined for proper JSON decoding of a ResourceInput
//
func (self *ResourceInput) UnmarshalJSON(b []byte) error {
	var m rawResourceInput
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ResourceInput(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ResourceInput) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("ResourceInput.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "Identifier", self.Name)
		if !val.Valid {
			return fmt.Errorf("ResourceInput.name does not contain a valid Identifier (%v)", val.Error)
		}
	}
	if self.Type == "" {
		return fmt.Errorf("ResourceInput.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("ResourceInput.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	return nil
}

//
// ResourceOutput - ResourceOutput defines output characteristics of a Resource
//
type ResourceOutput struct {

	//
	// the formal name of the output
	//
	Name Identifier `json:"name"`

	//
	// The type of the output
	//
	Type TypeRef `json:"type"`

	//
	// the name of the header associated with this output
	//
	Header string `json:"header"`

	//
	// The optional comment for the output
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// If present, indicates that the output is optional (the server decides)
	//
	Optional bool `json:"optional,omitempty" rdl:"default=false"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewResourceOutput - creates an initialized ResourceOutput instance, returns a pointer to it
//
func NewResourceOutput(init ...*ResourceOutput) *ResourceOutput {
	var o *ResourceOutput
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ResourceOutput)
	}
	return o
}

type rawResourceOutput ResourceOutput

//
// UnmarshalJSON is defined for proper JSON decoding of a ResourceOutput
//
func (self *ResourceOutput) UnmarshalJSON(b []byte) error {
	var m rawResourceOutput
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ResourceOutput(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ResourceOutput) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("ResourceOutput.name is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "Identifier", self.Name)
		if !val.Valid {
			return fmt.Errorf("ResourceOutput.name does not contain a valid Identifier (%v)", val.Error)
		}
	}
	if self.Type == "" {
		return fmt.Errorf("ResourceOutput.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("ResourceOutput.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Header == "" {
		return fmt.Errorf("ResourceOutput.header is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "String", self.Header)
		if !val.Valid {
			return fmt.Errorf("ResourceOutput.header does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// ResourceAuth - ResourceAuth defines authentication and authorization
// attributes of a resource. Presence of action, resource, or domain implies
// authentication; the authentication flag alone is required only when no
// authorization is done.
//
type ResourceAuth struct {

	//
	// if present and true, then the requester must be authenticated
	//
	Authenticate bool `json:"authenticate,omitempty" rdl:"default=false"`

	//
	// the action to authorize access to. This forces authentication
	//
	Action string `json:"action,omitempty" rdl:"optional"`

	//
	// the resource identity to authorize access to
	//
	Resource string `json:"resource,omitempty" rdl:"optional"`

	//
	// if present, the alternate domain to check access to. This is rare.
	//
	Domain string `json:"domain,omitempty" rdl:"optional"`
}

//
// NewResourceAuth - creates an initialized ResourceAuth instance, returns a pointer to it
//
func NewResourceAuth(init ...*ResourceAuth) *ResourceAuth {
	var o *ResourceAuth
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ResourceAuth)
	}
	return o
}

type rawResourceAuth ResourceAuth

//
// UnmarshalJSON is defined for proper JSON decoding of a ResourceAuth
//
func (self *ResourceAuth) UnmarshalJSON(b []byte) error {
	var m rawResourceAuth
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ResourceAuth(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ResourceAuth) Validate() error {
	return nil
}

//
// ExceptionDef - ExceptionDef describes the exception a symbolic response code
// maps to.
//
type ExceptionDef struct {

	//
	// The type of the exception
	//
	Type string `json:"type"`

	//
	// the optional comment for the exception
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`
}

//
// NewExceptionDef - creates an initialized ExceptionDef instance, returns a pointer to it
//
func NewExceptionDef(init ...*ExceptionDef) *ExceptionDef {
	var o *ExceptionDef
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ExceptionDef)
	}
	return o
}

type rawExceptionDef ExceptionDef

//
// UnmarshalJSON is defined for proper JSON decoding of a ExceptionDef
//
func (self *ExceptionDef) UnmarshalJSON(b []byte) error {
	var m rawExceptionDef
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ExceptionDef(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ExceptionDef) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("ExceptionDef.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "String", self.Type)
		if !val.Valid {
			return fmt.Errorf("ExceptionDef.type does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// Resource - A Resource of a REST service
//
type Resource struct {

	//
	// The type of the resource
	//
	Type TypeRef `json:"type"`

	//
	// The method for the action (typically GET, POST, etc for HTTP access)
	//
	Method string `json:"method"`

	//
	// The resource path template
	//
	Path string `json:"path"`

	//
	// The optional comment
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// An Array named inputs
	//
	Inputs []*ResourceInput `json:"inputs,omitempty" rdl:"optional"`

	//
	// An Array of named outputs
	//
	Outputs []*ResourceOutput `json:"outputs,omitempty" rdl:"optional"`

	//
	// The optional authentication or authorization directive
	//
	Auth *ResourceAuth `json:"auth,omitempty" rdl:"optional"`

	//
	// The expected symbolic response code
	//
	Expected string `json:"expected" rdl:"default=OK"`

	//
	// The set of alternative but non-error response codes
	//
	Alternatives []string `json:"alternatives,omitempty" rdl:"optional"`

	//
	// A map of symbolic response code to Exception definitions
	//
	Exceptions map[string]*ExceptionDef `json:"exceptions,omitempty" rdl:"optional"`

	//
	// A hint to server implementations that this resource would be better
	// implemented with async I/O
	//
	Async *bool `json:"async,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`

	//
	// Optional hint for resource acceptable input types
	//
	Consumes []string `json:"consumes,omitempty" rdl:"optional"`

	//
	// Optional hint for resource output content types
	//
	Produces []string `json:"produces,omitempty" rdl:"optional"`

	//
	// The optional name of the resource
	//
	Name Identifier `json:"name,omitempty" rdl:"optional"`
}

//
// NewResource - creates an initialized Resource instance, returns a pointer to it
//
func NewResource(init ...*Resource) *Resource {
	var o *Resource
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Resource)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *Resource) Init() *Resource {
	if self.Expected == "" {
		self.Expected = "OK"
	}
	return self
}

type rawResource Resource

//
// UnmarshalJSON is defined for proper JSON decoding of a Resource
//
func (self *Resource) UnmarshalJSON(b []byte) error {
	var m rawResource
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Resource(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Resource) Validate() error {
	if self.Type == "" {
		return fmt.Errorf("Resource.type is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "TypeRef", self.Type)
		if !val.Valid {
			return fmt.Errorf("Resource.type does not contain a valid TypeRef (%v)", val.Error)
		}
	}
	if self.Method == "" {
		return fmt.Errorf("Resource.method is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "String", self.Method)
		if !val.Valid {
			return fmt.Errorf("Resource.method does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Path == "" {
		return fmt.Errorf("Resource.path is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "String", self.Path)
		if !val.Valid {
			return fmt.Errorf("Resource.path does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Expected == "" {
		return fmt.Errorf("Resource.expected is missing but is a required field")
	} else {
		val := Validate(RdlSchema(), "String", self.Expected)
		if !val.Valid {
			return fmt.Errorf("Resource.expected does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// Schema - A Schema is a container for types and resources. It is
// self-contained (no external references). and is the output of the RDL parser.
//
type Schema struct {

	//
	// The namespace for the schema
	//
	Namespace NamespacedIdentifier `json:"namespace,omitempty" rdl:"optional"`

	//
	// The name of the schema
	//
	Name Identifier `json:"name,omitempty" rdl:"optional"`

	//
	// The version of the schema
	//
	Version *int32 `json:"version,omitempty" rdl:"optional"`

	//
	// The comment for the entire schema
	//
	Comment string `json:"comment,omitempty" rdl:"optional"`

	//
	// The types this schema defines.
	//
	Types []*Type `json:"types,omitempty" rdl:"optional"`

	//
	// The resources for a service this schema defines
	//
	Resources []*Resource `json:"resources,omitempty" rdl:"optional"`

	//
	// the base path for resources in the schema.
	//
	Base string `json:"base,omitempty" rdl:"optional"`

	//
	// additional annotations starting with "x_"
	//
	Annotations map[ExtendedAnnotation]string `json:"annotations,omitempty" rdl:"optional"`
}

//
// NewSchema - creates an initialized Schema instance, returns a pointer to it
//
func NewSchema(init ...*Schema) *Schema {
	var o *Schema
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Schema)
	}
	return o
}

type rawSchema Schema

//
// UnmarshalJSON is defined for proper JSON decoding of a Schema
//
func (self *Schema) UnmarshalJSON(b []byte) error {
	var m rawSchema
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Schema(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Schema) Validate() error {
	return nil
}
