// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Stops an Amazon EBS-backed instance. You can restart your instance at any time
// using the [StartInstances]API. For more information, see [Stop and start Amazon EC2 instances] in the Amazon EC2 User Guide.
//
// When you stop an instance, we shut it down.
//
// You can use the Stop operation together with the Hibernate parameter to
// hibernate an instance if the instance is [enabled for hibernation]and meets the [hibernation prerequisites]. Stopping an instance
// doesn't preserve data stored in RAM, while hibernation does. If hibernation
// fails, a normal shutdown occurs. For more information, see [Hibernate your Amazon EC2 instance]in the Amazon EC2
// User Guide.
//
// If your instance appears stuck in the stopping state, there might be an issue
// with the underlying host computer. You can use the Stop operation together with
// the Force parameter to force stop your instance. For more information, see [Troubleshoot Amazon EC2 instance stop issues]in
// the Amazon EC2 User Guide.
//
// Stopping and hibernating an instance differs from rebooting or terminating it.
// For example, a stopped or hibernated instance retains its root volume and any
// data volumes, unlike terminated instances where these volumes are automatically
// deleted. For more information about the differences between stopping,
// hibernating, rebooting, and terminating instances, see [Amazon EC2 instance state changes]in the Amazon EC2 User
// Guide.
//
// We don't charge for instance usage or data transfer fees when an instance is
// stopped. However, the root volume and any data volumes remain and continue to
// persist your data, and you're charged for volume usage. Every time you start
// your instance, Amazon EC2 charges a one-minute minimum for instance usage,
// followed by per-second billing.
//
// You can't stop or hibernate instance store-backed instances.
//
// [Troubleshoot Amazon EC2 instance stop issues]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html
// [Stop and start Amazon EC2 instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html
// [Hibernate your Amazon EC2 instance]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html
// [Amazon EC2 instance state changes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html
// [enabled for hibernation]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enabling-hibernation.html
// [StartInstances]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartInstances.html
// [hibernation prerequisites]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html
func (c *Client) StopInstances(ctx context.Context, params *StopInstancesInput, optFns ...func(*Options)) (*StopInstancesOutput, error) {
	if params == nil {
		params = &StopInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StopInstances", params, optFns, c.addOperationStopInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StopInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StopInstancesInput struct {

	// The IDs of the instances.
	//
	// This member is required.
	InstanceIds []string

	// Checks whether you have the required permissions for the operation, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Forces the instance to stop. The instance will first attempt a graceful
	// shutdown, which includes flushing file system caches and metadata. If the
	// graceful shutdown fails to complete within the timeout period, the instance
	// shuts down forcibly without flushing the file system caches and metadata.
	//
	// After using this option, you must perform file system check and repair
	// procedures. This option is not recommended for Windows instances. For more
	// information, see [Troubleshoot Amazon EC2 instance stop issues]in the Amazon EC2 User Guide.
	//
	// Default: false
	//
	// [Troubleshoot Amazon EC2 instance stop issues]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html
	Force *bool

	// Hibernates the instance if the instance was enabled for hibernation at launch.
	// If the instance cannot hibernate successfully, a normal shutdown occurs. For
	// more information, see [Hibernate your instance]in the Amazon EC2 User Guide.
	//
	// Default: false
	//
	// [Hibernate your instance]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html
	Hibernate *bool

	noSmithyDocumentSerde
}

type StopInstancesOutput struct {

	// Information about the stopped instances.
	StoppingInstances []types.InstanceStateChange

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStopInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpStopInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpStopInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StopInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStopInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStopInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStopInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StopInstances",
	}
}
