
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create keypair

Add a CA certificate and private key to a keyset.

### Synopsis

Add a CA certificate and private key to a keyset.

 If neither a certificate nor a private key is provided, a new self-signed certificate and private key will be generated.

 If no certificate is provided but a private key is, a self-signed certificate will be generated from the provided private key.

 If a certificate is provided but no private key is, the certificate will be added to the keyset without a private key. Such a certificate cannot be made primary.

 One of the certificate/private key pairs in each keyset must be primary. The primary keypair is the one used to issue certificates (or, for the "service-account" keyset, service-account tokens). As a consequence, a keypair added to an empty keyset must be made primary.

 If the keyset is specified as "all", a newly generated secondary certificate and private key will be added to each rotatable keyset.

```
kops create keypair {KEYSET | all} [flags]
```

### Examples

```
  # Add a CA certificate and private key to a keyset.
  kops create keypair kubernetes-ca \
  --cert ~/ca.pem --key ~/ca-key.pem \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Add a newly generated certificate and private key to each rotatable keyset.
  kops create keypair all \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
      --cert string   Path to CA certificate
  -h, --help          help for keypair
      --key string    Path to CA private key
      --primary       Make the keypair the one used to issue certificates
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create](kops_create.md)	 - Create a resource by command line, filename or stdin.

