// Copyright 2020 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: intoto.proto

package intoto_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This contains the fields corresponding to the definition of a software supply
// chain step in an in-toto layout. This information goes into a Grafeas note.
type InToto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field identifies the name of the step in the supply chain.
	StepName string `protobuf:"bytes,1,opt,name=step_name,json=stepName,proto3" json:"step_name,omitempty"`
	// This field contains the public keys that can be used to verify the
	// signatures on the step metadata.
	SigningKeys []*SigningKey `protobuf:"bytes,2,rep,name=signing_keys,json=signingKeys,proto3" json:"signing_keys,omitempty"`
	// The following fields contain in-toto artifact rules identifying the
	// artifacts that enter this supply chain step, and exit the supply chain
	// step, i.e. materials and products of the step.
	ExpectedMaterials []*InToto_ArtifactRule `protobuf:"bytes,3,rep,name=expected_materials,json=expectedMaterials,proto3" json:"expected_materials,omitempty"`
	ExpectedProducts  []*InToto_ArtifactRule `protobuf:"bytes,4,rep,name=expected_products,json=expectedProducts,proto3" json:"expected_products,omitempty"`
	// This field contains the expected command used to perform the step.
	ExpectedCommand []string `protobuf:"bytes,5,rep,name=expected_command,json=expectedCommand,proto3" json:"expected_command,omitempty"`
	// This field contains a value that indicates the minimum number of keys that
	// need to be used to sign the step's in-toto link.
	Threshold int64 `protobuf:"varint,6,opt,name=threshold,proto3" json:"threshold,omitempty"`
}

func (x *InToto) Reset() {
	*x = InToto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InToto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InToto) ProtoMessage() {}

func (x *InToto) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InToto.ProtoReflect.Descriptor instead.
func (*InToto) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{0}
}

func (x *InToto) GetStepName() string {
	if x != nil {
		return x.StepName
	}
	return ""
}

func (x *InToto) GetSigningKeys() []*SigningKey {
	if x != nil {
		return x.SigningKeys
	}
	return nil
}

func (x *InToto) GetExpectedMaterials() []*InToto_ArtifactRule {
	if x != nil {
		return x.ExpectedMaterials
	}
	return nil
}

func (x *InToto) GetExpectedProducts() []*InToto_ArtifactRule {
	if x != nil {
		return x.ExpectedProducts
	}
	return nil
}

func (x *InToto) GetExpectedCommand() []string {
	if x != nil {
		return x.ExpectedCommand
	}
	return nil
}

func (x *InToto) GetThreshold() int64 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

// This defines the format used to record keys used in the software supply
// chain. An in-toto link is attested using one or more keys defined in the
// in-toto layout. An example of this is:
// {
//   "key_id": "776a00e29f3559e0141b3b096f696abc6cfb0c657ab40f441132b345b0...",
//   "key_type": "rsa",
//   "public_key_value": "-----BEGIN PUBLIC KEY-----\nMIIBojANBgkqhkiG9w0B...",
//   "key_scheme": "rsassa-pss-sha256"
// }
// The format for in-toto's key definition can be found in section 4.2 of the
// in-toto specification.
type SigningKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// key_id is an identifier for the signing key.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// This field identifies the specific signing method. Eg: "rsa", "ed25519",
	// and "ecdsa".
	KeyType string `protobuf:"bytes,2,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty"`
	// This field contains the actual public key.
	PublicKeyValue string `protobuf:"bytes,3,opt,name=public_key_value,json=publicKeyValue,proto3" json:"public_key_value,omitempty"`
	// This field contains the corresponding signature scheme.
	// Eg: "rsassa-pss-sha256".
	KeyScheme string `protobuf:"bytes,4,opt,name=key_scheme,json=keyScheme,proto3" json:"key_scheme,omitempty"`
}

func (x *SigningKey) Reset() {
	*x = SigningKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningKey) ProtoMessage() {}

func (x *SigningKey) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningKey.ProtoReflect.Descriptor instead.
func (*SigningKey) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{1}
}

func (x *SigningKey) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *SigningKey) GetKeyType() string {
	if x != nil {
		return x.KeyType
	}
	return ""
}

func (x *SigningKey) GetPublicKeyValue() string {
	if x != nil {
		return x.PublicKeyValue
	}
	return ""
}

func (x *SigningKey) GetKeyScheme() string {
	if x != nil {
		return x.KeyScheme
	}
	return ""
}

// This corresponds to a signed in-toto link - it is made up of one or more
// signatures and the in-toto link itself. This is used for occurrences of a
// Grafeas in-toto note.
type Details struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Signatures []*Signature `protobuf:"bytes,1,rep,name=signatures,proto3" json:"signatures,omitempty"`
	Link       *Link        `protobuf:"bytes,2,opt,name=link,json=signed,proto3" json:"link,omitempty"`
}

func (x *Details) Reset() {
	*x = Details{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Details) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Details) ProtoMessage() {}

func (x *Details) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Details.ProtoReflect.Descriptor instead.
func (*Details) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{2}
}

func (x *Details) GetSignatures() []*Signature {
	if x != nil {
		return x.Signatures
	}
	return nil
}

func (x *Details) GetLink() *Link {
	if x != nil {
		return x.Link
	}
	return nil
}

// A signature object consists of the KeyID used and the signature itself.
type Signature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyId     string `protobuf:"bytes,1,opt,name=key_id,json=keyid,proto3" json:"key_id,omitempty"`
	Signature string `protobuf:"bytes,2,opt,name=signature,json=sig,proto3" json:"signature,omitempty"`
}

func (x *Signature) Reset() {
	*x = Signature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signature.ProtoReflect.Descriptor instead.
func (*Signature) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{3}
}

func (x *Signature) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *Signature) GetSignature() string {
	if x != nil {
		return x.Signature
	}
	return ""
}

// This corresponds to an in-toto link.
type Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field contains the full command executed for the step. This can also
	// be empty if links are generated for operations that aren't directly mapped
	// to a specific command. Each term in the command is an independent string
	// in the list. An example of a command in the in-toto metadata field is:
	// "command": ["git", "clone", "https://github.com/in-toto/demo-project.git"]
	EffectiveCommand []string `protobuf:"bytes,1,rep,name=effective_command,json=command,proto3" json:"effective_command,omitempty"`
	// Materials are the supply chain artifacts that go into the step and are used
	// for the operation performed. The key of the map is the path of the artifact
	// and the structure contains the recorded hash information. An example is:
	// "materials": [
	//   {
	//     "resource_uri": "foo/bar",
	//     "hashes": {
	//       "sha256": "ebebf...",
	//       <OTHER HASH ALGORITHMS>: <HASH VALUE>
	//     }
	//   }
	// ]
	Materials []*Link_Artifact `protobuf:"bytes,2,rep,name=materials,proto3" json:"materials,omitempty"`
	// Products are the supply chain artifacts generated as a result of the step.
	// The structure is identical to that of materials.
	Products []*Link_Artifact `protobuf:"bytes,3,rep,name=products,proto3" json:"products,omitempty"`
	// ByProducts are data generated as part of a software supply chain step, but
	// are not the actual result of the step.
	Byproducts *Link_ByProducts `protobuf:"bytes,4,opt,name=byproducts,proto3" json:"byproducts,omitempty"`
	// This is a field that can be used to capture information about the
	// environment. It is suggested for this field to contain information that
	// details environment variables, filesystem information, and the present
	// working directory. The recommended structure of this field is:
	// "environment": {
	//   "custom_values": {
	//     "variables": "<ENV>",
	//     "filesystem": "<FS>",
	//     "workdir": "<CWD>",
	//     "<ANY OTHER RELEVANT FIELDS>": "..."
	//   }
	// }
	Environment *Link_Environment `protobuf:"bytes,5,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *Link) Reset() {
	*x = Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link) ProtoMessage() {}

func (x *Link) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link.ProtoReflect.Descriptor instead.
func (*Link) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{4}
}

func (x *Link) GetEffectiveCommand() []string {
	if x != nil {
		return x.EffectiveCommand
	}
	return nil
}

func (x *Link) GetMaterials() []*Link_Artifact {
	if x != nil {
		return x.Materials
	}
	return nil
}

func (x *Link) GetProducts() []*Link_Artifact {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *Link) GetByproducts() *Link_ByProducts {
	if x != nil {
		return x.Byproducts
	}
	return nil
}

func (x *Link) GetEnvironment() *Link_Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

// Defines an object to declare an in-toto artifact rule
type InToto_ArtifactRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ArtifactRule []string `protobuf:"bytes,1,rep,name=artifact_rule,json=artifactRule,proto3" json:"artifact_rule,omitempty"`
}

func (x *InToto_ArtifactRule) Reset() {
	*x = InToto_ArtifactRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InToto_ArtifactRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InToto_ArtifactRule) ProtoMessage() {}

func (x *InToto_ArtifactRule) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InToto_ArtifactRule.ProtoReflect.Descriptor instead.
func (*InToto_ArtifactRule) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{0, 0}
}

func (x *InToto_ArtifactRule) GetArtifactRule() []string {
	if x != nil {
		return x.ArtifactRule
	}
	return nil
}

// Defines a hash object for use in Materials and Products.
type Link_ArtifactHashes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sha256 string `protobuf:"bytes,1,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *Link_ArtifactHashes) Reset() {
	*x = Link_ArtifactHashes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link_ArtifactHashes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link_ArtifactHashes) ProtoMessage() {}

func (x *Link_ArtifactHashes) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link_ArtifactHashes.ProtoReflect.Descriptor instead.
func (*Link_ArtifactHashes) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Link_ArtifactHashes) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

type Link_Artifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResourceUri string               `protobuf:"bytes,1,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	Hashes      *Link_ArtifactHashes `protobuf:"bytes,2,opt,name=hashes,proto3" json:"hashes,omitempty"`
}

func (x *Link_Artifact) Reset() {
	*x = Link_Artifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link_Artifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link_Artifact) ProtoMessage() {}

func (x *Link_Artifact) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link_Artifact.ProtoReflect.Descriptor instead.
func (*Link_Artifact) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Link_Artifact) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *Link_Artifact) GetHashes() *Link_ArtifactHashes {
	if x != nil {
		return x.Hashes
	}
	return nil
}

// Defines an object for the byproducts field in in-toto links. The suggested
// fields are "stderr", "stdout", and "return-value".
type Link_ByProducts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CustomValues map[string]string `protobuf:"bytes,1,rep,name=custom_values,json=customValues,proto3" json:"custom_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Link_ByProducts) Reset() {
	*x = Link_ByProducts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link_ByProducts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link_ByProducts) ProtoMessage() {}

func (x *Link_ByProducts) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link_ByProducts.ProtoReflect.Descriptor instead.
func (*Link_ByProducts) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Link_ByProducts) GetCustomValues() map[string]string {
	if x != nil {
		return x.CustomValues
	}
	return nil
}

// Defines an object for the environment field in in-toto links. The suggested
// fields are "variables", "filesystem", and "workdir".
type Link_Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CustomValues map[string]string `protobuf:"bytes,1,rep,name=custom_values,json=customValues,proto3" json:"custom_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Link_Environment) Reset() {
	*x = Link_Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_intoto_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link_Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link_Environment) ProtoMessage() {}

func (x *Link_Environment) ProtoReflect() protoreflect.Message {
	mi := &file_intoto_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link_Environment.ProtoReflect.Descriptor instead.
func (*Link_Environment) Descriptor() ([]byte, []int) {
	return file_intoto_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Link_Environment) GetCustomValues() map[string]string {
	if x != nil {
		return x.CustomValues
	}
	return nil
}

var File_intoto_proto protoreflect.FileDescriptor

var file_intoto_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x22, 0xa0, 0x03, 0x0a, 0x06, 0x49, 0x6e, 0x54, 0x6f, 0x74,
	0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x65, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45,
	0x0a, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x52, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e,
	0x67, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x5a, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74,
	0x6f, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x11,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x58, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69,
	0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x10, 0x65, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x65,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x1a, 0x33, 0x0a, 0x0c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x75, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x0a, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12,
	0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x07, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x41, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x22, 0x3a, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73,
	0x69, 0x67, 0x22, 0xc7, 0x06, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x22, 0x0a, 0x11, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12,
	0x43, 0x0a, 0x09, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x69, 0x6e, 0x6b,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e,
	0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x0a, 0x62, 0x79, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e,
	0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x42, 0x79, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x52, 0x0a, 0x62, 0x79, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c,
	0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x28, 0x0a, 0x0e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x1a, 0x72, 0x0a, 0x08, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x06, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c,
	0x69, 0x6e, 0x6b, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x48, 0x61, 0x73, 0x68,
	0x65, 0x73, 0x52, 0x06, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x1a, 0xad, 0x01, 0x0a, 0x0a, 0x42,
	0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x0d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x42,
	0x79, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xaf, 0x01, 0x0a, 0x0b, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x0d, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x2e,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x6f, 0x0a, 0x19,
	0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x42, 0x10, 0x49, 0x6e, 0x54, 0x6f, 0x74,
	0x6f, 0x4f, 0x75, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x50, 0x01, 0x5a, 0x38, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x5f, 0x67,
	0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_intoto_proto_rawDescOnce sync.Once
	file_intoto_proto_rawDescData = file_intoto_proto_rawDesc
)

func file_intoto_proto_rawDescGZIP() []byte {
	file_intoto_proto_rawDescOnce.Do(func() {
		file_intoto_proto_rawDescData = protoimpl.X.CompressGZIP(file_intoto_proto_rawDescData)
	})
	return file_intoto_proto_rawDescData
}

var file_intoto_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_intoto_proto_goTypes = []interface{}{
	(*InToto)(nil),              // 0: grafeas.v1beta1.intoto.InToto
	(*SigningKey)(nil),          // 1: grafeas.v1beta1.intoto.SigningKey
	(*Details)(nil),             // 2: grafeas.v1beta1.intoto.Details
	(*Signature)(nil),           // 3: grafeas.v1beta1.intoto.Signature
	(*Link)(nil),                // 4: grafeas.v1beta1.intoto.Link
	(*InToto_ArtifactRule)(nil), // 5: grafeas.v1beta1.intoto.InToto.ArtifactRule
	(*Link_ArtifactHashes)(nil), // 6: grafeas.v1beta1.intoto.Link.ArtifactHashes
	(*Link_Artifact)(nil),       // 7: grafeas.v1beta1.intoto.Link.Artifact
	(*Link_ByProducts)(nil),     // 8: grafeas.v1beta1.intoto.Link.ByProducts
	(*Link_Environment)(nil),    // 9: grafeas.v1beta1.intoto.Link.Environment
	nil,                         // 10: grafeas.v1beta1.intoto.Link.ByProducts.CustomValuesEntry
	nil,                         // 11: grafeas.v1beta1.intoto.Link.Environment.CustomValuesEntry
}
var file_intoto_proto_depIdxs = []int32{
	1,  // 0: grafeas.v1beta1.intoto.InToto.signing_keys:type_name -> grafeas.v1beta1.intoto.SigningKey
	5,  // 1: grafeas.v1beta1.intoto.InToto.expected_materials:type_name -> grafeas.v1beta1.intoto.InToto.ArtifactRule
	5,  // 2: grafeas.v1beta1.intoto.InToto.expected_products:type_name -> grafeas.v1beta1.intoto.InToto.ArtifactRule
	3,  // 3: grafeas.v1beta1.intoto.Details.signatures:type_name -> grafeas.v1beta1.intoto.Signature
	4,  // 4: grafeas.v1beta1.intoto.Details.link:type_name -> grafeas.v1beta1.intoto.Link
	7,  // 5: grafeas.v1beta1.intoto.Link.materials:type_name -> grafeas.v1beta1.intoto.Link.Artifact
	7,  // 6: grafeas.v1beta1.intoto.Link.products:type_name -> grafeas.v1beta1.intoto.Link.Artifact
	8,  // 7: grafeas.v1beta1.intoto.Link.byproducts:type_name -> grafeas.v1beta1.intoto.Link.ByProducts
	9,  // 8: grafeas.v1beta1.intoto.Link.environment:type_name -> grafeas.v1beta1.intoto.Link.Environment
	6,  // 9: grafeas.v1beta1.intoto.Link.Artifact.hashes:type_name -> grafeas.v1beta1.intoto.Link.ArtifactHashes
	10, // 10: grafeas.v1beta1.intoto.Link.ByProducts.custom_values:type_name -> grafeas.v1beta1.intoto.Link.ByProducts.CustomValuesEntry
	11, // 11: grafeas.v1beta1.intoto.Link.Environment.custom_values:type_name -> grafeas.v1beta1.intoto.Link.Environment.CustomValuesEntry
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_intoto_proto_init() }
func file_intoto_proto_init() {
	if File_intoto_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_intoto_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InToto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigningKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Details); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InToto_ArtifactRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link_ArtifactHashes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link_Artifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link_ByProducts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_intoto_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link_Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_intoto_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_intoto_proto_goTypes,
		DependencyIndexes: file_intoto_proto_depIdxs,
		MessageInfos:      file_intoto_proto_msgTypes,
	}.Build()
	File_intoto_proto = out.File
	file_intoto_proto_rawDesc = nil
	file_intoto_proto_goTypes = nil
	file_intoto_proto_depIdxs = nil
}
