// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches group profiles in Amazon DataZone.
func (c *Client) SearchGroupProfiles(ctx context.Context, params *SearchGroupProfilesInput, optFns ...func(*Options)) (*SearchGroupProfilesOutput, error) {
	if params == nil {
		params = &SearchGroupProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchGroupProfiles", params, optFns, c.addOperationSearchGroupProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchGroupProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchGroupProfilesInput struct {

	// The identifier of the Amazon DataZone domain in which you want to search group
	// profiles.
	//
	// This member is required.
	DomainIdentifier *string

	// The group type for which to search.
	//
	// This member is required.
	GroupType types.GroupSearchType

	// The maximum number of results to return in a single call to SearchGroupProfiles
	// . When the number of results to be listed is greater than the value of
	// MaxResults , the response contains a NextToken value that you can use in a
	// subsequent call to SearchGroupProfiles to list the next set of results.
	MaxResults *int32

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// SearchGroupProfiles to list the next set of results.
	NextToken *string

	// Specifies the text for which to search.
	SearchText *string

	noSmithyDocumentSerde
}

type SearchGroupProfilesOutput struct {

	// The results of the SearchGroupProfiles action.
	Items []types.GroupProfileSummary

	// When the number of results is greater than the default value for the MaxResults
	// parameter, or if you explicitly specify a value for MaxResults that is less
	// than the number of results, the response includes a pagination token named
	// NextToken . You can specify this NextToken value in a subsequent call to
	// SearchGroupProfiles to list the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchGroupProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchGroupProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchGroupProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchGroupProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchGroupProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchGroupProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// SearchGroupProfilesPaginatorOptions is the paginator options for
// SearchGroupProfiles
type SearchGroupProfilesPaginatorOptions struct {
	// The maximum number of results to return in a single call to SearchGroupProfiles
	// . When the number of results to be listed is greater than the value of
	// MaxResults , the response contains a NextToken value that you can use in a
	// subsequent call to SearchGroupProfiles to list the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchGroupProfilesPaginator is a paginator for SearchGroupProfiles
type SearchGroupProfilesPaginator struct {
	options   SearchGroupProfilesPaginatorOptions
	client    SearchGroupProfilesAPIClient
	params    *SearchGroupProfilesInput
	nextToken *string
	firstPage bool
}

// NewSearchGroupProfilesPaginator returns a new SearchGroupProfilesPaginator
func NewSearchGroupProfilesPaginator(client SearchGroupProfilesAPIClient, params *SearchGroupProfilesInput, optFns ...func(*SearchGroupProfilesPaginatorOptions)) *SearchGroupProfilesPaginator {
	if params == nil {
		params = &SearchGroupProfilesInput{}
	}

	options := SearchGroupProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchGroupProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchGroupProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchGroupProfiles page.
func (p *SearchGroupProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchGroupProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchGroupProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchGroupProfilesAPIClient is a client that implements the
// SearchGroupProfiles operation.
type SearchGroupProfilesAPIClient interface {
	SearchGroupProfiles(context.Context, *SearchGroupProfilesInput, ...func(*Options)) (*SearchGroupProfilesOutput, error)
}

var _ SearchGroupProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchGroupProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchGroupProfiles",
	}
}
