// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides a pre-signed URL for download of an approved attached file. This API
// also returns metadata about the attached file. It will only return a downloadURL
// if the status of the attached file is APPROVED .
func (c *Client) GetAttachedFile(ctx context.Context, params *GetAttachedFileInput, optFns ...func(*Options)) (*GetAttachedFileOutput, error) {
	if params == nil {
		params = &GetAttachedFileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAttachedFile", params, optFns, c.addOperationGetAttachedFileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAttachedFileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Request to GetAttachedFile API.
type GetAttachedFileInput struct {

	// The resource to which the attached file is (being) uploaded to. The supported
	// resources are [Cases]and [Email].
	//
	// This value must be a valid ARN.
	//
	// [Email]: https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html
	// [Cases]: https://docs.aws.amazon.com/connect/latest/adminguide/cases.html
	//
	// This member is required.
	AssociatedResourceArn *string

	// The unique identifier of the attached file resource.
	//
	// This member is required.
	FileId *string

	// The unique identifier of the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// Optional override for the expiry of the pre-signed S3 URL in seconds. The
	// default value is 300.
	UrlExpiryInSeconds *int32

	noSmithyDocumentSerde
}

// Response from GetAttachedFile API.
type GetAttachedFileOutput struct {

	// The size of the attached file in bytes.
	//
	// This member is required.
	FileSizeInBytes *int64

	// The resource to which the attached file is (being) uploaded to. [Cases] are the only
	// current supported resource.
	//
	// [Cases]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html
	AssociatedResourceArn *string

	// Represents the identity that created the file.
	CreatedBy types.CreatedByInfo

	// The time of Creation of the file resource as an ISO timestamp. It's specified
	// in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ . For example,
	// 2024-05-03T02:41:28.172Z .
	CreationTime *string

	// URL and expiry to be used when downloading the attached file.
	DownloadUrlMetadata *types.DownloadUrlMetadata

	// The unique identifier of the attached file resource (ARN).
	FileArn *string

	// The unique identifier of the attached file resource.
	FileId *string

	// A case-sensitive name of the attached file being uploaded.
	FileName *string

	// The current status of the attached file.
	FileStatus types.FileStatusType

	// The use case for the file.
	FileUseCaseType types.FileUseCaseType

	// The tags used to organize, track, or control access for this resource. For
	// example, { "Tags": {"key1":"value1", "key2":"value2"} } .
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAttachedFileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAttachedFile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAttachedFile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAttachedFile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAttachedFileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAttachedFile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAttachedFile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAttachedFile",
	}
}
