// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets user pool multi-factor authentication (MFA) and passkey configuration. For
// more information about user pool MFA, see [Adding MFA]. For more information about WebAuthn
// passkeys see [Authentication flows].
//
// This action might generate an SMS text message. Starting June 1, 2021, US
// telecom carriers require you to register an origination phone number before you
// can send SMS messages to US phone numbers. If you use SMS text messages in
// Amazon Cognito, you must register a phone number with [Amazon Pinpoint]. Amazon Cognito uses the
// registered number automatically. Otherwise, Amazon Cognito users who must
// receive SMS messages might not be able to sign up, activate their accounts, or
// sign in.
//
// If you have never used SMS text messages with Amazon Cognito or any other
// Amazon Web Services service, Amazon Simple Notification Service might place your
// account in the SMS sandbox. In [sandbox mode], you can send messages only to verified phone
// numbers. After you test your app while in the sandbox environment, you can move
// out of the sandbox and into production. For more information, see [SMS message settings for Amazon Cognito user pools]in the Amazon
// Cognito Developer Guide.
//
// [SMS message settings for Amazon Cognito user pools]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html
// [Adding MFA]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html
// [sandbox mode]: https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html
// [Authentication flows]: https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow-methods.html#amazon-cognito-user-pools-authentication-flow-methods-passkey
// [Amazon Pinpoint]: https://console.aws.amazon.com/pinpoint/home/
func (c *Client) SetUserPoolMfaConfig(ctx context.Context, params *SetUserPoolMfaConfigInput, optFns ...func(*Options)) (*SetUserPoolMfaConfigOutput, error) {
	if params == nil {
		params = &SetUserPoolMfaConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetUserPoolMfaConfig", params, optFns, c.addOperationSetUserPoolMfaConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetUserPoolMfaConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SetUserPoolMfaConfigInput struct {

	// The user pool ID.
	//
	// This member is required.
	UserPoolId *string

	// Sets configuration for user pool email message MFA and sign-in with one-time
	// passwords (OTPs). Includes the subject and body of the email message template
	// for sign-in and MFA messages. To activate this setting, your user pool must be
	// in the [Essentials tier]or higher.
	//
	// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
	EmailMfaConfiguration *types.EmailMfaConfigType

	// Sets multi-factor authentication (MFA) to be on, off, or optional. When ON , all
	// users must set up MFA before they can sign in. When OPTIONAL , your application
	// must make a client-side determination of whether a user wants to register an MFA
	// device. For user pools with adaptive authentication with threat protection,
	// choose OPTIONAL .
	//
	// When MfaConfiguration is OPTIONAL , managed login doesn't automatically prompt
	// users to set up MFA. Amazon Cognito generates MFA prompts in API responses and
	// in managed login for users who have chosen and configured a preferred MFA
	// factor.
	MfaConfiguration types.UserPoolMfaType

	// Configures user pool SMS messages for MFA. Sets the message template and the
	// SMS message sending configuration for Amazon SNS.
	SmsMfaConfiguration *types.SmsMfaConfigType

	// Configures a user pool for time-based one-time password (TOTP) MFA. Enables or
	// disables TOTP.
	SoftwareTokenMfaConfiguration *types.SoftwareTokenMfaConfigType

	// The configuration of your user pool for passkey, or WebAuthn, authentication
	// and registration. You can set this configuration independent of the MFA
	// configuration options in this operation.
	WebAuthnConfiguration *types.WebAuthnConfigurationType

	noSmithyDocumentSerde
}

type SetUserPoolMfaConfigOutput struct {

	// Shows configuration for user pool email message MFA and sign-in with one-time
	// passwords (OTPs). Includes the subject and body of the email message template
	// for sign-in and MFA messages. To activate this setting, your user pool must be
	// in the [Essentials tier]or higher.
	//
	// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
	EmailMfaConfiguration *types.EmailMfaConfigType

	// Displays multi-factor authentication (MFA) as on, off, or optional. When ON ,
	// all users must set up MFA before they can sign in. When OPTIONAL , your
	// application must make a client-side determination of whether a user wants to
	// register an MFA device. For user pools with adaptive authentication with threat
	// protection, choose OPTIONAL .
	//
	// When MfaConfiguration is OPTIONAL , managed login doesn't automatically prompt
	// users to set up MFA. Amazon Cognito generates MFA prompts in API responses and
	// in managed login for users who have chosen and configured a preferred MFA
	// factor.
	MfaConfiguration types.UserPoolMfaType

	// Shows user pool SMS message configuration for MFA and sign-in with SMS-message
	// OTPs. Includes the message template and the SMS message sending configuration
	// for Amazon SNS.
	SmsMfaConfiguration *types.SmsMfaConfigType

	// Shows user pool configuration for time-based one-time password (TOTP) MFA.
	// Includes TOTP enabled or disabled state.
	SoftwareTokenMfaConfiguration *types.SoftwareTokenMfaConfigType

	// The configuration of your user pool for passkey, or WebAuthn, sign-in with
	// authenticators like biometric and security-key devices. Includes relying-party
	// configuration and settings for user-verification requirements.
	WebAuthnConfiguration *types.WebAuthnConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetUserPoolMfaConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpSetUserPoolMfaConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpSetUserPoolMfaConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SetUserPoolMfaConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSetUserPoolMfaConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetUserPoolMfaConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetUserPoolMfaConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SetUserPoolMfaConfig",
	}
}
