// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists test results for an Automated Reasoning policy, showing how the policy
// performed against various test scenarios and validation checks.
func (c *Client) ListAutomatedReasoningPolicyTestResults(ctx context.Context, params *ListAutomatedReasoningPolicyTestResultsInput, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyTestResultsOutput, error) {
	if params == nil {
		params = &ListAutomatedReasoningPolicyTestResultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomatedReasoningPolicyTestResults", params, optFns, c.addOperationListAutomatedReasoningPolicyTestResultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomatedReasoningPolicyTestResultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomatedReasoningPolicyTestResultsInput struct {

	// The unique identifier of the build workflow whose test results you want to list.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy whose test
	// results you want to list.
	//
	// This member is required.
	PolicyArn *string

	// The maximum number of test results to return in a single response. Valid range
	// is 1-100.
	MaxResults *int32

	// A pagination token from a previous request to continue listing test results
	// from where the previous request left off.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomatedReasoningPolicyTestResultsOutput struct {

	// A list of test results, each containing information about how the policy
	// performed on specific test scenarios.
	//
	// This member is required.
	TestResults []types.AutomatedReasoningPolicyTestResult

	// A pagination token to use in subsequent requests to retrieve additional test
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomatedReasoningPolicyTestResultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAutomatedReasoningPolicyTestResults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAutomatedReasoningPolicyTestResults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomatedReasoningPolicyTestResults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomatedReasoningPolicyTestResultsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomatedReasoningPolicyTestResults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAutomatedReasoningPolicyTestResultsPaginatorOptions is the paginator
// options for ListAutomatedReasoningPolicyTestResults
type ListAutomatedReasoningPolicyTestResultsPaginatorOptions struct {
	// The maximum number of test results to return in a single response. Valid range
	// is 1-100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomatedReasoningPolicyTestResultsPaginator is a paginator for
// ListAutomatedReasoningPolicyTestResults
type ListAutomatedReasoningPolicyTestResultsPaginator struct {
	options   ListAutomatedReasoningPolicyTestResultsPaginatorOptions
	client    ListAutomatedReasoningPolicyTestResultsAPIClient
	params    *ListAutomatedReasoningPolicyTestResultsInput
	nextToken *string
	firstPage bool
}

// NewListAutomatedReasoningPolicyTestResultsPaginator returns a new
// ListAutomatedReasoningPolicyTestResultsPaginator
func NewListAutomatedReasoningPolicyTestResultsPaginator(client ListAutomatedReasoningPolicyTestResultsAPIClient, params *ListAutomatedReasoningPolicyTestResultsInput, optFns ...func(*ListAutomatedReasoningPolicyTestResultsPaginatorOptions)) *ListAutomatedReasoningPolicyTestResultsPaginator {
	if params == nil {
		params = &ListAutomatedReasoningPolicyTestResultsInput{}
	}

	options := ListAutomatedReasoningPolicyTestResultsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomatedReasoningPolicyTestResultsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomatedReasoningPolicyTestResultsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomatedReasoningPolicyTestResults page.
func (p *ListAutomatedReasoningPolicyTestResultsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomatedReasoningPolicyTestResultsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomatedReasoningPolicyTestResults(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomatedReasoningPolicyTestResultsAPIClient is a client that implements
// the ListAutomatedReasoningPolicyTestResults operation.
type ListAutomatedReasoningPolicyTestResultsAPIClient interface {
	ListAutomatedReasoningPolicyTestResults(context.Context, *ListAutomatedReasoningPolicyTestResultsInput, ...func(*Options)) (*ListAutomatedReasoningPolicyTestResultsOutput, error)
}

var _ ListAutomatedReasoningPolicyTestResultsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomatedReasoningPolicyTestResults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomatedReasoningPolicyTestResults",
	}
}
