// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Indicates that an Amazon S3 canned ACL should be set to control ownership of
// stored query results, including data files inserted by Athena as the result of
// statements like CTAS or INSERT INTO. When Athena stores query results in Amazon
// S3, the canned ACL is set with the x-amz-acl request header. For more
// information about S3 Object Ownership, see [Object Ownership settings]in the Amazon S3 User Guide.
//
// [Object Ownership settings]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview
type AclConfiguration struct {

	// The Amazon S3 canned ACL that Athena should specify when storing query results,
	// including data files inserted by Athena as the result of statements like CTAS or
	// INSERT INTO. Currently the only supported canned ACL is
	// BUCKET_OWNER_FULL_CONTROL . If a query runs in a workgroup and the workgroup
	// overrides client-side settings, then the Amazon S3 canned ACL specified in the
	// workgroup's settings is used for all queries that run in the workgroup. For more
	// information about Amazon S3 canned ACLs, see [Canned ACL]in the Amazon S3 User Guide.
	//
	// [Canned ACL]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl
	//
	// This member is required.
	S3AclOption S3AclOption

	noSmithyDocumentSerde
}

// Contains the application runtime IDs and their supported DPU sizes.
type ApplicationDPUSizes struct {

	// The name of the supported application runtime (for example, Athena notebook
	// version 1 ).
	ApplicationRuntimeId *string

	// A list of the supported DPU sizes that the application runtime supports.
	SupportedDPUSizes []int32

	noSmithyDocumentSerde
}

// Provides information about an Athena query error. The AthenaError feature
// provides standardized error information to help you understand failed queries
// and take steps after a query failure occurs. AthenaError includes an
// ErrorCategory field that specifies whether the cause of the failed query is due
// to system error, user error, or other error.
type AthenaError struct {

	// An integer value that specifies the category of a query failure error. The
	// following list shows the category for each integer value.
	//
	// 1 - System
	//
	// 2 - User
	//
	// 3 - Other
	ErrorCategory *int32

	// Contains a short description of the error that occurred.
	ErrorMessage *string

	// An integer value that provides specific information about an Athena query
	// error. For the meaning of specific values, see the [Error Type Reference]in the Amazon Athena User
	// Guide.
	//
	// [Error Type Reference]: https://docs.aws.amazon.com/athena/latest/ug/error-reference.html#error-reference-error-type-reference
	ErrorType *int32

	// True if the query might succeed if resubmitted.
	Retryable bool

	noSmithyDocumentSerde
}

// Contains configuration information for the calculation.
type CalculationConfiguration struct {

	// A string that contains the code for the calculation.
	CodeBlock *string

	noSmithyDocumentSerde
}

// Contains information about an application-specific calculation result.
type CalculationResult struct {

	// The Amazon S3 location of the folder for the calculation results.
	ResultS3Uri *string

	// The data format of the calculation result.
	ResultType *string

	// The Amazon S3 location of the stderr error messages file for the calculation.
	StdErrorS3Uri *string

	// The Amazon S3 location of the stdout file for the calculation.
	StdOutS3Uri *string

	noSmithyDocumentSerde
}

// Contains statistics for a notebook calculation.
type CalculationStatistics struct {

	// The data processing unit execution time in milliseconds for the calculation.
	DpuExecutionInMillis *int64

	// The progress of the calculation.
	Progress *string

	noSmithyDocumentSerde
}

// Contains information about the status of a notebook calculation.
type CalculationStatus struct {

	// The date and time the calculation completed processing.
	CompletionDateTime *time.Time

	// The state of the calculation execution. A description of each state follows.
	//
	// CREATING - The calculation is in the process of being created.
	//
	// CREATED - The calculation has been created and is ready to run.
	//
	// QUEUED - The calculation has been queued for processing.
	//
	// RUNNING - The calculation is running.
	//
	// CANCELING - A request to cancel the calculation has been received and the
	// system is working to stop it.
	//
	// CANCELED - The calculation is no longer running as the result of a cancel
	// request.
	//
	// COMPLETED - The calculation has completed without error.
	//
	// FAILED - The calculation failed and is no longer running.
	State CalculationExecutionState

	// The reason for the calculation state change (for example, the calculation was
	// canceled because the session was terminated).
	StateChangeReason *string

	// The date and time the calculation was submitted for processing.
	SubmissionDateTime *time.Time

	noSmithyDocumentSerde
}

// Summary information for a notebook calculation.
type CalculationSummary struct {

	// The calculation execution UUID.
	CalculationExecutionId *string

	// A description of the calculation.
	Description *string

	// Contains information about the status of the calculation.
	Status *CalculationStatus

	noSmithyDocumentSerde
}

// Contains the submission time of a single allocation request for a capacity
// reservation and the most recent status of the attempted allocation.
type CapacityAllocation struct {

	// The time when the capacity allocation was requested.
	//
	// This member is required.
	RequestTime *time.Time

	// The status of the capacity allocation.
	//
	// This member is required.
	Status CapacityAllocationStatus

	// The time when the capacity allocation request was completed.
	RequestCompletionTime *time.Time

	// The status message of the capacity allocation.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A mapping between one or more workgroups and a capacity reservation.
type CapacityAssignment struct {

	// The list of workgroup names for the capacity assignment.
	WorkGroupNames []string

	noSmithyDocumentSerde
}

// Assigns Athena workgroups (and hence their queries) to capacity reservations. A
// capacity reservation can have only one capacity assignment configuration, but
// the capacity assignment configuration can be made up of multiple individual
// assignments. Each assignment specifies how Athena queries can consume capacity
// from the capacity reservation that their workgroup is mapped to.
type CapacityAssignmentConfiguration struct {

	// The list of assignments that make up the capacity assignment configuration.
	CapacityAssignments []CapacityAssignment

	// The name of the reservation that the capacity assignment configuration is for.
	CapacityReservationName *string

	noSmithyDocumentSerde
}

// A reservation for a specified number of data processing units (DPUs). When a
// reservation is initially created, it has no DPUs. Athena allocates DPUs until
// the allocated amount equals the requested amount.
type CapacityReservation struct {

	// The number of data processing units currently allocated.
	//
	// This member is required.
	AllocatedDpus *int32

	// The time in UTC epoch millis when the capacity reservation was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the capacity reservation.
	//
	// This member is required.
	Name *string

	// The status of the capacity reservation.
	//
	// This member is required.
	Status CapacityReservationStatus

	// The number of data processing units requested.
	//
	// This member is required.
	TargetDpus *int32

	// Contains the submission time of a single allocation request for a capacity
	// reservation and the most recent status of the attempted allocation.
	LastAllocation *CapacityAllocation

	// The time of the most recent capacity allocation that succeeded.
	LastSuccessfulAllocationTime *time.Time

	noSmithyDocumentSerde
}

// Contains metadata for a column in a table.
type Column struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// Optional information about the column.
	Comment *string

	// The data type of the column.
	Type *string

	noSmithyDocumentSerde
}

// Information about the columns in a query execution result.
type ColumnInfo struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// The data type of the column.
	//
	// This member is required.
	Type *string

	// Indicates whether values in the column are case-sensitive.
	CaseSensitive bool

	// The catalog to which the query results belong.
	CatalogName *string

	// A column label.
	Label *string

	// Unsupported constraint. This value always shows as UNKNOWN .
	Nullable ColumnNullable

	// For DECIMAL data types, specifies the total number of digits, up to 38. For
	// performance reasons, we recommend up to 18 digits.
	Precision int32

	// For DECIMAL data types, specifies the total number of digits in the fractional
	// part of the value. Defaults to 0.
	Scale int32

	// The schema name (database name) to which the query results belong.
	SchemaName *string

	// The table name for the query results.
	TableName *string

	noSmithyDocumentSerde
}

// Specifies the customer managed KMS key that is used to encrypt the user's data
// stores in Athena. When an Amazon Web Services managed key is used, this value is
// null. This setting does not apply to Athena SQL workgroups.
type CustomerContentEncryptionConfiguration struct {

	// The customer managed KMS key that is used to encrypt the user's data stores in
	// Athena.
	//
	// This member is required.
	KmsKey *string

	noSmithyDocumentSerde
}

// Contains metadata information for a database in a data catalog.
type Database struct {

	// The name of the database.
	//
	// This member is required.
	Name *string

	// An optional description of the database.
	Description *string

	// A set of custom key/value pairs.
	Parameters map[string]string

	noSmithyDocumentSerde
}

// Contains information about a data catalog in an Amazon Web Services account.
//
// In the Athena console, data catalogs are listed as "data sources" on the Data
// sources page under the Data source name column.
type DataCatalog struct {

	// The name of the data catalog. The catalog name must be unique for the Amazon
	// Web Services account and can use a maximum of 127 alphanumeric, underscore, at
	// sign, or hyphen characters. The remainder of the length constraint of 256 is
	// reserved for use by Athena.
	//
	// This member is required.
	Name *string

	// The type of data catalog to create: LAMBDA for a federated catalog, GLUE for an
	// Glue Data Catalog, and HIVE for an external Apache Hive metastore. FEDERATED is
	// a federated catalog for which Athena creates the connection and the Lambda
	// function for you based on the parameters that you pass.
	//
	// This member is required.
	Type DataCatalogType

	// The type of connection for a FEDERATED data catalog (for example, REDSHIFT ,
	// MYSQL , or SQLSERVER ). For information about individual connectors, see [Available data source connectors].
	//
	// [Available data source connectors]: https://docs.aws.amazon.com/athena/latest/ug/connectors-available.html
	ConnectionType ConnectionType

	// An optional description of the data catalog.
	Description *string

	// Text of the error that occurred during data catalog creation or deletion.
	Error *string

	// Specifies the Lambda function or functions to use for the data catalog. This is
	// a mapping whose values depend on the catalog type.
	//
	//   - For the HIVE data catalog type, use the following syntax. The
	//   metadata-function parameter is required. The sdk-version parameter is optional
	//   and defaults to the currently supported version.
	//
	// metadata-function=lambda_arn, sdk-version=version_number
	//
	//   - For the LAMBDA data catalog type, use one of the following sets of required
	//   parameters, but not both.
	//
	//   - If you have one Lambda function that processes metadata and another for
	//   reading the actual data, use the following syntax. Both parameters are required.
	//
	// metadata-function=lambda_arn, record-function=lambda_arn
	//
	//   - If you have a composite Lambda function that processes both metadata and
	//   data, use the following syntax to specify your Lambda function.
	//
	// function=lambda_arn
	//
	//   - The GLUE type takes a catalog ID parameter and is required. The catalog_id
	//   is the account ID of the Amazon Web Services account to which the Glue catalog
	//   belongs.
	//
	// catalog-id=catalog_id
	//
	//   - The GLUE data catalog type also applies to the default AwsDataCatalog that
	//   already exists in your account, of which you can have only one and cannot
	//   modify.
	//
	//   - The FEDERATED data catalog type uses one of the following parameters, but
	//   not both. Use connection-arn for an existing Glue connection. Use
	//   connection-type and connection-properties to specify the configuration setting
	//   for a new connection.
	//
	//   - connection-arn:
	//
	//   - connection-type:MYSQL|REDSHIFT|...., connection-properties:""
	//
	// For , use escaped JSON text, as in the following example.
	//
	//   "{\"spill_bucket\":\"my_spill\",\"spill_prefix\":\"athena-spill\",\"host\":\"abc12345.snowflakecomputing.com\",\"port\":\"1234\",\"warehouse\":\"DEV_WH\",\"database\":\"TEST\",\"schema\":\"PUBLIC\",\"SecretArn\":\"arn:aws:secretsmanager:ap-south-1:111122223333:secret:snowflake-XHb67j\"}"
	Parameters map[string]string

	// The status of the creation or deletion of the data catalog.
	//
	//   - The LAMBDA , GLUE , and HIVE data catalog types are created synchronously.
	//   Their status is either CREATE_COMPLETE or CREATE_FAILED .
	//
	//   - The FEDERATED data catalog type is created asynchronously.
	//
	// Data catalog creation status:
	//
	//   - CREATE_IN_PROGRESS : Federated data catalog creation in progress.
	//
	//   - CREATE_COMPLETE : Data catalog creation complete.
	//
	//   - CREATE_FAILED : Data catalog could not be created.
	//
	//   - CREATE_FAILED_CLEANUP_IN_PROGRESS : Federated data catalog creation failed
	//   and is being removed.
	//
	//   - CREATE_FAILED_CLEANUP_COMPLETE : Federated data catalog creation failed and
	//   was removed.
	//
	//   - CREATE_FAILED_CLEANUP_FAILED : Federated data catalog creation failed but
	//   could not be removed.
	//
	// Data catalog deletion status:
	//
	//   - DELETE_IN_PROGRESS : Federated data catalog deletion in progress.
	//
	//   - DELETE_COMPLETE : Federated data catalog deleted.
	//
	//   - DELETE_FAILED : Federated data catalog could not be deleted.
	Status DataCatalogStatus

	noSmithyDocumentSerde
}

// The summary information for the data catalog, which includes its name and type.
type DataCatalogSummary struct {

	// The name of the data catalog. The catalog name is unique for the Amazon Web
	// Services account and can use a maximum of 127 alphanumeric, underscore, at sign,
	// or hyphen characters. The remainder of the length constraint of 256 is reserved
	// for use by Athena.
	CatalogName *string

	// The type of connection for a FEDERATED data catalog (for example, REDSHIFT ,
	// MYSQL , or SQLSERVER ). For information about individual connectors, see [Available data source connectors].
	//
	// [Available data source connectors]: https://docs.aws.amazon.com/athena/latest/ug/connectors-available.html
	ConnectionType ConnectionType

	// Text of the error that occurred during data catalog creation or deletion.
	Error *string

	// The status of the creation or deletion of the data catalog.
	//
	//   - The LAMBDA , GLUE , and HIVE data catalog types are created synchronously.
	//   Their status is either CREATE_COMPLETE or CREATE_FAILED .
	//
	//   - The FEDERATED data catalog type is created asynchronously.
	//
	// Data catalog creation status:
	//
	//   - CREATE_IN_PROGRESS : Federated data catalog creation in progress.
	//
	//   - CREATE_COMPLETE : Data catalog creation complete.
	//
	//   - CREATE_FAILED : Data catalog could not be created.
	//
	//   - CREATE_FAILED_CLEANUP_IN_PROGRESS : Federated data catalog creation failed
	//   and is being removed.
	//
	//   - CREATE_FAILED_CLEANUP_COMPLETE : Federated data catalog creation failed and
	//   was removed.
	//
	//   - CREATE_FAILED_CLEANUP_FAILED : Federated data catalog creation failed but
	//   could not be removed.
	//
	// Data catalog deletion status:
	//
	//   - DELETE_IN_PROGRESS : Federated data catalog deletion in progress.
	//
	//   - DELETE_COMPLETE : Federated data catalog deleted.
	//
	//   - DELETE_FAILED : Federated data catalog could not be deleted.
	Status DataCatalogStatus

	// The data catalog type.
	Type DataCatalogType

	noSmithyDocumentSerde
}

// A piece of data (a field in the table).
type Datum struct {

	// The value of the datum.
	VarCharValue *string

	noSmithyDocumentSerde
}

// If query and calculation results are encrypted in Amazon S3, indicates the
// encryption option used (for example, SSE_KMS or CSE_KMS ) and key information.
type EncryptionConfiguration struct {

	// Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (
	// SSE_S3 ), server-side encryption with KMS-managed keys ( SSE_KMS ), or
	// client-side encryption with KMS-managed keys ( CSE_KMS ) is used.
	//
	// If a query runs in a workgroup and the workgroup overrides client-side
	// settings, then the workgroup's setting for encryption is used. It specifies
	// whether query results must be encrypted, for all queries that run in this
	// workgroup.
	//
	// This member is required.
	EncryptionOption EncryptionOption

	// For SSE_KMS and CSE_KMS , this is the KMS key ARN or ID.
	KmsKey *string

	noSmithyDocumentSerde
}

// Contains data processing unit (DPU) configuration settings and parameter
// mappings for a notebook engine.
type EngineConfiguration struct {

	// The maximum number of DPUs that can run concurrently.
	//
	// This member is required.
	MaxConcurrentDpus *int32

	// Contains additional notebook engine MAP parameter mappings in the form of
	// key-value pairs. To specify an Athena notebook that the Jupyter server will
	// download and serve, specify a value for the StartSessionRequest$NotebookVersionfield, and then add a key named
	// NotebookId to AdditionalConfigs that has the value of the Athena notebook ID.
	AdditionalConfigs map[string]string

	// The number of DPUs to use for the coordinator. A coordinator is a special
	// executor that orchestrates processing work and manages other executors in a
	// notebook session. The default is 1.
	CoordinatorDpuSize *int32

	// The default number of DPUs to use for executors. An executor is the smallest
	// unit of compute that a notebook session can request from Athena. The default is
	// 1.
	DefaultExecutorDpuSize *int32

	// Specifies custom jar files and Spark properties for use cases like cluster
	// encryption, table formats, and general Spark tuning.
	SparkProperties map[string]string

	noSmithyDocumentSerde
}

// The Athena engine version for running queries, or the PySpark engine version
// for running sessions.
type EngineVersion struct {

	// Read only. The engine version on which the query runs. If the user requests a
	// valid engine version other than Auto, the effective engine version is the same
	// as the engine version that the user requested. If the user requests Auto, the
	// effective engine version is chosen by Athena. When a request to update the
	// engine version is made by a CreateWorkGroup or UpdateWorkGroup operation, the
	// EffectiveEngineVersion field is ignored.
	EffectiveEngineVersion *string

	// The engine version requested by the user. Possible values are determined by the
	// output of ListEngineVersions , including AUTO. The default is AUTO.
	SelectedEngineVersion *string

	noSmithyDocumentSerde
}

// Contains summary information about an executor.
type ExecutorsSummary struct {

	// The UUID of the executor.
	//
	// This member is required.
	ExecutorId *string

	// The smallest unit of compute that a session can request from Athena. Size is
	// measured in data processing unit (DPU) values, a relative measure of processing
	// power.
	ExecutorSize *int64

	// The processing state of the executor. A description of each state follows.
	//
	// CREATING - The executor is being started, including acquiring resources.
	//
	// CREATED - The executor has been started.
	//
	// REGISTERED - The executor has been registered.
	//
	// TERMINATING - The executor is in the process of shutting down.
	//
	// TERMINATED - The executor is no longer running.
	//
	// FAILED - Due to a failure, the executor is no longer running.
	ExecutorState ExecutorState

	// The type of executor used for the application ( COORDINATOR , GATEWAY , or
	// WORKER ).
	ExecutorType ExecutorType

	// The date and time that the executor started.
	StartDateTime *int64

	// The date and time that the executor was terminated.
	TerminationDateTime *int64

	noSmithyDocumentSerde
}

// A string for searching notebook names.
type FilterDefinition struct {

	// The name of the notebook to search for.
	Name *string

	noSmithyDocumentSerde
}

// Specifies whether the workgroup is IAM Identity Center supported.
type IdentityCenterConfiguration struct {

	// Specifies whether the workgroup is IAM Identity Center supported.
	EnableIdentityCenter *bool

	// The IAM Identity Center instance ARN that the workgroup associates to.
	IdentityCenterInstanceArn *string

	noSmithyDocumentSerde
}

//	The configuration for storing results in Athena owned storage, which includes
//
// whether this feature is enabled; whether encryption configuration, if any, is
// used for encrypting query results.
type ManagedQueryResultsConfiguration struct {

	// If set to true, allows you to store query results in Athena owned storage. If
	// set to false, workgroup member stores query results in location specified under
	// ResultConfiguration$OutputLocation . The default is false. A workgroup cannot
	// have the ResultConfiguration$OutputLocation parameter when you set this field
	// to true.
	//
	// This member is required.
	Enabled bool

	// If you encrypt query and calculation results in Athena owned storage, this
	// field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key
	// information.
	EncryptionConfiguration *ManagedQueryResultsEncryptionConfiguration

	noSmithyDocumentSerde
}

// Updates the configuration for managed query results.
type ManagedQueryResultsConfigurationUpdates struct {

	// If set to true, specifies that Athena manages query results in Athena owned
	// storage.
	Enabled *bool

	// If you encrypt query and calculation results in Athena owned storage, this
	// field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key
	// information.
	EncryptionConfiguration *ManagedQueryResultsEncryptionConfiguration

	// If set to true, it removes workgroup from Athena owned storage. The existing
	// query results are cleaned up after 24hrs. You must provide query results in
	// location specified under ResultConfiguration$OutputLocation .
	RemoveEncryptionConfiguration *bool

	noSmithyDocumentSerde
}

// If you encrypt query and calculation results in Athena owned storage, this
// field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key
// information.
type ManagedQueryResultsEncryptionConfiguration struct {

	// The ARN of an KMS key for encrypting managed query results.
	//
	// This member is required.
	KmsKey *string

	noSmithyDocumentSerde
}

// A query, where QueryString contains the SQL statements that make up the query.
type NamedQuery struct {

	// The database to which the query belongs.
	//
	// This member is required.
	Database *string

	// The query name.
	//
	// This member is required.
	Name *string

	// The SQL statements that make up the query.
	//
	// This member is required.
	QueryString *string

	// The query description.
	Description *string

	// The unique identifier of the query.
	NamedQueryId *string

	// The name of the workgroup that contains the named query.
	WorkGroup *string

	noSmithyDocumentSerde
}

// Contains metadata for notebook, including the notebook name, ID, workgroup, and
// time created.
type NotebookMetadata struct {

	// The time when the notebook was created.
	CreationTime *time.Time

	// The time when the notebook was last modified.
	LastModifiedTime *time.Time

	// The name of the notebook.
	Name *string

	// The notebook ID.
	NotebookId *string

	// The type of notebook. Currently, the only valid type is IPYNB .
	Type NotebookType

	// The name of the Spark enabled workgroup to which the notebook belongs.
	WorkGroup *string

	noSmithyDocumentSerde
}

// Contains the notebook session ID and notebook session creation time.
type NotebookSessionSummary struct {

	// The time when the notebook session was created.
	CreationTime *time.Time

	// The notebook session ID.
	SessionId *string

	noSmithyDocumentSerde
}

// A prepared SQL statement for use with Athena.
type PreparedStatement struct {

	// The description of the prepared statement.
	Description *string

	// The last modified time of the prepared statement.
	LastModifiedTime *time.Time

	// The query string for the prepared statement.
	QueryStatement *string

	// The name of the prepared statement.
	StatementName *string

	// The name of the workgroup to which the prepared statement belongs.
	WorkGroupName *string

	noSmithyDocumentSerde
}

// The name and last modified time of the prepared statement.
type PreparedStatementSummary struct {

	// The last modified time of the prepared statement.
	LastModifiedTime *time.Time

	// The name of the prepared statement.
	StatementName *string

	noSmithyDocumentSerde
}

// Information about a single instance of a query execution.
type QueryExecution struct {

	// The engine version that executed the query.
	EngineVersion *EngineVersion

	// A list of values for the parameters in a query. The values are applied
	// sequentially to the parameters in the query in the order in which the parameters
	// occur. The list of parameters is not returned in the response.
	ExecutionParameters []string

	//  The configuration for storing results in Athena owned storage, which includes
	// whether this feature is enabled; whether encryption configuration, if any, is
	// used for encrypting query results.
	ManagedQueryResultsConfiguration *ManagedQueryResultsConfiguration

	// The SQL query statements which the query execution ran.
	Query *string

	// The database in which the query execution occurred.
	QueryExecutionContext *QueryExecutionContext

	// The unique identifier for each query execution.
	QueryExecutionId *string

	// Specifies whether Amazon S3 access grants are enabled for query results.
	QueryResultsS3AccessGrantsConfiguration *QueryResultsS3AccessGrantsConfiguration

	// The location in Amazon S3 where query and calculation results are stored and
	// the encryption option, if any, used for query results. These are known as
	// "client-side settings". If workgroup settings override client-side settings,
	// then the query uses the location for the query results and the encryption
	// configuration that are specified for the workgroup.
	ResultConfiguration *ResultConfiguration

	// Specifies the query result reuse behavior that was used for the query.
	ResultReuseConfiguration *ResultReuseConfiguration

	// The type of query statement that was run. DDL indicates DDL query statements.
	// DML indicates DML (Data Manipulation Language) query statements, such as CREATE
	// TABLE AS SELECT . UTILITY indicates query statements other than DDL and DML,
	// such as SHOW CREATE TABLE , or DESCRIBE TABLE .
	StatementType StatementType

	// Query execution statistics, such as the amount of data scanned, the amount of
	// time that the query took to process, and the type of statement that was run.
	Statistics *QueryExecutionStatistics

	// The completion date, current state, submission time, and state change reason
	// (if applicable) for the query execution.
	Status *QueryExecutionStatus

	// The kind of query statement that was run.
	SubstatementType *string

	// The name of the workgroup in which the query ran.
	WorkGroup *string

	noSmithyDocumentSerde
}

// The database and data catalog context in which the query execution occurs.
type QueryExecutionContext struct {

	// The name of the data catalog used in the query execution.
	Catalog *string

	// The name of the database used in the query execution. The database must exist
	// in the catalog.
	Database *string

	noSmithyDocumentSerde
}

// The amount of data scanned during the query execution and the amount of time
// that it took to execute, and the type of statement that was run.
type QueryExecutionStatistics struct {

	// The location and file name of a data manifest file. The manifest file is saved
	// to the Athena query results location in Amazon S3. The manifest file tracks
	// files that the query wrote to Amazon S3. If the query fails, the manifest file
	// also tracks files that the query intended to write. The manifest is useful for
	// identifying orphaned files resulting from a failed query. For more information,
	// see [Working with Query Results, Output Files, and Query History]in the Amazon Athena User Guide.
	//
	// [Working with Query Results, Output Files, and Query History]: https://docs.aws.amazon.com/athena/latest/ug/querying.html
	DataManifestLocation *string

	// The number of bytes in the data that was queried.
	DataScannedInBytes *int64

	// The number of milliseconds that the query took to execute.
	EngineExecutionTimeInMillis *int64

	// The number of milliseconds that Athena took to plan the query processing flow.
	// This includes the time spent retrieving table partitions from the data source.
	// Note that because the query engine performs the query planning, query planning
	// time is a subset of engine processing time.
	QueryPlanningTimeInMillis *int64

	// The number of milliseconds that the query was in your query queue waiting for
	// resources. Note that if transient errors occur, Athena might automatically add
	// the query back to the queue.
	QueryQueueTimeInMillis *int64

	// Contains information about whether previous query results were reused for the
	// query.
	ResultReuseInformation *ResultReuseInformation

	// The number of milliseconds that Athena took to preprocess the query before
	// submitting the query to the query engine.
	ServicePreProcessingTimeInMillis *int64

	// The number of milliseconds that Athena took to finalize and publish the query
	// results after the query engine finished running the query.
	ServiceProcessingTimeInMillis *int64

	// The number of milliseconds that Athena took to run the query.
	TotalExecutionTimeInMillis *int64

	noSmithyDocumentSerde
}

// The completion date, current state, submission time, and state change reason
// (if applicable) for the query execution.
type QueryExecutionStatus struct {

	// Provides information about an Athena query error.
	AthenaError *AthenaError

	// The date and time that the query completed.
	CompletionDateTime *time.Time

	// The state of query execution. QUEUED indicates that the query has been
	// submitted to the service, and Athena will execute the query as soon as resources
	// are available. RUNNING indicates that the query is in execution phase. SUCCEEDED
	// indicates that the query completed without errors. FAILED indicates that the
	// query experienced an error and did not complete processing. CANCELLED indicates
	// that a user input interrupted query execution.
	//
	// Athena automatically retries your queries in cases of certain transient errors.
	// As a result, you may see the query state transition from RUNNING or FAILED to
	// QUEUED .
	State QueryExecutionState

	// Further detail about the status of the query.
	StateChangeReason *string

	// The date and time that the query was submitted.
	SubmissionDateTime *time.Time

	noSmithyDocumentSerde
}

// Specifies whether Amazon S3 access grants are enabled for query results.
type QueryResultsS3AccessGrantsConfiguration struct {

	// The authentication type used for Amazon S3 access grants. Currently, only
	// DIRECTORY_IDENTITY is supported.
	//
	// This member is required.
	AuthenticationType AuthenticationType

	// Specifies whether Amazon S3 access grants are enabled for query results.
	//
	// This member is required.
	EnableS3AccessGrants *bool

	// When enabled, appends the user ID as an Amazon S3 path prefix to the query
	// result output location.
	CreateUserLevelPrefix *bool

	noSmithyDocumentSerde
}

// The query execution timeline, statistics on input and output rows and bytes,
// and the different query stages that form the query execution plan.
type QueryRuntimeStatistics struct {

	// Stage statistics such as input and output rows and bytes, execution time, and
	// stage state. This information also includes substages and the query stage plan.
	OutputStage *QueryStage

	// Statistics such as input rows and bytes read by the query, rows and bytes
	// output by the query, and the number of rows written by the query.
	Rows *QueryRuntimeStatisticsRows

	// Timeline statistics such as query queue time, planning time, execution time,
	// service processing time, and total execution time.
	Timeline *QueryRuntimeStatisticsTimeline

	noSmithyDocumentSerde
}

// Statistics such as input rows and bytes read by the query, rows and bytes
// output by the query, and the number of rows written by the query.
type QueryRuntimeStatisticsRows struct {

	// The number of bytes read to execute the query.
	InputBytes *int64

	// The number of rows read to execute the query.
	InputRows *int64

	// The number of bytes returned by the query.
	OutputBytes *int64

	// The number of rows returned by the query.
	OutputRows *int64

	noSmithyDocumentSerde
}

// Timeline statistics such as query queue time, planning time, execution time,
// service processing time, and total execution time.
type QueryRuntimeStatisticsTimeline struct {

	// The number of milliseconds that the query took to execute.
	EngineExecutionTimeInMillis *int64

	// The number of milliseconds that Athena took to plan the query processing flow.
	// This includes the time spent retrieving table partitions from the data source.
	// Note that because the query engine performs the query planning, query planning
	// time is a subset of engine processing time.
	QueryPlanningTimeInMillis *int64

	// The number of milliseconds that the query was in your query queue waiting for
	// resources. Note that if transient errors occur, Athena might automatically add
	// the query back to the queue.
	QueryQueueTimeInMillis *int64

	//  The number of milliseconds that Athena spends on preprocessing before it
	// submits the query to the engine.
	ServicePreProcessingTimeInMillis *int64

	// The number of milliseconds that Athena took to finalize and publish the query
	// results after the query engine finished running the query.
	ServiceProcessingTimeInMillis *int64

	// The number of milliseconds that Athena took to run the query.
	TotalExecutionTimeInMillis *int64

	noSmithyDocumentSerde
}

// Stage statistics such as input and output rows and bytes, execution time and
// stage state. This information also includes substages and the query stage plan.
type QueryStage struct {

	// Time taken to execute this stage.
	ExecutionTime *int64

	// The number of bytes input into the stage for execution.
	InputBytes *int64

	// The number of rows input into the stage for execution.
	InputRows *int64

	// The number of bytes output from the stage after execution.
	OutputBytes *int64

	// The number of rows output from the stage after execution.
	OutputRows *int64

	// Stage plan information such as name, identifier, sub plans, and source stages.
	QueryStagePlan *QueryStagePlanNode

	// The identifier for a stage.
	StageId *int64

	// State of the stage after query execution.
	State *string

	// List of sub query stages that form this stage execution plan.
	SubStages []QueryStage

	noSmithyDocumentSerde
}

// Stage plan information such as name, identifier, sub plans, and remote sources.
type QueryStagePlanNode struct {

	// Stage plan information such as name, identifier, sub plans, and remote sources
	// of child plan nodes/
	Children []QueryStagePlanNode

	// Information about the operation this query stage plan node is performing.
	Identifier *string

	// Name of the query stage plan that describes the operation this stage is
	// performing as part of query execution.
	Name *string

	// Source plan node IDs.
	RemoteSources []string

	noSmithyDocumentSerde
}

// The location in Amazon S3 where query and calculation results are stored and
// the encryption option, if any, used for query and calculation results. These are
// known as "client-side settings". If workgroup settings override client-side
// settings, then the query uses the workgroup settings.
type ResultConfiguration struct {

	// Indicates that an Amazon S3 canned ACL should be set to control ownership of
	// stored query results. Currently the only supported canned ACL is
	// BUCKET_OWNER_FULL_CONTROL . This is a client-side setting. If workgroup settings
	// override client-side settings, then the query uses the ACL configuration that is
	// specified for the workgroup, and also uses the location for storing query
	// results specified in the workgroup. For more information, see WorkGroupConfiguration$EnforceWorkGroupConfigurationand [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	AclConfiguration *AclConfiguration

	// If query and calculation results are encrypted in Amazon S3, indicates the
	// encryption option used (for example, SSE_KMS or CSE_KMS ) and key information.
	// This is a client-side setting. If workgroup settings override client-side
	// settings, then the query uses the encryption configuration that is specified for
	// the workgroup, and also uses the location for storing query results specified in
	// the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfigurationand [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	EncryptionConfiguration *EncryptionConfiguration

	// The Amazon Web Services account ID that you expect to be the owner of the
	// Amazon S3 bucket specified by ResultConfiguration$OutputLocation. If set, Athena uses the value for
	// ExpectedBucketOwner when it makes Amazon S3 calls to your specified output
	// location. If the ExpectedBucketOwner Amazon Web Services account ID does not
	// match the actual owner of the Amazon S3 bucket, the call fails with a
	// permissions error.
	//
	// This is a client-side setting. If workgroup settings override client-side
	// settings, then the query uses the ExpectedBucketOwner setting that is specified
	// for the workgroup, and also uses the location for storing query results
	// specified in the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfigurationand [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	ExpectedBucketOwner *string

	// The location in Amazon S3 where your query and calculation results are stored,
	// such as s3://path/to/query/bucket/ . To run the query, you must specify the
	// query results location using one of the ways: either for individual queries
	// using either this setting (client-side), or in the workgroup, using WorkGroupConfiguration. If none
	// of them is set, Athena issues an error that no output location is provided. If
	// workgroup settings override client-side settings, then the query uses the
	// settings specified for the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string

	noSmithyDocumentSerde
}

// The information about the updates in the query results, such as output location
// and encryption configuration for the query results.
type ResultConfigurationUpdates struct {

	// The ACL configuration for the query results.
	AclConfiguration *AclConfiguration

	// The encryption configuration for query and calculation results.
	EncryptionConfiguration *EncryptionConfiguration

	// The Amazon Web Services account ID that you expect to be the owner of the
	// Amazon S3 bucket specified by ResultConfiguration$OutputLocation. If set, Athena uses the value for
	// ExpectedBucketOwner when it makes Amazon S3 calls to your specified output
	// location. If the ExpectedBucketOwner Amazon Web Services account ID does not
	// match the actual owner of the Amazon S3 bucket, the call fails with a
	// permissions error.
	//
	// If workgroup settings override client-side settings, then the query uses the
	// ExpectedBucketOwner setting that is specified for the workgroup, and also uses
	// the location for storing query results specified in the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfigurationand [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	ExpectedBucketOwner *string

	// The location in Amazon S3 where your query and calculation results are stored,
	// such as s3://path/to/query/bucket/ . If workgroup settings override client-side
	// settings, then the query uses the location for the query results and the
	// encryption configuration that are specified for the workgroup. The "workgroup
	// settings override" is specified in EnforceWorkGroupConfiguration (true/false)
	// in the WorkGroupConfiguration . See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string

	// If set to true , indicates that the previously-specified ACL configuration for
	// queries in this workgroup should be ignored and set to null. If set to false or
	// not set, and a value is present in the AclConfiguration of
	// ResultConfigurationUpdates , the AclConfiguration in the workgroup's
	// ResultConfiguration is updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	RemoveAclConfiguration *bool

	// If set to "true", indicates that the previously-specified encryption
	// configuration (also known as the client-side setting) for queries in this
	// workgroup should be ignored and set to null. If set to "false" or not set, and a
	// value is present in the EncryptionConfiguration in ResultConfigurationUpdates
	// (the client-side setting), the EncryptionConfiguration in the workgroup's
	// ResultConfiguration will be updated with the new value. For more information,
	// see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	RemoveEncryptionConfiguration *bool

	// If set to "true", removes the Amazon Web Services account ID previously
	// specified for ResultConfiguration$ExpectedBucketOwner. If set to "false" or not set, and a value is present in the
	// ExpectedBucketOwner in ResultConfigurationUpdates (the client-side setting),
	// the ExpectedBucketOwner in the workgroup's ResultConfiguration is updated with
	// the new value. For more information, see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	RemoveExpectedBucketOwner *bool

	// If set to "true", indicates that the previously-specified query results
	// location (also known as a client-side setting) for queries in this workgroup
	// should be ignored and set to null. If set to "false" or not set, and a value is
	// present in the OutputLocation in ResultConfigurationUpdates (the client-side
	// setting), the OutputLocation in the workgroup's ResultConfiguration will be
	// updated with the new value. For more information, see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	RemoveOutputLocation *bool

	noSmithyDocumentSerde
}

// Specifies whether previous query results are reused, and if so, their maximum
// age.
type ResultReuseByAgeConfiguration struct {

	// True if previous query results can be reused when the query is run; otherwise,
	// false. The default is false.
	//
	// This member is required.
	Enabled bool

	// Specifies, in minutes, the maximum age of a previous query result that Athena
	// should consider for reuse. The default is 60.
	MaxAgeInMinutes *int32

	noSmithyDocumentSerde
}

// Specifies the query result reuse behavior for the query.
type ResultReuseConfiguration struct {

	// Specifies whether previous query results are reused, and if so, their maximum
	// age.
	ResultReuseByAgeConfiguration *ResultReuseByAgeConfiguration

	noSmithyDocumentSerde
}

// Contains information about whether the result of a previous query was reused.
type ResultReuseInformation struct {

	// True if a previous query result was reused; false if the result was generated
	// from a new run of the query.
	//
	// This member is required.
	ReusedPreviousResult bool

	noSmithyDocumentSerde
}

// The metadata and rows that make up a query result set. The metadata describes
// the column structure and data types. To return a ResultSet object, use GetQueryResults.
type ResultSet struct {

	// The metadata that describes the column structure and data types of a table of
	// query results.
	ResultSetMetadata *ResultSetMetadata

	// The rows in the table.
	Rows []Row

	noSmithyDocumentSerde
}

// The metadata that describes the column structure and data types of a table of
// query results. To return a ResultSetMetadata object, use GetQueryResults.
type ResultSetMetadata struct {

	// Information about the columns returned in a query result metadata.
	ColumnInfo []ColumnInfo

	noSmithyDocumentSerde
}

// The rows that make up a query result table.
type Row struct {

	// The data that populates a row in a query result table.
	Data []Datum

	noSmithyDocumentSerde
}

// Contains session configuration information.
type SessionConfiguration struct {

	// If query and calculation results are encrypted in Amazon S3, indicates the
	// encryption option used (for example, SSE_KMS or CSE_KMS ) and key information.
	EncryptionConfiguration *EncryptionConfiguration

	// The ARN of the execution role used to access user resources for Spark sessions
	// and Identity Center enabled workgroups. This property applies only to Spark
	// enabled workgroups and Identity Center enabled workgroups.
	ExecutionRole *string

	// The idle timeout in seconds for the session.
	IdleTimeoutSeconds *int64

	// The Amazon S3 location that stores information for the notebook.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// Contains statistics for a session.
type SessionStatistics struct {

	// The data processing unit execution time for a session in milliseconds.
	DpuExecutionInMillis *int64

	noSmithyDocumentSerde
}

// Contains information about the status of a session.
type SessionStatus struct {

	// The date and time that the session ended.
	EndDateTime *time.Time

	// The date and time starting at which the session became idle. Can be empty if
	// the session is not currently idle.
	IdleSinceDateTime *time.Time

	// The most recent date and time that the session was modified.
	LastModifiedDateTime *time.Time

	// The date and time that the session started.
	StartDateTime *time.Time

	// The state of the session. A description of each state follows.
	//
	// CREATING - The session is being started, including acquiring resources.
	//
	// CREATED - The session has been started.
	//
	// IDLE - The session is able to accept a calculation.
	//
	// BUSY - The session is processing another task and is unable to accept a
	// calculation.
	//
	// TERMINATING - The session is in the process of shutting down.
	//
	// TERMINATED - The session and its resources are no longer running.
	//
	// DEGRADED - The session has no healthy coordinators.
	//
	// FAILED - Due to a failure, the session and its resources are no longer running.
	State SessionState

	// The reason for the session state change (for example, canceled because the
	// session was terminated).
	StateChangeReason *string

	noSmithyDocumentSerde
}

// Contains summary information about a session.
type SessionSummary struct {

	// The session description.
	Description *string

	// The engine version used by the session (for example, PySpark engine version 3 ).
	EngineVersion *EngineVersion

	// The notebook version.
	NotebookVersion *string

	// The session ID.
	SessionId *string

	// Contains information about the session status.
	Status *SessionStatus

	noSmithyDocumentSerde
}

// Contains metadata for a table.
type TableMetadata struct {

	// The name of the table.
	//
	// This member is required.
	Name *string

	// A list of the columns in the table.
	Columns []Column

	// The time that the table was created.
	CreateTime *time.Time

	// The last time the table was accessed.
	LastAccessTime *time.Time

	// A set of custom key/value pairs for table properties.
	Parameters map[string]string

	// A list of the partition keys in the table.
	PartitionKeys []Column

	// The type of table. In Athena, only EXTERNAL_TABLE is supported.
	TableType *string

	noSmithyDocumentSerde
}

// A label that you assign to a resource. Athena resources include workgroups,
// data catalogs, and capacity reservations. Each tag consists of a key and an
// optional value, both of which you define. For example, you can use tags to
// categorize Athena resources by purpose, owner, or environment. Use a consistent
// set of tag keys to make it easier to search and filter the resources in your
// account. For best practices, see [Tagging Best Practices]. Tag keys can be from 1 to 128 UTF-8 Unicode
// characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags
// can use letters and numbers representable in UTF-8, and the following
// characters: + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys
// must be unique per resource. If you specify more than one tag, separate them by
// commas.
//
// [Tagging Best Practices]: https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html
type Tag struct {

	// A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You
	// can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag keys are case-sensitive and must be unique per
	// resource.
	Key *string

	// A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8.
	// You can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag values are case-sensitive.
	Value *string

	noSmithyDocumentSerde
}

// Information about a named query ID that could not be processed.
type UnprocessedNamedQueryId struct {

	// The error code returned when the processing request for the named query failed,
	// if applicable.
	ErrorCode *string

	// The error message returned when the processing request for the named query
	// failed, if applicable.
	ErrorMessage *string

	// The unique identifier of the named query.
	NamedQueryId *string

	noSmithyDocumentSerde
}

// The name of a prepared statement that could not be returned.
type UnprocessedPreparedStatementName struct {

	// The error code returned when the request for the prepared statement failed.
	ErrorCode *string

	// The error message containing the reason why the prepared statement could not be
	// returned. The following error messages are possible:
	//
	//   - INVALID_INPUT - The name of the prepared statement that was provided is not
	//   valid (for example, the name is too long).
	//
	//   - STATEMENT_NOT_FOUND - A prepared statement with the name provided could not
	//   be found.
	//
	//   - UNAUTHORIZED - The requester does not have permission to access the
	//   workgroup that contains the prepared statement.
	ErrorMessage *string

	// The name of a prepared statement that could not be returned due to an error.
	StatementName *string

	noSmithyDocumentSerde
}

// Describes a query execution that failed to process.
type UnprocessedQueryExecutionId struct {

	// The error code returned when the query execution failed to process, if
	// applicable.
	ErrorCode *string

	// The error message returned when the query execution failed to process, if
	// applicable.
	ErrorMessage *string

	// The unique identifier of the query execution.
	QueryExecutionId *string

	noSmithyDocumentSerde
}

// A workgroup, which contains a name, description, creation time, state, and
// other configuration, listed under WorkGroup$Configuration. Each workgroup enables you to isolate
// queries for you or your group of users from other queries in the same account,
// to configure the query results location and the encryption configuration (known
// as workgroup settings), to enable sending query metrics to Amazon CloudWatch,
// and to establish per-query data usage control limits for all queries in a
// workgroup. The workgroup settings override is specified in
// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration . See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
type WorkGroup struct {

	// The workgroup name.
	//
	// This member is required.
	Name *string

	// The configuration of the workgroup, which includes the location in Amazon S3
	// where query and calculation results are stored, the encryption configuration, if
	// any, used for query and calculation results; whether the Amazon CloudWatch
	// Metrics are enabled for the workgroup; whether workgroup settings override
	// client-side settings; and the data usage limits for the amount of data scanned
	// per query or per workgroup. The workgroup settings override is specified in
	// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration . See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	Configuration *WorkGroupConfiguration

	// The date and time the workgroup was created.
	CreationTime *time.Time

	// The workgroup description.
	Description *string

	// The ARN of the IAM Identity Center enabled application associated with the
	// workgroup.
	IdentityCenterApplicationArn *string

	// The state of the workgroup: ENABLED or DISABLED.
	State WorkGroupState

	noSmithyDocumentSerde
}

// The configuration of the workgroup, which includes the location in Amazon S3
// where query and calculation results are stored, the encryption option, if any,
// used for query and calculation results, whether the Amazon CloudWatch Metrics
// are enabled for the workgroup and whether workgroup settings override query
// settings, and the data usage limits for the amount of data scanned per query or
// per workgroup. The workgroup settings override is specified in
// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration . See WorkGroupConfiguration$EnforceWorkGroupConfiguration
// .
type WorkGroupConfiguration struct {

	// Specifies a user defined JSON string that is passed to the notebook engine.
	AdditionalConfiguration *string

	// The upper data usage limit (cutoff) for the amount of bytes a single query in a
	// workgroup is allowed to scan.
	BytesScannedCutoffPerQuery *int64

	// Specifies the KMS key that is used to encrypt the user's data stores in Athena.
	// This setting does not apply to Athena SQL workgroups.
	CustomerContentEncryptionConfiguration *CustomerContentEncryptionConfiguration

	// Enforces a minimal level of encryption for the workgroup for query and
	// calculation results that are written to Amazon S3. When enabled, workgroup users
	// can set encryption only to the minimum level set by the administrator or higher
	// when they submit queries.
	//
	// The EnforceWorkGroupConfiguration setting takes precedence over the
	// EnableMinimumEncryptionConfiguration flag. This means that if
	// EnforceWorkGroupConfiguration is true, the EnableMinimumEncryptionConfiguration
	// flag is ignored, and the workgroup configuration for encryption is used.
	EnableMinimumEncryptionConfiguration *bool

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false", client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	EnforceWorkGroupConfiguration *bool

	// The engine version that all queries running on the workgroup use. Queries on
	// the AmazonAthenaPreviewFunctionality workgroup run on the preview engine
	// regardless of this setting.
	EngineVersion *EngineVersion

	// The ARN of the execution role used to access user resources for Spark sessions
	// and IAM Identity Center enabled workgroups. This property applies only to Spark
	// enabled workgroups and IAM Identity Center enabled workgroups. The property is
	// required for IAM Identity Center enabled workgroups.
	ExecutionRole *string

	// Specifies whether the workgroup is IAM Identity Center supported.
	IdentityCenterConfiguration *IdentityCenterConfiguration

	//  The configuration for storing results in Athena owned storage, which includes
	// whether this feature is enabled; whether encryption configuration, if any, is
	// used for encrypting query results.
	ManagedQueryResultsConfiguration *ManagedQueryResultsConfiguration

	// Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
	PublishCloudWatchMetricsEnabled *bool

	// Specifies whether Amazon S3 access grants are enabled for query results.
	QueryResultsS3AccessGrantsConfiguration *QueryResultsS3AccessGrantsConfiguration

	// If set to true , allows members assigned to a workgroup to reference Amazon S3
	// Requester Pays buckets in queries. If set to false , workgroup members cannot
	// query data from Requester Pays buckets, and queries that retrieve data from
	// Requester Pays buckets cause an error. The default is false . For more
	// information about Requester Pays buckets, see [Requester Pays Buckets]in the Amazon Simple Storage
	// Service Developer Guide.
	//
	// [Requester Pays Buckets]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
	RequesterPaysEnabled *bool

	// The configuration for the workgroup, which includes the location in Amazon S3
	// where query and calculation results are stored and the encryption option, if
	// any, used for query and calculation results. To run the query, you must specify
	// the query results location using one of the ways: either in the workgroup using
	// this setting, or for individual queries (client-side), using ResultConfiguration$OutputLocation. If none of them
	// is set, Athena issues an error that no output location is provided.
	ResultConfiguration *ResultConfiguration

	noSmithyDocumentSerde
}

// The configuration information that will be updated for this workgroup, which
// includes the location in Amazon S3 where query and calculation results are
// stored, the encryption option, if any, used for query results, whether the
// Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup
// settings override the client-side settings, and the data usage limit for the
// amount of bytes scanned per query, if it is specified.
type WorkGroupConfigurationUpdates struct {

	// Contains a user defined string in JSON format for a Spark-enabled workgroup.
	AdditionalConfiguration *string

	// The upper limit (cutoff) for the amount of bytes a single query in a workgroup
	// is allowed to scan.
	BytesScannedCutoffPerQuery *int64

	// Specifies the customer managed KMS key that is used to encrypt the user's data
	// stores in Athena. When an Amazon Web Services managed key is used, this value is
	// null. This setting does not apply to Athena SQL workgroups.
	CustomerContentEncryptionConfiguration *CustomerContentEncryptionConfiguration

	// Enforces a minimal level of encryption for the workgroup for query and
	// calculation results that are written to Amazon S3. When enabled, workgroup users
	// can set encryption only to the minimum level set by the administrator or higher
	// when they submit queries. This setting does not apply to Spark-enabled
	// workgroups.
	//
	// The EnforceWorkGroupConfiguration setting takes precedence over the
	// EnableMinimumEncryptionConfiguration flag. This means that if
	// EnforceWorkGroupConfiguration is true, the EnableMinimumEncryptionConfiguration
	// flag is ignored, and the workgroup configuration for encryption is used.
	EnableMinimumEncryptionConfiguration *bool

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false" client-side settings are used. For more information, see [Workgroup Settings Override Client-Side Settings].
	//
	// [Workgroup Settings Override Client-Side Settings]: https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html
	EnforceWorkGroupConfiguration *bool

	// The engine version requested when a workgroup is updated. After the update, all
	// queries on the workgroup run on the requested engine version. If no value was
	// previously set, the default is Auto. Queries on the
	// AmazonAthenaPreviewFunctionality workgroup run on the preview engine regardless
	// of this setting.
	EngineVersion *EngineVersion

	// The ARN of the execution role used to access user resources for Spark sessions
	// and Identity Center enabled workgroups. This property applies only to Spark
	// enabled workgroups and Identity Center enabled workgroups.
	ExecutionRole *string

	// Updates configuration information for managed query results in the workgroup.
	ManagedQueryResultsConfigurationUpdates *ManagedQueryResultsConfigurationUpdates

	// Indicates whether this workgroup enables publishing metrics to Amazon
	// CloudWatch.
	PublishCloudWatchMetricsEnabled *bool

	// Specifies whether Amazon S3 access grants are enabled for query results.
	QueryResultsS3AccessGrantsConfiguration *QueryResultsS3AccessGrantsConfiguration

	// Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
	RemoveBytesScannedCutoffPerQuery *bool

	// Removes content encryption configuration from an Apache Spark-enabled Athena
	// workgroup.
	RemoveCustomerContentEncryptionConfiguration *bool

	// If set to true , allows members assigned to a workgroup to specify Amazon S3
	// Requester Pays buckets in queries. If set to false , workgroup members cannot
	// query data from Requester Pays buckets, and queries that retrieve data from
	// Requester Pays buckets cause an error. The default is false . For more
	// information about Requester Pays buckets, see [Requester Pays Buckets]in the Amazon Simple Storage
	// Service Developer Guide.
	//
	// [Requester Pays Buckets]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
	RequesterPaysEnabled *bool

	// The result configuration information about the queries in this workgroup that
	// will be updated. Includes the updated results location and an updated option for
	// encrypting query results.
	ResultConfigurationUpdates *ResultConfigurationUpdates

	noSmithyDocumentSerde
}

// The summary information for the workgroup, which includes its name, state,
// description, and the date and time it was created.
type WorkGroupSummary struct {

	// The workgroup creation date and time.
	CreationTime *time.Time

	// The workgroup description.
	Description *string

	// The engine version setting for all queries on the workgroup. Queries on the
	// AmazonAthenaPreviewFunctionality workgroup run on the preview engine regardless
	// of this setting.
	EngineVersion *EngineVersion

	// The ARN of the IAM Identity Center enabled application associated with the
	// workgroup.
	IdentityCenterApplicationArn *string

	// The name of the workgroup.
	Name *string

	// The state of the workgroup.
	State WorkGroupState

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
