// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the events that occurred during a plan execution. These events provide a
// detailed timeline of the execution process.
func (c *Client) ListPlanExecutionEvents(ctx context.Context, params *ListPlanExecutionEventsInput, optFns ...func(*Options)) (*ListPlanExecutionEventsOutput, error) {
	if params == nil {
		params = &ListPlanExecutionEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPlanExecutionEvents", params, optFns, c.addOperationListPlanExecutionEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPlanExecutionEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPlanExecutionEventsInput struct {

	// The execution identifier of a plan execution.
	//
	// This member is required.
	ExecutionId *string

	// The Amazon Resource Name (ARN) of the plan.
	//
	// This member is required.
	PlanArn *string

	// The number of objects that you want to return with this call.
	MaxResults *int32

	// The name of the plan execution event.
	Name *string

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a nextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's nextToken response to request the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPlanExecutionEventsOutput struct {

	// The items in the plan execution event.
	Items []types.ExecutionEvent

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a nextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's nextToken response to request the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPlanExecutionEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&smithyRpcv2cbor_serializeOpListPlanExecutionEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&smithyRpcv2cbor_deserializeOpListPlanExecutionEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPlanExecutionEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addUserAgentFeatureProtocolRPCV2CBOR(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPlanExecutionEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPlanExecutionEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPlanExecutionEventsPaginatorOptions is the paginator options for
// ListPlanExecutionEvents
type ListPlanExecutionEventsPaginatorOptions struct {
	// The number of objects that you want to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPlanExecutionEventsPaginator is a paginator for ListPlanExecutionEvents
type ListPlanExecutionEventsPaginator struct {
	options   ListPlanExecutionEventsPaginatorOptions
	client    ListPlanExecutionEventsAPIClient
	params    *ListPlanExecutionEventsInput
	nextToken *string
	firstPage bool
}

// NewListPlanExecutionEventsPaginator returns a new
// ListPlanExecutionEventsPaginator
func NewListPlanExecutionEventsPaginator(client ListPlanExecutionEventsAPIClient, params *ListPlanExecutionEventsInput, optFns ...func(*ListPlanExecutionEventsPaginatorOptions)) *ListPlanExecutionEventsPaginator {
	if params == nil {
		params = &ListPlanExecutionEventsInput{}
	}

	options := ListPlanExecutionEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPlanExecutionEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPlanExecutionEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPlanExecutionEvents page.
func (p *ListPlanExecutionEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPlanExecutionEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPlanExecutionEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPlanExecutionEventsAPIClient is a client that implements the
// ListPlanExecutionEvents operation.
type ListPlanExecutionEventsAPIClient interface {
	ListPlanExecutionEvents(context.Context, *ListPlanExecutionEventsInput, ...func(*Options)) (*ListPlanExecutionEventsOutput, error)
}

var _ ListPlanExecutionEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPlanExecutionEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPlanExecutionEvents",
	}
}
