// Code generated by smithy-go-codegen DO NOT EDIT.

package geoplaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geoplaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The autocomplete operation speeds up and increases the accuracy of entering
// addresses by providing a list of address candidates matching a partially entered
// address. Results are sorted from most to least matching. Filtering and biasing
// can be used to increase the relevance of the results if additional search
// context is known
func (c *Client) Autocomplete(ctx context.Context, params *AutocompleteInput, optFns ...func(*Options)) (*AutocompleteOutput, error) {
	if params == nil {
		params = &AutocompleteInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Autocomplete", params, optFns, c.addOperationAutocompleteMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AutocompleteOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AutocompleteInput struct {

	// The free-form text query to match addresses against. This is usually a
	// partially typed address from an end user in an address box or form.
	//
	// This member is required.
	QueryText *string

	// A list of optional additional parameters that can be requested for each result.
	AdditionalFeatures []types.AutocompleteAdditionalFeature

	// The position in longitude and latitude that the results should be close to.
	// Typically, place results returned are ranked higher the closer they are to this
	// position. Stored in [lng, lat] and in the WSG84 format.
	//
	// The fields BiasPosition , FilterBoundingBox , and FilterCircle are mutually
	// exclusive.
	BiasPosition []float64

	// A structure which contains a set of inclusion/exclusion properties that results
	// must posses in order to be returned as a result.
	Filter *types.AutocompleteFilter

	// Indicates if the results will be stored. Defaults to SingleUse , if left empty.
	IntendedUse types.AutocompleteIntendedUse

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// A list of [BCP 47] compliant language codes for the results to be rendered in. If there
	// is no data for the result in the requested language, data will be returned in
	// the default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// An optional limit for the number of results returned in a single call.
	MaxResults *int32

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The PostalCodeMode affects how postal code results are returned. If a postal
	// code spans multiple localities and this value is empty, partial district or
	// locality information may be returned under a single postal code result entry. If
	// it's populated with the value cityLookup , all cities in that postal code are
	// returned.
	PostalCodeMode types.PostalCodeMode

	noSmithyDocumentSerde
}

type AutocompleteOutput struct {

	// The pricing bucket for which the query is charged at.
	//
	// For more inforamtion on pricing, please visit [Amazon Location Service Pricing].
	//
	// [Amazon Location Service Pricing]: https://aws.amazon.com/location/pricing/
	//
	// This member is required.
	PricingBucket *string

	// List of places or results returned for a query.
	ResultItems []types.AutocompleteResultItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAutocompleteMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAutocomplete{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAutocomplete{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Autocomplete"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAutocompleteValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAutocomplete(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAutocomplete(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Autocomplete",
	}
}
