// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the input usage modifications associated with a bill estimate.
func (c *Client) ListBillEstimateInputUsageModifications(ctx context.Context, params *ListBillEstimateInputUsageModificationsInput, optFns ...func(*Options)) (*ListBillEstimateInputUsageModificationsOutput, error) {
	if params == nil {
		params = &ListBillEstimateInputUsageModificationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillEstimateInputUsageModifications", params, optFns, c.addOperationListBillEstimateInputUsageModificationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillEstimateInputUsageModificationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillEstimateInputUsageModificationsInput struct {

	//  The unique identifier of the bill estimate to list input usage modifications
	// for.
	//
	// This member is required.
	BillEstimateId *string

	//  Filters to apply to the list of input usage modifications.
	Filters []types.ListUsageFilter

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBillEstimateInputUsageModificationsOutput struct {

	//  The list of input usage modifications associated with the bill estimate.
	Items []types.BillEstimateInputUsageModificationSummary

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillEstimateInputUsageModificationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillEstimateInputUsageModifications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillEstimateInputUsageModifications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillEstimateInputUsageModifications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBillEstimateInputUsageModificationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillEstimateInputUsageModifications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListBillEstimateInputUsageModificationsPaginatorOptions is the paginator
// options for ListBillEstimateInputUsageModifications
type ListBillEstimateInputUsageModificationsPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillEstimateInputUsageModificationsPaginator is a paginator for
// ListBillEstimateInputUsageModifications
type ListBillEstimateInputUsageModificationsPaginator struct {
	options   ListBillEstimateInputUsageModificationsPaginatorOptions
	client    ListBillEstimateInputUsageModificationsAPIClient
	params    *ListBillEstimateInputUsageModificationsInput
	nextToken *string
	firstPage bool
}

// NewListBillEstimateInputUsageModificationsPaginator returns a new
// ListBillEstimateInputUsageModificationsPaginator
func NewListBillEstimateInputUsageModificationsPaginator(client ListBillEstimateInputUsageModificationsAPIClient, params *ListBillEstimateInputUsageModificationsInput, optFns ...func(*ListBillEstimateInputUsageModificationsPaginatorOptions)) *ListBillEstimateInputUsageModificationsPaginator {
	if params == nil {
		params = &ListBillEstimateInputUsageModificationsInput{}
	}

	options := ListBillEstimateInputUsageModificationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillEstimateInputUsageModificationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillEstimateInputUsageModificationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillEstimateInputUsageModifications page.
func (p *ListBillEstimateInputUsageModificationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillEstimateInputUsageModificationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillEstimateInputUsageModifications(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillEstimateInputUsageModificationsAPIClient is a client that implements
// the ListBillEstimateInputUsageModifications operation.
type ListBillEstimateInputUsageModificationsAPIClient interface {
	ListBillEstimateInputUsageModifications(context.Context, *ListBillEstimateInputUsageModificationsInput, ...func(*Options)) (*ListBillEstimateInputUsageModificationsOutput, error)
}

var _ ListBillEstimateInputUsageModificationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillEstimateInputUsageModifications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillEstimateInputUsageModifications",
	}
}
