module cubedag_object
  use cubelist_types
  use cubedag_parameters
  use cubedag_messaging
  !
  public :: dag_object_t
  public :: cubedag_object_ptr
  private
  !
  type, abstract, extends(list_object_t) :: dag_object_t
  contains
    procedure(get_id_interface), deferred :: get_id
  end type dag_object_t
  !
  abstract interface
    function get_id_interface(obj)
      import iden_l,dag_object_t
      integer(kind=iden_l) :: get_id_interface
      class(dag_object_t), intent(in) :: obj
    end function get_id_interface
  end interface
  !
contains
  !
  function cubedag_object_ptr(lot,error)
    !-------------------------------------------------------------------
    ! Check if the input class is a 'dag_object_t', and return a pointer
    ! to it if relevant.
    !-------------------------------------------------------------------
    class(dag_object_t),  pointer :: cubedag_object_ptr  ! Function value on return
    class(list_object_t), pointer       :: lot
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='OBJECT>PTR'
    !
    select type(lot)
    class is (dag_object_t)
      cubedag_object_ptr => lot
    class default
      cubedag_object_ptr => null()
      call cubedag_message(seve%e,rname,'Internal error: object is not a dag_object_t')
      error = .true.
      return
    end select
  end function cubedag_object_ptr
  !
end module cubedag_object
