/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.fs.BaseHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.ImplHFSFileSystemView;
import org.catacombae.hfsexplorer.types.hfs.ExtDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.io.ReadableRandomAccessStream;

public class ImplHFSAllocationFileView
extends BaseHFSAllocationFileView {
    private final ImplHFSFileSystemView hfsParentView;
    private final ReadableRandomAccessStream volumeBitmap;

    public ImplHFSAllocationFileView(ImplHFSFileSystemView parentView, ReadableRandomAccessStream volumeBitmap) {
        super(parentView, volumeBitmap);
        this.hfsParentView = parentView;
        this.volumeBitmap = volumeBitmap;
    }

    public boolean isAllocationBlockUsed(long blockNumber) throws IllegalArgumentException {
        if (blockNumber < 0L || blockNumber > 65534L) {
            throw new IllegalArgumentException("Block number (" + blockNumber + ") out of range for UInt16!");
        }
        return super.isAllocationBlockUsed(blockNumber);
    }

    public CommonHFSExtentDescriptor createExtentDescriptor(long startBlock, long blockCount) {
        if (startBlock < 0L || startBlock > 65534L) {
            throw new IllegalArgumentException("startBlock(" + startBlock + ") out of range for UInt16!");
        }
        if (blockCount < 0L || blockCount > 65534L) {
            throw new IllegalArgumentException("blockCount(" + blockCount + ") out of range for UInt16!");
        }
        ExtDescriptor ed = new ExtDescriptor((short)startBlock, (short)blockCount);
        return CommonHFSExtentDescriptor.create(ed);
    }
}

