//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: $
//

#include "G4CascadeKzeroNChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int k0n2bfs[1][2] =
    {{neu,k0}};

  static const G4int k0n3bfs[6][3] =
    {{neu,pi0,k0}, {pro,pim,k0}, {neu,pim,kpl}, {k0,k0,lam}, {k0,k0,s0},
     {kpl,k0,sm}};
 
  static const G4int k0n4bfs[16][4] =
    {{neu,pi0,pi0,k0},  {neu,pip,pim,k0}, {pro,pim,pi0,k0}, {neu,pim,pi0,kpl},
     {pro,pim,pim,kpl}, {neu,kpl,kmi,k0}, {neu,k0,k0,k0b},  {pro,kmi,k0,k0},
     {pi0,k0,k0,lam},   {pim,kpl,k0,lam}, {pim,kpl,kpl,sm}, {pip,k0,k0,sm},
     {pi0,kpl,k0,sm},   {pim,kpl,k0,s0},  {pi0,k0,k0,s0},   {pim,k0,k0,sp}};

  static const G4int k0n5bfs[29][5] =
    {{neu,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,k0},  {pro,pim,pi0,pi0,k0},
     {pro,pip,pim,pim,k0},  {neu,pim,pi0,pi0,kpl}, {neu,pip,pim,pim,kpl},
     {pro,pim,pim,pi0,kpl}, {neu,pi0,kpl,kmi,k0},  {neu,pi0,k0,k0,k0b},
     {neu,pip,kmi,k0,k0},   {neu,pim,kpl,k0,k0b},  {pro,pim,kpl,kmi,k0},
     {pro,pim,k0,k0,k0b},   {pro,pi0,kmi,k0,k0},   {neu,pim,kpl,kpl,kmi}, 
     {pi0,pi0,k0,k0,lam},   {pip,pim,k0,k0,lam},   {pim,pi0,kpl,k0,lam},
     {pim,pim,kpl,kpl,lam}, {pip,pim,kpl,k0,sm},   {pim,pi0,kpl,kpl,sm},
     {pip,pi0,k0,k0,sm},    {pi0,pi0,kpl,k0,sm},   {pi0,pi0,k0,k0,s0}, 
     {pip,pim,k0,k0,s0},    {pim,pi0,kpl,k0,s0},   {pim,pim,kpl,kpl,s0},
     {pim,pim,kpl,k0,sp},   {pim,pi0,k0,k0,sp}};

  static const G4int k0n6bfs[42][6] =
    {{neu,pi0,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,pi0,k0},
     {neu,pip,pip,pim,pim,k0},  {pro,pim,pi0,pi0,pi0,k0},
     {pro,pip,pim,pim,pi0,k0},  {neu,pim,pi0,pi0,pi0,kpl},
     {neu,pip,pim,pim,pi0,kpl}, {pro,pim,pim,pi0,pi0,kpl}, 
     {pro,pip,pim,pim,pim,kpl}, {neu,pi0,pi0,k0,k0,k0b},
     {neu,pip,pim,k0,k0,k0b},   {neu,pip,pi0,kmi,k0,k0},
     {neu,pi0,pi0,kpl,kmi,k0},  {neu,pip,pim,kpl,kmi,k0}, 
     {neu,pim,pi0,kpl,k0,k0b},  {neu,pim,pim,kpl,kpl,k0b},
     {neu,pim,pi0,kpl,kpl,kmi}, {pro,pim,pim,kpl,k0,k0b},
     {pro,pi0,pi0,kmi,k0,k0},   {pro,pip,pim,kmi,k0,k0}, 
     {pro,pim,pi0,k0,k0,k0b},   {pro,pim,pi0,kpl,kmi,k0},
     {pro,pim,pim,kpl,kpl,kmi}, {pi0,pi0,pi0,k0,k0,lam},
     {pip,pim,pi0,k0,k0,lam},   {pim,pi0,pi0,kpl,k0,lam},
     {pip,pim,pim,kpl,k0,lam},  {pim,pim,pi0,kpl,kpl,lam},
     {pip,pim,pi0,kpl,k0,sm},   {pi0,pi0,pi0,kpl,k0,sm},
     {pip,pip,pim,k0,k0,sm},    {pip,pi0,pi0,k0,k0,sm},
     {pim,pi0,pi0,kpl,kpl,sm},  {pip,pim,pim,kpl,kpl,sm},
     {pip,pim,pi0,k0,k0,s0},    {pim,pi0,pi0,kpl,k0,s0},
     {pip,pim,pim,kpl,k0,s0},   {pim,pim,pi0,kpl,kpl,s0},
     {pim,pi0,pi0,k0,k0,sp},    {pip,pim,pim,k0,k0,sp},
     {pim,pim,pi0,kpl,k0,sp},   {pim,pim,pim,kpl,kpl,sp}};

  static const G4int k0n7bfs[54][7] =
    {{neu,pi0,pi0,pi0,pi0,pi0,k0},  {neu,pip,pim,pi0,pi0,pi0,k0},
     {neu,pip,pip,pim,pim,pi0,k0},  {pro,pim,pi0,pi0,pi0,pi0,k0},
     {pro,pip,pim,pim,pi0,pi0,k0},  {pro,pip,pip,pim,pim,pim,k0},
     {neu,pim,pi0,pi0,pi0,pi0,kpl}, {neu,pip,pim,pim,pi0,pi0,kpl},
     {neu,pip,pip,pim,pim,pim,kpl}, {pro,pim,pim,pi0,pi0,pi0,kpl},
     {pro,pip,pim,pim,pim,pi0,kpl}, {neu,pi0,pi0,pi0,k0,k0,k0b},
     {neu,pip,pim,pi0,k0,k0,k0b},   {neu,pip,pi0,pi0,kmi,k0,k0},
     {neu,pip,pip,pim,kmi,k0,k0},   {neu,pi0,pi0,pi0,kpl,kmi,k0},
     {neu,pip,pim,pi0,kpl,kmi,k0},  {neu,pim,pi0,pi0,kpl,k0,k0b},
     {neu,pip,pim,pim,kpl,k0,k0b},  {neu,pim,pim,pi0,kpl,kpl,k0b},
     {neu,pim,pi0,pi0,kpl,kpl,kmi}, {neu,pip,pim,pim,kpl,kpl,kmi},
     {pro,pim,pim,pi0,kpl,k0,k0b},  {pro,pi0,pi0,pi0,kmi,k0,k0},
     {pro,pip,pim,pi0,kmi,k0,k0},   {pro,pim,pi0,pi0,k0,k0,k0b},
     {pro,pip,pim,pim,k0,k0,k0b},   {pro,pim,pi0,pi0,kpl,kmi,k0},
     {pro,pip,pim,pim,kpl,kmi,k0},  {pro,pim,pim,pi0,kpl,kpl,kmi},
     {pro,pim,pim,pim,kpl,kpl,k0b}, {pip,pim,pi0,pi0,k0,k0,lam},
     {pip,pip,pim,pim,k0,k0,lam},   {pip,pim,pim,pi0,kpl,k0,lam},
     {pim,pi0,pi0,pi0,kpl,k0,lam},  {pim,pim,pi0,pi0,kpl,kpl,lam},
     {pip,pim,pim,pim,kpl,kpl,lam}, {pim,pim,pi0,pi0,kpl,kpl,s0},
     {pip,pim,pim,pim,kpl,kpl,s0},  {pip,pim,pim,pi0,kpl,k0,s0},
     {pim,pi0,pi0,pi0,kpl,k0,s0},   {pip,pim,pi0,pi0,k0,k0,s0},
     {pip,pip,pim,pim,k0,k0,s0},    {pip,pim,pi0,pi0,kpl,k0,sm},
     {pip,pip,pim,pim,kpl,k0,sm},   {pip,pim,pim,pi0,kpl,kpl,sm},
     {pim,pi0,pi0,pi0,kpl,kpl,sm},  {pip,pip,pim,pi0,k0,k0,sm},
     {pip,pi0,pi0,pi0,k0,k0,sm},    {pip,pim,pim,pi0,k0,k0,sp},
     {pim,pi0,pi0,pi0,k0,k0,sp},    {pim,pim,pi0,pi0,kpl,k0,sp},
     {pip,pim,pim,pim,kpl,k0,sp},   {pim,pim,pim,pi0,kpl,kpl,sp}};

  static const G4int k0n8bfs[41][8] =
    {{neu,pip,pip,pim,pim,pi0,pi0,k0},  {neu,pip,pip,pim,pim,pim,pi0,kpl},
     {neu,pip,pim,pim,pi0,pi0,pi0,kpl}, {pro,pip,pip,pim,pim,pim,pi0,k0},
     {pro,pip,pim,pim,pi0,pi0,pi0,k0},  {pro,pip,pim,pim,pim,pi0,pi0,kpl},
     {neu,pip,pim,pi0,pi0,pi0,pi0,k0},  {neu,pip,pip,pip,pim,pim,pim,k0},
     {pro,pim,pim,pi0,pi0,pi0,pi0,kpl}, {pro,pip,pip,pim,pim,pim,pim,kpl},
     {neu,pim,pi0,pi0,pi0,pi0,pi0,kpl}, {pro,pim,pi0,pi0,pi0,pi0,pi0,k0},
     {pip,pim,pim,pi0,pi0,kpl,k0,lam},  {pip,pip,pim,pim,pi0,k0,k0,lam},
     {pip,pim,pi0,pi0,pi0,k0,k0,lam},   {pip,pip,pim,pim,pim,kpl,k0,lam},
     {pip,pim,pim,pim,pi0,kpl,kpl,lam}, {pim,pi0,pi0,pi0,pi0,kpl,k0,lam},
     {pim,pim,pi0,pi0,pi0,kpl,kpl,lam}, {pip,pim,pim,pi0,pi0,kpl,k0,s0},
     {pip,pip,pim,pim,pi0,k0,k0,s0},    {pip,pim,pi0,pi0,pi0,k0,k0,s0},
     {pip,pip,pim,pim,pim,kpl,k0,s0},   {pip,pim,pim,pim,pi0,kpl,kpl,s0},
     {pim,pi0,pi0,pi0,pi0,kpl,k0,s0},   {pim,pim,pi0,pi0,pi0,kpl,kpl,s0},
     {pip,pip,pim,pim,pi0,kpl,k0,sm},   {pip,pip,pim,pi0,pi0,k0,k0,sm},
     {pip,pim,pi0,pi0,pi0,kpl,k0,sm},   {pip,pim,pim,pi0,pi0,kpl,kpl,sm},
     {pip,pi0,pi0,pi0,pi0,k0,k0,sm},    {pip,pip,pip,pim,pim,k0,k0,sm},
     {pim,pi0,pi0,pi0,pi0,kpl,kpl,sm},  {pip,pip,pim,pim,pim,kpl,kpl,sm},
     {pip,pim,pim,pim,pi0,kpl,k0,sp},   {pip,pim,pim,pi0,pi0,k0,k0,sp},
     {pim,pim,pi0,pi0,pi0,kpl,k0,sp},   {pip,pip,pim,pim,pim,k0,k0,sp},
     {pim,pim,pim,pi0,pi0,kpl,kpl,sp},  {pim,pi0,pi0,pi0,pi0,k0,k0,sp},
     {pip,pim,pim,pim,pim,kpl,kpl,sp}};

  static const G4int k0n9bfs[47][9] =
    {{neu,pip,pip,pim,pim,pi0,pi0,pi0,k0}, {neu,pip,pip,pim,pim,pim,pi0,pi0,kpl},
     {pro,pip,pip,pim,pim,pim,pi0,pi0,k0}, {neu,pip,pip,pip,pim,pim,pim,pi0,k0},
     {pro,pip,pim,pim,pim,pi0,pi0,pi0,kpl},{neu,pip,pim,pim,pi0,pi0,pi0,pi0,kpl},
     {pro,pip,pim,pim,pi0,pi0,pi0,pi0,k0}, {pro,pip,pip,pim,pim,pim,pim,pi0,kpl},
     {neu,pip,pim,pi0,pi0,pi0,pi0,pi0,k0}, {neu,pip,pip,pip,pim,pim,pim,pim,kpl},
     {pro,pip,pip,pip,pim,pim,pim,pim,k0}, {pro,pim,pim,pi0,pi0,pi0,pi0,pi0,kpl},
     {pip,pim,pim,pim,pi0,pi0,kpl,kpl,lam},{pip,pip,pim,pim,pim,pi0,kpl,k0,lam},
     {pip,pim,pim,pi0,pi0,pi0,kpl,k0,lam}, {pip,pip,pim,pim,pi0,pi0,k0,k0,lam},
     {pip,pim,pi0,pi0,pi0,pi0,k0,k0,lam},  {pip,pip,pip,pim,pim,pim,k0,k0,lam},
     {pim,pim,pi0,pi0,pi0,pi0,kpl,kpl,lam},{pip,pip,pim,pim,pim,pim,kpl,kpl,lam},
     {pim,pi0,pi0,pi0,pi0,pi0,kpl,k0,lam}, {pip,pim,pim,pim,pi0,pi0,kpl,kpl,s0},
     {pip,pip,pim,pim,pim,pi0,kpl,k0,s0},  {pip,pim,pim,pi0,pi0,pi0,kpl,k0,s0},
     {pip,pip,pim,pim,pi0,pi0,k0,k0,s0},   {pip,pim,pi0,pi0,pi0,pi0,k0,k0,s0},
     {pip,pip,pip,pim,pim,pim,k0,k0,s0},   {pim,pim,pi0,pi0,pi0,pi0,kpl,kpl,s0},
     {pip,pip,pim,pim,pim,pim,kpl,kpl,s0}, {pim,pi0,pi0,pi0,pi0,pi0,kpl,k0,s0},
     {pip,pip,pim,pim,pi0,pi0,kpl,k0,sm},  {pip,pip,pim,pi0,pi0,pi0,k0,k0,sm},
     {pip,pip,pip,pim,pim,pi0,k0,k0,sm},   {pip,pim,pi0,pi0,pi0,pi0,kpl,k0,sm},
     {pip,pim,pim,pi0,pi0,pi0,kpl,kpl,sm}, {pip,pip,pip,pim,pim,pim,kpl,k0,sm},
     {pip,pip,pim,pim,pim,pi0,kpl,kpl,sm}, {pip,pi0,pi0,pi0,pi0,pi0,k0,k0,sm},
     {pim,pi0,pi0,pi0,pi0,pi0,kpl,kpl,sm}, {pip,pim,pim,pim,pi0,pi0,kpl,k0,sp},
     {pip,pim,pim,pi0,pi0,pi0,k0,k0,sp},   {pip,pip,pim,pim,pim,pi0,k0,k0,sp},
     {pim,pim,pi0,pi0,pi0,pi0,kpl,k0,sp},  {pip,pip,pim,pim,pim,pim,kpl,k0,sp},
     {pim,pim,pim,pi0,pi0,pi0,kpl,kpl,sp}, {pip,pim,pim,pim,pim,pi0,kpl,kpl,sp},
     {pim,pi0,pi0,pi0,pi0,pi0,k0,k0,sp}};

  // Cross sections for K0 n -> 2-9 body final states
  // 
  // first index:      0: channels for mult = 2
  //                 1-6: channels for mult = 3 
  //                7-22: channels for mult = 4
  //               23-51: channels for mult = 5
  //               52-93: channels for mult = 6
  //              94-147: channels for mult = 7
  //             148-188: channels for mult = 8
  //             189-235: channels for mult = 9
  //
  // second index: kinetic energy
  // 
  static const G4double k0nCrossSections[236][30] = {
    //
    // multiplicity 2 (1 channel)
    //
    // K0 n
    { 9.50,  10.00, 10.40, 11.00, 11.40, 11.80, 12.00, 12.20, 12.50, 12.492,
     12.318, 12.25, 11.90, 11.10, 10.50, 10.00,  9.40,  8.20,  7.20,  5.85,
      5.00,   4.20,  3.80 , 3.40,  3.25,  3.10,  2.88,  2.80,  2.70,  2.65},
    //
    //  multiplicity 3 (6 channels)
    //
    //  K0 n pi0
    { 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.001, 
      0.012, 0.15, 0.52, 1.27, 1.76, 2.00, 2.038, 1.797, 1.615, 1.382, 
      1.21,  0.99, 0.83, 0.70, 0.57, 0.48, 0.39,  0.31,  0.25,  0.21}, 

    //  K0 p pi- 
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.001, 
      0.010, 0.07,  0.279, 0.572, 0.799, 0.90, 1.02, 1.26, 1.30, 1.25,  
      0.99,  0.775, 0.60,  0.45,  0.33,  0.25, 0.18, 0.13, 0.09, 0.067},
 
    //  K+ n pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.006,
      0.06, 0.43, 1.60, 4.05, 5.20, 5.399, 5.45, 4.85, 3.95, 3.00, 
      2.10, 1.44, 0.98, 0.63, 0.41, 0.266, 0.18, 0.11, 0.08, 0.064}, 
 
    //  L K0 K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.007, 0.022,
      0.027, 0.026, 0.022, 0.019, 0.016, 0.013, 0.011, 0.010, 0.008, 0.007},

    //  S0 K0 K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.007,
      0.009, 0.009, 0.007, 0.006, 0.005, 0.004, 0.004, 0.003, 0.003, 0.002},    

    //  S- K+ K0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.011,
      0.013, 0.013, 0.011, 0.010, 0.008, 0.007, 0.006, 0.005, 0.004, 0.003},

    //
    //  multiplicity 4 (16 channels)
    //
    // K0 n 2pi0
    { 0.0,  0.0,   0.0,  0.0,    0.0,    0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,   0.0,  0.0002, 0.0013, 0.004, 0.013, 0.15, 0.27, 0.425,
      0.54, 0.534, 0.42, 0.32,   0.245,  0.20,  0.146, 0.11, 0.08, 0.06},
  
    // K0 n pi+ pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,   0.001, 0.005, 0.02, 0.046, 0.099, 0.50, 1.5,  2.1,
      2.15, 2.192, 1.9,   1.59,  1.32, 1.14,  0.92,  0.79, 0.70, 0.61},
 
    // K0 p pi- pi0
    { 0.0,  0.0,   0.0,  0.0,    0.0,    0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,   0.0,  0.0002, 0.0013, 0.004, 0.013, 0.15, 0.27, 0.425,
      0.54, 0.534, 0.42, 0.32,   0.245,  0.20,  0.146, 0.11, 0.08, 0.06},

    // K+ n pi- pi0
    { 0.0,  0.0,  0.0,  0.0,    0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0024, 0.013, 0.036, 0.092, 0.70, 1.3,  1.95, 
      2.2,  2.05, 1.64, 1.29,   1.01,  0.82,  0.62,  0.47, 0.36, 0.31},

    // K+ p 2pi-
    { 0.0,  0.0,   0.0,  0.0,    0.0,    0.0,   0.0,   0.0,  0.0,  0.0,
      0.0,  0.0,   0.0,  0.0002, 0.0013, 0.004, 0.013, 0.15, 0.27, 0.425,
      0.54, 0.534, 0.42, 0.32,   0.245,  0.20,  0.146, 0.11, 0.08, 0.06},

    // n K+ K0 K-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.012, 0.015, 0.015, 0.016, 0.016, 0.015, 0.013, 0.012},

    // n K0 K0 K0b
    { 0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.001, 0.009, 0.02, 0.03, 0.038, 0.039, 0.038, 0.036, 0.03, 0.025},

    // p K0 K0 K-   
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.001, 0.009, 0.012, 0.015, 0.015, 0.016, 0.016, 0.015, 0.013, 0.012},

    // L K0 K0 pi0 
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.002,
      0.013, 0.017, 0.017, 0.018, 0.016, 0.015, 0.014, 0.013, 0.012, 0.011},
 
    // L K+ K0 pi-
    { 0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.003,
      0.023, 0.03, 0.03, 0.032, 0.028, 0.026, 0.024, 0.022, 0.02, 0.017},

    // S- K+ K+ pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S- K0 K0 pi+
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S- K+ K0 pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0005, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S0 K+ K0 pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0007, 0.002, 0.004, 0.008, 0.013, 0.017, 0.017, 0.016, 0.014, 0.012},

    // S0 K0 K0 pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0003, 0.001, 0.002, 0.004, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    // S+ K0 K0 pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0003, 0.001, 0.002, 0.004, 0.006, 0.008, 0.008, 0.007, 0.006, 0.005},

    //
    //  multiplicity 5 (29 channels)
    // 
    // K0 n 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,    0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0002, 0.0004, 0.0007, 0.002, 0.006, 0.03,
      0.09, 0.15, 0.17, 0.18, 0.16,   0.16,   0.13,   0.12,  0.11,  0.10},
   
    // K0 n pi+ pi- pi0
    { 0.0,   0.0,  0.0,  0.0,  0.0,    0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,   0.0,  0.0,  0.0,  0.0013, 0.0026, 0.0038, 0.014, 0.038, 0.17,
      0.513, 0.88, 1.03, 1.06, 0.97,   0.93,   0.81,   0.73,  0.66,  0.61},
 
    // K0 p pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,    0.0,   0.0,    0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0007, 0.001, 0.0019, 0.007, 0.019, 0.08,
      0.25, 0.45, 0.51, 0.52, 0.49,   0.47,  0.40,   0.37,  0.33,  0.30},
 
    // K0 p pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0007, 0.001, 0.0019, 0.007, 0.019, 0.08,
      0.25, 0.45, 0.51, 0.52, 0.49,   0.47,  0.40,   0.37,  0.33,  0.30},
 
    // K+ n pi- 2pi0 
    { 0.0,  0.0,   0.0,  0.0,  0.0,    0.0,    0.0,    0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,  0.0,  0.0003, 0.0005, 0.0009, 0.003, 0.008, 0.036,
      0.14, 0.265, 0.32, 0.30, 0.24,   0.20,   0.14,   0.11,  0.08,  0.06},
 
    // K+ n pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,    0.0,   0.0,    0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0006, 0.001, 0.0019, 0.006, 0.016, 0.073,
      0.29, 0.53, 0.64, 0.61, 0.48,   0.39,  0.29,   0.21,  0.16,  0.12},
 
    // K+ p 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,   0.0,  0.0,  0.0003, 0.0005, 0.0009, 0.003, 0.008, 0.036,
      0.14, 0.265, 0.32, 0.30, 0.24,   0.20,   0.14,   0.11,  0.08,  0.06},

    // n K+ K- K0 pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},

    // n K0 K0 K0b pi0
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.005, 0.020, 0.023, 0.022, 0.020, 0.016, 0.013, 0.011},
 
    // n K- K0 K0 pi+
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.005, 0.020, 0.023, 0.022, 0.020, 0.015, 0.013, 0.011},
 
    // n K+ K0 K0b pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.009, 0.034, 0.047, 0.045, 0.040, 0.031, 0.025, 0.021},
 
    // p K+ K- K0 pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.008, 0.008, 0.006, 0.005, 0.004, 0.003},
 
    // p K0 K0 K0b pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.008, 0.008, 0.006, 0.005, 0.004, 0.003},
 
    // p K- K0 K0 pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.008, 0.008, 0.006, 0.005, 0.004, 0.003},
 
    // n K+ K+ K- pi-
    { 0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.001, 0.005, 0.020, 0.023, 0.022, 0.020, 0.015, 0.012, 0.01},

    // L K0 K0 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.008, 0.007, 0.005, 0.004},
 
    // L K0 K0 pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.010, 0.019, 0.020, 0.021, 0.017, 0.015, 0.010, 0.008},
 
    // L K+ K0 pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.005, 0.024, 0.029, 0.034, 0.031, 0.028, 0.022, 0.019},
 
    // L K+ K+ 2pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.010, 0.019, 0.020, 0.021, 0.017, 0.015, 0.010, 0.008},

    // S- K+ K0 pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.010, 0.018, 0.020, 0.021, 0.019, 0.017, 0.010, 0.008},

    // S- K+ K+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},

    // S- K0 K0 pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},
 
    // S- K+ K0 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.010, 0.008, 0.005, 0.004},

    // S0 K0 K0 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.007, 0.007, 0.006, 0.006, 0.003, 0.003},
 
    // S0 K0 K0 pi+ pi-
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.008, 0.007, 0.007, 0.006, 0.006, 0.003, 0.003},

    // S0 K+ K0 pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.009, 0.010, 0.011, 0.010, 0.010, 0.007, 0.006},

    // S0 K+ K+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.001, 0.003, 0.008, 0.007, 0.007, 0.006, 0.006, 0.003, 0.003},

    // S+ K+ K0 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.009, 0.007, 0.005, 0.004},

    // S+ K0 K0 pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.010, 0.011, 0.009, 0.007, 0.005, 0.004}, 

    //
    //  multiplicity 6 (42 channels)
    // 
    // K0 n 4pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.001,
      0.01, 0.05, 0.11, 0.138, 0.14, 0.13, 0.11, 0.10, 0.09, 0.08},
 
    // K0 n pi+ pi- 2pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0,    0.0,   0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0001, 0.001, 0.006,
      0.042, 0.21, 0.44, 0.552, 0.56, 0.52, 0.44, 0.40,   0.34,  0.32},
           
    // K0 n 2pi+ 2pi-   
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.003,
      0.021, 0.105, 0.22, 0.28, 0.28, 0.26, 0.22, 0.20, 0.17, 0.16},
  
    // K0 p pi- 3pi0
    { 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,    0.0,    0.0,
      0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0001, 0.0004, 0.004,
      0.022, 0.07, 0.15, 0.22, 0.30, 0.28, 0.24, 0.22,   0.18,   0.16},
 
    // K0 p pi+ 2pi- pi0
    { 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,    0.0,   0.0,
      0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0003, 0.001, 0.011,
      0.065, 0.21, 0.45, 0.67, 0.89, 0.84, 0.71, 0.64,   0.55,  0.50},
 
    // K+ n pi- 3pi0
    { 0.0,   0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0,    0.0,    0.0,
      0.0,   0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0001, 0.0004, 0.0035,
      0.022, 0.07, 0.15, 0.221, 0.30, 0.28, 0.24, 0.22,   0.182,  0.16},
 
    // K+ n pi+ 2pi- pi0
    { 0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,    0.0,   0.0,
      0.0,   0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0003, 0.001, 0.011,
      0.065, 0.21, 0.45, 0.67, 0.89, 0.84, 0.71, 0.63,   0.55,  0.50},

    // K+ p 2pi- 2pi0
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,    0.0,    0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0001, 0.0002, 0.0015,
      0.007, 0.048, 0.105, 0.127, 0.172, 0.181, 0.15, 0.138,  0.117,  0.111},

    // K+ p pi+ 3pi-
    { 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.001,
      0.005, 0.032, 0.069, 0.085, 0.115, 0.121, 0.098, 0.09, 0.078, 0.074},

    // n K0 K0 K0b 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.004, 0.004, 0.003, 0.003, 0.002},

    // n K0 K0 K0b pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // n K- K0 K0 pi+ pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},
 
    // n K+ K0 K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // n K+ K0 K- pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.015, 0.017, 0.015, 0.013, 0.011, 0.009},
 
    // n K+ K0 K0b pi- pi0 
    { 0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0, 0.005, 0.010, 0.015, 0.017, 0.015, 0.013, 0.011, 0.009}, 

    // n K+ K+ K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // n K+ K+ K- pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // p K+ K0 K0b 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // p K0 K0 K- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   
      0.0, 0.0, 0.001, 0.002, 0.004, 0.004, 0.004, 0.003, 0.003, 0.002},

    // p K0 K0 K- pi+ pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // p K0 K0 K0b pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.005, 0.007, 0.008, 0.007, 0.006, 0.005, 0.004},

    // p K+ K0 K- pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.005, 0.010, 0.015, 0.017, 0.015, 0.013, 0.011, 0.009},

    // p K+ K+ K- 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.004, 0.004, 0.004, 0.003, 0.003, 0.002},

    // L K0 K0 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002, 0.001},
 
    // L K0 K0 pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.012, 0.012, 0.011, 0.010, 0.010},

    // L K+ K0 pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.008, 0.012, 0.012, 0.011, 0.010, 0.010},

    // L K+ K0 pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.004, 0.010, 0.017, 0.023, 0.023, 0.022, 0.021, 0.020},

    // L K+ K+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.004, 0.008, 0.012, 0.012, 0.011, 0.010, 0.010},

    // S- K+ K0 pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.006, 0.010, 0.013, 0.014, 0.014, 0.013, 0.012},

    // S- K+ K0 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S- K0 K0 2pi+ pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S- K0 K0 pi+ 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S- K+ K+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S- K+ K+ pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S0 K0 K0 pi+ pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.006, 0.005, 0.005, 0.005},

    // S0 K+ K0 pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.006, 0.005, 0.005, 0.005},

    // S0 K+ K0 pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.004, 0.008, 0.012, 0.011, 0.011, 0.010, 0.010},

    // S0 K+ K+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.006, 0.005, 0.005, 0.005},

    // S0 K0 K0 3pi0 negligible

    // S+ K0 K0 pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S+ K0 K0 pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.003, 0.003},

    // S+ K+ K0 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.006, 0.007, 0.007, 0.006, 0.006},

    // S+ K+ K+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    //
    //  multiplicity 7 (54 channels)
    // 
    // K0 n 5pi0
    { 0.0, 0.0, 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0006, 0.002, 0.003, 0.005, 0.005, 0.006, 0.005, 0.004},

    // K0 n pi+ pi- 3pi0
    { 0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,  0.0,  0.0,  0.0002,
      0.001, 0.009, 0.05, 0.16, 0.25, 0.334, 0.42, 0.44, 0.41, 0.37},

    // K0 n 2pi+ 2pi- pi0 
    { 0.0,    0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0003,
      0.0016, 0.013, 0.076, 0.24, 0.375, 0.52, 0.59, 0.66, 0.59, 0.52},

    // K0 p pi- 4pi0
    { 0.0,    0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0001, 0.001, 0.0053, 0.017, 0.027, 0.037, 0.042, 0.047, 0.044, 0.04},

    // K0 p pi+ 2pi- 2pi0 
    { 0.0,    0.0,   0.0,   0.0,  0.0,  0.0,   0.0,  0.0,   0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,  0.0,  0.0,   0.0,  0.0,   0.0,  0.0,
      0.0006, 0.006, 0.033, 0.10, 0.16, 0.219, 0.25, 0.282, 0.25, 0.22},

    // K0 p 2pi+ 3pi-
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0002, 0.002, 0.011, 0.034, 0.054, 0.073, 0.085, 0.094, 0.087, 0.08},

    // K+ n pi- 4pi0
    { 0.0,    0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,  0.0,
      0.0003, 0.002, 0.013, 0.04, 0.062, 0.087, 0.10, 0.11, 0.10, 0.09},

    // K+ n pi+ 2pi- 2pi0
    { 0.0,    0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0003,
      0.0016, 0.013, 0.076, 0.24, 0.375, 0.52, 0.59, 0.66, 0.60, 0.52},

    // K+ n 2pi+ 3pi-
    { 0.0,    0.0,  0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,    0.0,  0.0,   0.0,  0.0,   0.0,  0.0,  0.0,  0.0,  0.0002,
      0.0012, 0.01, 0.057, 0.14, 0.125, 0.17, 0.20, 0.22, 0.20, 0.18},

    // K+ p 2pi- 3pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0002, 0.002, 0.011, 0.034, 0.054, 0.073, 0.085, 0.094, 0.09, 0.08},

    // K+ p pi+ 3pi- pi0
    { 0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0,    0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,
      0.0004, 0.004, 0.022, 0.068, 0.108, 0.147, 0.171, 0.188, 0.18, 0.16},

    // n K0 K0 K0b 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.002},

    // n K0 K0 K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.013, 0.012, 0.012},

    // n K0 K0 K- pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // n K0 K0 K- 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.001, 0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // n K+ K0 K- 3pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.002, 0.003, 0.004, 0.004, 0.004, 0.004},

    // n K+ K0 K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.013, 0.012, 0.012},
           
    // n K+ K0 K0b pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.013, 0.012, 0.012},
    
    // n K+ K0 K0b pi+ 2pi- 
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.013, 0.012, 0.012},

    // n K+ K+ K0b 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.001, 0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // n K+ K+ K- pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.00,  0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // n K+ K+ K- pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.001, 0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // p K+ K0 K0b 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.013, 0.012, 0.012},

    // p K- K0 K0 3pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.003, 0.003, 0.002, 0.002},

    // p K- K0 K0 pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.012, 0.012, 0.012},

    // p K0 K0 K0b pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.002, 0.004, 0.005, 0.006, 0.006, 0.006},
 
    // p K0 K0 K0b pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // p K+ K- K0 pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.008, 0.011, 0.012, 0.012, 0.012},

    // p K+ K- K0 pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.002, 0.005, 0.009, 0.011, 0.012, 0.012, 0.012},

    // p K+ K+ K- 2pi- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.002, 0.004, 0.005, 0.006, 0.006, 0.006},

    // p K+ K+ K0b 3pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0,  0.0,  0.0,  0.0,  0.001, 0.002, 0.002, 0.003, 0.003, 0.003},

    // L K0 K0 4pi0  negligible

    // L K0 K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.003, 0.004, 0.003, 0.003},

    // L K0 K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.003, 0.002, 0.002},

    // L K+ K0 pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.010, 0.012, 0.017, 0.023, 0.017, 0.015},

    // L K+ K0 pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003},

    // L K+ K+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.005, 0.007, 0.009, 0.007, 0.005},

    // L K+ K+ pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.005, 0.007, 0.009, 0.007, 0.005},

    // S0 K+ K+ 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.005, 0.007, 0.009, 0.007, 0.005},

    // S0 K+ K+ pi+ 3pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.002, 0.004, 0.005, 0.005, 0.007, 0.009, 0.007, 0.005},

    // S0 K+ K0 pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.010, 0.012, 0.017, 0.023, 0.017, 0.015},
 
    // S0 K+ K0 pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.004, 0.003, 0.003},

    // S0 K0 K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.004, 0.004, 0.003, 0.002},

    // S0 K0 K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.003, 0.002, 0.001},

    // S0 K0 K0 4pi0 negligible

    // S- K+ K0 pi+ pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.003, 0.007, 0.010, 0.012, 0.017, 0.023, 0.017, 0.015},

    // S- K+ K0 2pi+ 2pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.003, 0.004, 0.003, 0.003},

    // S- K+ K+ pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.002, 0.003, 0.003, 0.004, 0.003, 0.003},

    // S- K+ K+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.002, 0.002},

    // S- K0 K0 2pi+ pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.005, 0.007, 0.009, 0.007, 0.005},

    // S- K0 K0 pi+ 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // S- K+ K0 4pi0 negligible

    // S+ K0 K0 pi+ 2pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.004, 0.005, 0.005, 0.007, 0.009, 0.007, 0.006},

    // S+ K0 K0 pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002, 0.001},

    // S+ K+ K0 2pi- 2pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.001, 0.003, 0.005, 0.005, 0.007, 0.009, 0.007, 0.006},

    // S+ K+ K0 pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.003, 0.004, 0.005, 0.004, 0.004},

    // S+ K+ K+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    //
    //  multiplicity 8 (41 channels)
    //
    // n K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.006, 0.015, 0.053, 0.12, 0.27, 0.36, 0.471, 0.541},

    // n K+ 2pi+ 3pi- pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.035, 0.081, 0.18, 0.24, 0.315, 0.361},

    // n K+ pi+ 2pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.035, 0.081, 0.18, 0.24, 0.315, 0.361},

    // p K0 2pi+ 3pi- pi0 
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.035, 0.081, 0.18, 0.24, 0.315, 0.361},

    // p K0 pi+ 2pi- 3pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.035, 0.081, 0.18, 0.24, 0.315, 0.361},

    // p K+ pi+ 3pi- 2pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,  0.0,   0.0,
      0.0, 0.002, 0.004, 0.01, 0.035, 0.081, 0.18, 0.24, 0.311, 0.361},

    // n K0 pi+ pi- 4pi0
    { 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.0, 0.001, 0.002, 0.005, 0.017, 0.040, 0.09, 0.12, 0.157, 0.18},

    // n K0 3pi+ 3pi-
    { 0.0, 0.0,   0.0,    0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.0, 0.0,   0.0,    0.0,   0.0,   0.0,   0.0,  0.0,  0.0,   0.0,
      0.0, 0.001, 0.0006, 0.003, 0.012, 0.027, 0.06, 0.08, 0.105, 0.12},

    // p K+ 2pi- 4pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.008, 0.02, 0.045, 0.06, 0.078, 0.09},

    // p K+ 2pi+ 4pi-
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.001, 0.002, 0.008, 0.02, 0.045, 0.06, 0.078, 0.09},

    // n K+ pi- 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.004, 0.008, 0.018, 0.024, 0.031, 0.036},

    // p K0 pi- 5pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,   0.0,  0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.004, 0.008, 0.018, 0.024, 0.031, 0.036},

    // n K0 6pi0 is negligible

    // L K+ K0 pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.006, 0.011, 0.018, 0.020, 0.021, 0.027, 0.026},

    // L K0 K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.010, 0.013, 0.013},

    // L K0 K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.006, 0.007, 0.007, 0.008, 0.008},

    // L K+ K0 2pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.006, 0.007, 0.007, 0.008, 0.008},

    // L K+ K+ pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.003, 0.006, 0.007, 0.007, 0.008, 0.008},

    // L K+ K0 pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.005, 0.004},

    // L K+ K+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002, 0.002},

    // L K0 K0 5pi0 negligible

    // S0 K+ K0 pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.013},

    // S0 K0 K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.005, 0.006, 0.006},

    // S0 K0 K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.005, 0.004},
 
    // S0 K+ K0 2pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.005, 0.004},

    // S0 K+ K+ pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.003, 0.003, 0.005, 0.004},

    // S0 K+ K0 pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S0 K+ K+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K0 K0 5pi0 negligible

    // S- K+ K0 2pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.013},

    // S- K0 K0 2pi+ pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.005, 0.007, 0.006},

    // S- K+ K0 pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.006, 0.006, 0.008, 0.008},

    // S- K+ K+ pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.005, 0.007, 0.006},

    // S- K0 K0 pi+ 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K0 K0 3pi+ 2pi-
     { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K+ pi- 4pi0
     { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K+ 2pi+ 3pi-
     { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K0 5pi0 is negligible

    // S+ K+ K0 pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.005, 0.009, 0.010, 0.011, 0.013, 0.013},

    // S+ K0 K0 pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.006, 0.007, 0.007, 0.009, 0.008},

    // S+ K+ K0 2pi- 3pi0
     { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.001, 0.003, 0.004, 0.005, 0.005, 0.007, 0.006},

    // S+ K0 K0 2pi+ 3pi-
     { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S+ K+ K+ 3pi- 2pi0
     { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.001, 0.002, 0.002, 0.002, 0.002, 0.002, 0.002},

    // S+ K0 K0 pi- 4pi0
     { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
       0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    // S+ K+ K+ pi+ 4pi-
      { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
        0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001},

    //
    //  mulitplicity 9 (47 channels) 
    //
    // n K0 2pi+ 2pi-3pi0
    { 0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0015, 0.01, 0.03, 0.073, 0.218, 0.30, 0.43, 0.534},

    // n K+ 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0015, 0.01, 0.03, 0.073, 0.218, 0.30, 0.43, 0.534},

    // p K0 2pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,    0.0,  0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0015, 0.01, 0.03, 0.073, 0.218, 0.30, 0.43, 0.534},

    // n K0 3pi+ 3pi- pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.006, 0.02, 0.049, 0.145, 0.20, 0.286, 0.356},

    // p K+ pi+ 3pi- 3pi0
    { 0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0,   0.0,   0.0,  0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.001, 0.006, 0.02, 0.049, 0.145, 0.20, 0.286, 0.356},

    // n K+ pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.005, 0.015, 0.036, 0.109, 0.15, 0.209, 0.267},

    // p K0 pi+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.005, 0.015, 0.036, 0.109, 0.15, 0.209, 0.267},

    // p K+ 2pi+ 4pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,  0.0,
      0.0, 0.0, 0.0, 0.005, 0.015, 0.036, 0.109, 0.15, 0.209, 0.267},

    // n K0 pi+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.006, 0.015, 0.044, 0.06, 0.086, 0.107},

    // n K+ 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.012, 0.037, 0.05, 0.072, 0.089},

    // p K0 3pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.012, 0.037, 0.05, 0.072, 0.089},

    // p K+ 2pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.003, 0.007, 0.022, 0.03, 0.043, 0.054},

    // K0 n 7pi0, K0 p pi- 6pi0, K+ n pi- 6pi0 are negligible

    // L K+ K+ pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.005, 0.011, 0.016, 0.022, 0.03, 0.036, 0.040},

    // L K+ K0 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.007, 0.011, 0.015, 0.02, 0.024, 0.027},

    // L K+ K0 pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,  0.0,   0.0,
      0.0, 0.0, 0.0, 0.003, 0.007, 0.011, 0.015, 0.02, 0.024, 0.027},

    // L K0 K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.015, 0.018, 0.020},

    // L K0 K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.006},

    // L K0 K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.004},

    // L K+ K+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // L K+ K+ 2pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // L K+ K0 pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S0 K+ K+ pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.014, 0.019, 0.020},

    // S0 K+ K0 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.005, 0.007, 0.009, 0.012, 0.013},

    // S0 K+ K0 pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.004, 0.005, 0.007, 0.009, 0.012, 0.013},

    // S0 K0 K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.009, 0.010},

    // S0 K0 K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.003, 0.003, 0.003},

    // S0 K0 K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S0 K+ K+ 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K+ 2pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S0 K+ K0 pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001, 0.001},

    // S- K+ K0 2pi+ 2pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.015, 0.020, 0.020},

    // S- K0 K0 2pi+ pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.007},

    // S- K0 K0 3pi+ 2pi- pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.007},

    // S- K+ K0 pi+ pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.007},

    // S- K+ K+ pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.007},

    // S- K+ K0 3pi+ 3pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.004},
 
    // S- K+ K+ 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S- K0 K0 pi+ 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001},

    // S- K+ K+ pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.001},

    // S- K+ K0 6pi0 negligible

    // S+ K+ K0 pi+ 3pi- 2pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.002, 0.005, 0.008, 0.011, 0.014, 0.018, 0.020},

    // S+ K0 K0 pi+ 2pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.009, 0.010},

    // S+ K0 K0 2pi+ 3pi- pi0
    { 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.001, 0.002, 0.004, 0.005, 0.007, 0.009, 0.010},

    // S+ K+ K0 2pi- 4pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005},

    // S+ K+ K0 2pi+ 4pi-
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.002, 0.003, 0.004, 0.004, 0.005},

    // S+ K+ K+ 3pi- 3pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.003, 0.003},

    // S+ K+ K+ pi+ 4pi- pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,   0.0,   0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.001, 0.002, 0.002, 0.002},

    // S+ K0 K0 pi- 5pi0
    { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,   0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.002}
 };
}

const G4CascadeKzeroNChannelData::data_t
G4CascadeKzeroNChannelData::data(k0n2bfs, k0n3bfs, k0n4bfs, k0n5bfs,
				 k0n6bfs, k0n7bfs, k0n8bfs, k0n9bfs,
				 k0nCrossSections, k0*neu, "KzeroN");
