//$Id: MaterialItem.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// GGE (Geant4 Geometry Editor)
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// List Items

// Toshiaki Kodama

package GGE;



import java.io.*;



abstract class MaterialItem extends GGEItem {

  static final int G=0, KG=1;

  static final String densityUnitName[] = {"g/cm3","kg/m3"};

  static final int UNDEFIND=0, SOLID=1, LIQUID=2, GAS=3, VACUUM=4;

  static final String stateName[] = {"Undefind","Solid","Liquid","Gas","Vacuum"};

  static final String stateCode[] = {"kStateUndefined","kStateSolid","kStateLiquid","kStateGas","kVacuum"};

  static final int K=0;

  static final String tempUnitName[] = {"kelvin"};

  static final int PASCAL=0, BAR=1, ATOM=2;

  static final String pressName[] = {"pasc","bar","atm"};

  static final String pressCode[] = {"pascal","bar","atmosphere"};

  int state = SOLID, pressUnit = PASCAL, densityUnit = G, tempeUnit = K;

  float density, tempe, pressure;



}

