//$Id: GPETableModel.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GPE;


import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.io.*;

public class GPETableModel extends AbstractTableModel implements Serializable{

  protected Vector dataVector;
  private   String[]  columnNames;

  public GPETableModel(String s[],int r){
	dataVector = new Vector();
	columnNames = s;
  }
  
  public int getRowCount(){return dataVector.size();}

  public int getColumnCount(){return columnNames.length;}

  public String getColumnName(int col){ return columnNames[col]; }

  public Object getValueAt(int row, int column){
	return ((Vector)dataVector.elementAt(row)).elementAt(column);
  }

  public void addRow(Vector rowData){
	insertRow(getRowCount(), rowData);
  }

  public void addRow(Object[] rowData){
	Vector v = new Vector();
	for(int i=0; i<rowData.length; i++){
	  v.addElement(rowData[i]);
	}
	addRow(v);

  }

  /*public Class getColumnClass(int col){
   return getValueAt(0,col).getClass();
  }*/

  public Vector getDataVector(){
   return dataVector;
  }

  public boolean isCellEditable(int row, int col){
   return true;
  }

   private void justifyRows(int from, int to) {
        dataVector.setSize(getRowCount());

        for (int i = from; i < to; i++) {
            if (dataVector.elementAt(i) == null) {
                dataVector.setElementAt(new Vector(), i);
            }
            ((Vector)dataVector.elementAt(i)).setSize(getColumnCount());
        }
  }

  public void removeRow(int row){
	dataVector.remove(row);
	fireTableRowsDeleted(row, row);
  }

  public void insertRow(int row, Object[] rowData){
	Vector v = new Vector();
	for(int i=0;i<rowData.length; i++){
	  v.addElement(rowData[i]);
	}
	dataVector.insertElementAt(v, row);
	justifyRows(row, row+1);
	fireTableRowsInserted(row, row);
  }
  public void insertRow(int row, Vector rowData ){
      dataVector.insertElementAt(rowData, row);
      justifyRows(row, row+1);
      fireTableRowsInserted(row, row);
  }

  public void setValueAt(Object value, int row, int column){
    ((Vector)dataVector.elementAt(row)).setElementAt(value, column);
  }
}
