{
(* (c) Microsoft Corporation 2005-2006.  *)
  
open Fsyaccast
open Fsyaccpars
open Lexing

let unexpected_char lexbuf =
  failwith ("Unexpected character '"^(Lexing.lexeme lexbuf)^"'")

let inc_lnum bol pos = 
  let lnum = pos.Lexing.pos_lnum in 
  {pos with Lexing.pos_lnum =  lnum+1; Lexing.pos_bol = bol }

let newline lexbuf = 
  (*IF-FSHARP Lexing.lexbuf_set_curr_p lexbuf ENDIF-FSHARP*)
  (*IF-OCAML*) lexbuf.lex_curr_p <- (*ENDIF-OCAML*) 
    ( inc_lnum (Lexing.lexeme_end lexbuf) (Lexing.lexeme_end_p lexbuf))

let gettype s = (if String.contains s '<' then let n = String.index s '<'in Some (String.sub s (n + 1) ((String.index s '>' - n) - 1)) else None) 

} 

let letter = ['A'-'Z'] | ['a'-'z']
let digit = ['0'-'9']
let whitespace = [' ' '\t']
let newline = ('\n' | '\r' '\n')
let ident_start_char = letter       
let ident_char = ( ident_start_char| digit | ['\'' '_'] )
let ident = ident_start_char ident_char*
let typ = '<' [^ '\n' '\r' '>']+ '>' 

rule token = parse
 | "%{" { let p = lexeme_start_p lexbuf in header p (Buffer.create 100) lexbuf }
 | "%%" { PERCENT_PERCENT }
 | "%token" ((whitespace* typ)?) { TOKEN (gettype (lexeme lexbuf)) }
 | "%start"{ START }
 | "%prec"{ PREC }
 | "%type" (whitespace* typ) { TYPE (match gettype (lexeme lexbuf) with Some x -> x | None -> failwith "gettype") }
 | "%left" { LEFT }
 | "%right" { RIGHT }
 | "%nonassoc" { NONASSOC }
 | "error" { ERROR }
 | '<' { LESS }
 | '>' { GREATER }
 | ';' { SEMI }
 | '{' { let p = lexeme_start_p lexbuf in code p (Buffer.create 100) lexbuf }
 | whitespace+  { token lexbuf }
 | newline { newline lexbuf; token lexbuf }
 | ident_start_char ident_char* { IDENT (lexeme lexbuf) }
 | '|' { BAR }
 | "/*" { ignore(comment lexbuf); token lexbuf }
 | "//" [^'\n''\r']* {  token lexbuf  }
 | ':' { COLON }
 | _ { unexpected_char lexbuf }     
 | eof { EOF  }                                     
and header p buff = parse
 | "%}" { HEADER (Buffer.contents buff, p) }
 | newline { newline lexbuf; 
             Buffer.add_string buff "\n"; 
             header p buff lexbuf }
 | (whitespace | letter | digit) +  
      { Buffer.add_string buff (lexeme lexbuf); 
        header p buff lexbuf }
 | "'\"'" | "'\\\"'"
      { Buffer.add_string buff (lexeme lexbuf); 
        header p buff lexbuf }
 | "\"" 
      { Buffer.add_string buff (lexeme lexbuf); 
        ignore(codestring buff lexbuf); 
        header p buff lexbuf }
 | eof { EOF }
 | _ { Buffer.add_char buff (lexeme_char lexbuf 0); 
       header p buff lexbuf }
and code p buff = parse
 | "}" { CODE (Buffer.contents buff, p) }
 | "{" { Buffer.add_string buff (lexeme lexbuf); 
         ignore(code p buff lexbuf); 
         Buffer.add_string buff "}"; 
         code p buff lexbuf }
 | newline { newline lexbuf; 
             Buffer.add_string buff "\n"; 
             code p buff lexbuf }
 | "'\"'" | "'\\\"'"
      { Buffer.add_string buff (lexeme lexbuf); 
        code p buff lexbuf }
 | "\"" { Buffer.add_string buff (lexeme lexbuf); 
          ignore(codestring buff lexbuf); 
          code p buff lexbuf }
 | (whitespace | letter | digit) +  
   { Buffer.add_string buff (lexeme lexbuf); 
     code p buff lexbuf }
 | eof { EOF }
 | _ { Buffer.add_char buff (lexeme_char lexbuf 0); 
       code p buff lexbuf }


and codestring buff = parse
 |  '\\' ('"' | '\\')
   { Buffer.add_string buff (lexeme lexbuf); 
     codestring buff lexbuf } 
 | '"' { Buffer.add_string buff (lexeme lexbuf); 
         Buffer.contents buff }
 | newline { newline lexbuf; 
             Buffer.add_string buff "\n"; 
             codestring buff lexbuf }
 | (whitespace | letter | digit) +  
   { Buffer.add_string buff (lexeme lexbuf); 
     codestring buff lexbuf }
 | eof { failwith "unterminated string in code" }
 | _ { Buffer.add_char buff (lexeme_char lexbuf 0); 
       codestring buff lexbuf }


and comment = parse
 | "/*" { ignore(comment lexbuf); comment lexbuf }
 | newline { newline lexbuf; comment lexbuf }
 | "*/" { () }
 | eof { failwith "end of file in comment" }
 | [^ '/' '*' '\n' '\r' '"' '/' ]+  { comment lexbuf }
 | _  { comment lexbuf }
