
#include "common.h"
#include <corsym.h>

#define MIDL_DEFINE_GUID(type,name,l,w1,w2,b1,b2,b3,b4,b5,b6,b7,b8) \
        const type name = {l,w1,w2,{b1,b2,b3,b4,b5,b6,b7,b8}}

MIDL_DEFINE_GUID(CLSID, CorSymBinder_deprecated,0xAA544D41,0x28CB,0x11d3,0xBD,0x22,0x00,0x00,0xF8,0x08,0x49,0xBD);
MIDL_DEFINE_GUID(CLSID, CorSymReader_deprecated,0x108296C2,0x281E,0x11d3,0xBD,0x22,0x00,0x00,0xF8,0x08,0x49,0xBD);
MIDL_DEFINE_GUID(CLSID, CorSymReader_SxS,0x0A3976C5,0x4529,0x4ef8,0xB0,0xB0,0x42,0xEE,0xD3,0x70,0x82,0xCD);
MIDL_DEFINE_GUID(IID, IID_ISymUnmanagedBinder, 0xAA544D42,0x28CB,0x11d3,0xBD,0x22,0x00,0x00,0xF8,0x08,0x49,0xBD);
MIDL_DEFINE_GUID(IID, IID_ISymUnmanagedReader, 0xB4CE6286,0x2A6B,0x3712,0xA3,0xB7,0x1E,0xE1,0xDA,0xD4,0x67,0xB5);
MIDL_DEFINE_GUID(IID, IID_ISymUnmanagedDispose,0x969708D2,0x05E5,0x4861,0xA3,0xB0,0x96,0xE4,0x73,0xCD,0xF6,0x3F);

#undef MIDL_DEFINE_GUID



//-----------------------------------------------------------------------------
// Entry points used by both the Augmented-Managed (i.e. F#-on-windows) and 
// OCaml compialtions of this code.
//-----------------------------------------------------------------------------


EXTAPI pdbReadOpen(LPCTSTR moduleNameC, LPCTSTR pathC, ISymUnmanagedReader **ppRes)
{
#ifdef CAML_STUBS
#ifndef FEATURE_PAL
    IfFailRet(CoInitialize(NULL), "initializing COM");
#endif
#endif

    IMetaDataImport *pImport = NULL;
    IMetaDataDispenser *pDisp = NULL;

#ifndef FEATURE_PAL
    if (false) 
    {
#endif
        IfFailRet (PAL_MyCoCreateInstance(CLSID_CorMetaDataDispenser, 
                                          IID_IMetaDataDispenser, (void **) &pDisp), "getting SSCLI CorMetaDataDispenser");
#ifndef FEATURE_PAL
    } else {
        IfFailRet (CoCreateInstance(CLSID_CorMetaDataDispenser, NULL, CLSCTX_INPROC_SERVER, 
                                      IID_IMetaDataDispenser, (void **) &pDisp), "getting CorMetaDataDispenser");
    }
#endif

    IfFailRet (pDisp->OpenScope(moduleNameC, cssAccurate, IID_IMetaDataImport,
                                  (IUnknown**) &pImport),
                 "OpenScope");


    // Ask the binder for a reader for this module.
    ISymUnmanagedReader *pSymReader = NULL;
    
#ifndef FEATURE_PAL
    if (false) 
    {
#endif
        if (FAILED (PAL_MyCoCreateInstance(CorSymReader_SxS,
                                          IID_ISymUnmanagedReader,
                                          (void**)&pSymReader)))
            IfFailRet(PAL_MyCoCreateInstance(CorSymReader_deprecated,
                                               IID_ISymUnmanagedReader,
                                               (void**)&pSymReader), "getting SSCLI CorSymReader");
#ifndef FEATURE_PAL
    }
    else 
    {
        if (FAILED (CoCreateInstance(CorSymReader_SxS,NULL,
                                         CLSCTX_INPROC_SERVER,
                                         IID_ISymUnmanagedReader,
                                     (void**)&pSymReader)))
            IfFailRet(CoCreateInstance(CorSymReader_deprecated,NULL,
                                         CLSCTX_INPROC_SERVER,
                                         IID_ISymUnmanagedReader,
                                         (void**)&pSymReader),
                        "getting CorSymReader");
    }
#endif

    IfFailRet(pSymReader->Initialize(pImport, moduleNameC, pathC, NULL),
                "CorSymReader::Initialize");

    //ULONG32 symStoreLength;
    //IfFailRet(pSymReader->GetSymbolStoreFileName(0,&symStoreLength, NULL),"GetSymbolStoreFileName");
    //WCHAR *symStoreC = new WCHAR[symStoreLength];
    //IfFailRet(pSymReader->GetSymbolStoreFileName(symStoreLength,&symStoreLength, symStoreC),"GetSymbolStoreFileName");

    if (ppRes)
	*ppRes = pSymReader;
    
    return S_OK;

}

EXTAPI pdbReaderClose(ISymUnmanagedReader *pSymReader)
{
    ISymUnmanagedDispose *pDisposer = NULL;
    if (!FAILED(pSymReader->QueryInterface(IID_ISymUnmanagedDispose,(void **)&pDisposer)))
    {
        if (pDisposer)
            pDisposer->Destroy();
    }
    pSymReader->Release();

    return S_OK;

}

EXTAPI pdbReaderGetDocuments(ISymUnmanagedReader *pSymReader, ISymUnmanagedDocument **ppRes, ULONG32 *pResSize)
{
    ULONG32 numdocs = 0;
    IfFailRet(pSymReader->GetDocuments(0, &numdocs, NULL), "GetDocuments");
    if (pResSize)
	*pResSize = numdocs;
    if (ppRes)
        IfFailRet(pSymReader->GetDocuments(numdocs, &numdocs, ppRes), "GetDocuments");

    return S_OK;

}

EXTAPI pdbReaderGetDocument(ISymUnmanagedReader *pSymReader, LPCTSTR urlC, GUID *langC, GUID * vendorC, GUID * doctypeC, ISymUnmanagedDocument **ppRes)
{
    IfFailRet(pSymReader->GetDocument((WCHAR*) urlC, *langC, *vendorC, *doctypeC, ppRes), "GetDocument");
    return S_OK;

}

EXTAPI pdbReaderGetMethod(ISymUnmanagedReader *pSymReader, mdToken tok, ISymUnmanagedMethod **ppRes)
{
    IfFailRet(pSymReader->GetMethod(tok, ppRes), "GetMethod");
    return S_OK;
}
EXTAPI pdbReaderGetMethodFromDocumentPosition(ISymUnmanagedReader *pSymReader, ISymUnmanagedDocument *pDocument,ULONG32 line, ULONG32 col, ISymUnmanagedMethod **ppRes)
{
    IfFailRet(pSymReader->GetMethodFromDocumentPosition(pDocument, line,col, ppRes), "GetMethodFromDocumentPosition");
    return S_OK;
}


EXTAPI pdbDocumentGetURL(ISymUnmanagedDocument *pDocument, LPTSTR pRes, ULONG32 *pResSize)
{
    ULONG32 cSize;
    pDocument->GetURL(0,&cSize,NULL);
    if (pResSize)
	*pResSize = cSize;

    if (pRes)
       IfFailRet(pDocument->GetURL(cSize,&cSize,pRes), "GetURL");

    return S_OK;

}
EXTAPI pdbDocumentGetLanguage(ISymUnmanagedDocument *pDocument, GUID *pRes)
{
    pDocument->GetLanguage(pRes);
    return S_OK;
}

EXTAPI pdbDocumentGetType(ISymUnmanagedDocument *pDocument, GUID *pRes)
{
    pDocument->GetDocumentType(pRes);

    return S_OK;
}


EXTAPI pdbDocumentGetLanguageVendor(ISymUnmanagedDocument *pDocument, GUID *pRes)
{
    pDocument->GetLanguageVendor(pRes);
    return S_OK;
}


EXTAPI pdbDocumentFindClosestLine(ISymUnmanagedDocument *pDocument, ULONG32 lineC, ULONG32 *pRes)
{
    pDocument->FindClosestLine(lineC, pRes);
    return S_OK;

}


EXTAPI pdbMethodGetToken(ISymUnmanagedMethod *pMethod, mdToken *pRes)
{
    pMethod->GetToken(pRes);
    return S_OK;
}


EXTAPI pdbMethodGetRootScope(ISymUnmanagedMethod *pMethod, ISymUnmanagedScope **ppRes)
{
    IfFailRet(pMethod->GetRootScope(ppRes), "GetRootScope");
    return S_OK;
}




EXTAPI pdbMethodGetSequencePoints(ISymUnmanagedMethod *pMethod,
				  ULONG32 *pCount,
				  ULONG32 *offsetsC,
				  ISymUnmanagedDocument **documentsC,
				  ULONG32 *linesC,
				  ULONG32 *columnsC,
				  ULONG32 *endLinesC,
				  ULONG32 *endColumnsC)
{

    // Make the call and find out how many there are.
    ULONG32 count = 0;
    IfFailRet(pMethod->GetSequencePointCount(&count), "GetSequencePointCount");
    if (pCount)
	*pCount = count;

    if (offsetsC)
        IfFailRet(pMethod->GetSequencePoints(count, &count, offsetsC, documentsC, linesC, columnsC, endLinesC, endColumnsC), "GetSequencePoints");

    return S_OK;
}



EXTAPI pdbScopeGetChildren(ISymUnmanagedScope *pScope, ISymUnmanagedScope** childrenC, ULONG32 *pCount)
{

    // Make the call and find out how many there are.
    ULONG32 count = 0;
    IfFailRet(pScope->GetChildren(0, &count, NULL), "GetChildren");
    if (pCount)
	*pCount = count;

    if (childrenC)
        IfFailRet(pScope->GetChildren(count, &count, childrenC), "GetChildren");

    return S_OK;
}



EXTAPI pdbScopeGetOffsets(ISymUnmanagedScope *pScope, ULONG32 *pStart, ULONG32 *pEnd)
{

    pScope->GetStartOffset(pStart);
    pScope->GetEndOffset(pEnd);
    return S_OK;
}


EXTAPI pdbScopeGetLocals(ISymUnmanagedScope *pScope, ISymUnmanagedVariable** varsC, ULONG32 *pCount)
{
    // Make the call and find out how many there are.
    ULONG32 count = 0;
    IfFailRet(pScope->GetLocals(0, &count, NULL), "GetLocals");
    if (pCount)
	*pCount = count;

    if (varsC)
        IfFailRet(pScope->GetLocals(count, &count, varsC), "GetLocals");
    return S_OK;
}




EXTAPI pdbVariableGetName(ISymUnmanagedVariable *pVariable, LPTSTR nameC, ULONG32 *pCount)
{
    ULONG32 nameCount;
    pVariable->GetName(0,&nameCount,NULL);
    if (pCount)
	*pCount = nameCount;
    if (nameC)
        IfFailRet(pVariable->GetName(nameCount,&nameCount,nameC), "GetName");
    return S_OK;

}


EXTAPI pdbVariableGetSignature(ISymUnmanagedVariable *pVariable, BYTE *sigC, ULONG32 *pCount)
{
    ULONG32 sigCount;
    pVariable->GetSignature(0,&sigCount,NULL);
    if (pCount)
	*pCount = sigCount;
    if (sigC)
        IfFailRet(pVariable->GetSignature(sigCount,&sigCount,sigC), "GetSignature");
    return S_OK;
}



EXTAPI pdbVariableGetAddressAttributes(ISymUnmanagedVariable *pVariable, ULONG32 *pKind, ULONG32 *pIdx)
{
    IfFailRet(pVariable->GetAddressKind(pKind), "GetAddressKind");
    IfFailRet(pVariable->GetAddressField1(pIdx), "GetAddressField1");
    return S_OK;
}



#ifdef CAML_STUBS

//-----------------------------------------------------------------------------
// OCaml stubs for the above
//-----------------------------------------------------------------------------

extern "C"
CAMLprim value pdbReadOpenCaml(value moduleName, value path)
{
    CAMLparam2(moduleName, path);

    WCHAR pathC[_MAX_PATH];
    MultiByteToWideChar(CP_ACP, 0, String_val(path), -1, pathC, _MAX_PATH);

    WCHAR moduleNameC[_MAX_PATH];
    MultiByteToWideChar(CP_ACP, 0, String_val(moduleName), -1, moduleNameC, _MAX_PATH);

    ISymUnmanagedReader *pSymReader = NULL;
    IfFailThrow(pdbReadOpen(moduleNameC, pathC, &pSymReader), "opening debug information reader");
    
    CAMLlocal1(pdbReader);
    pdbReader = alloc(1,0 );
    Store_field(pdbReader,0,copy_nativeint((long) pSymReader));
    
    CAMLreturn(pdbReader);

}

extern "C"
CAMLprim value pdbReadCloseCaml(value pdbReader)
{
    CAMLparam1(pdbReader);

    ISymUnmanagedReader *pSymReader = (ISymUnmanagedReader *) Nativeint_val(Field(pdbReader,0));
    IfFailThrow(pdbReaderClose(pSymReader), "Close");

    CAMLreturn(Atom(0));

}

extern "C"
CAMLprim value pdbReaderGetDocumentsCaml(value pdbReader)
{
    CAMLparam1(pdbReader);

    ISymUnmanagedReader *pSymReader = (ISymUnmanagedReader *) Nativeint_val(Field(pdbReader,0));
    ULONG32 numdocs = 0;
    IfFailThrow(pdbReaderGetDocuments(pSymReader, NULL,&numdocs), "GetDocuments");
    CAMLlocal2(docs,doc);
    doc = Atom(0);
    docs = (numdocs == 0) ? Atom(0) : alloc(numdocs,0);

    if (numdocs > 0)
    {
        ISymUnmanagedDocument** docsC = new ISymUnmanagedDocument*[numdocs];
        IfFailThrow(pdbReaderGetDocuments(pSymReader, docsC,&numdocs), "GetDocuments");
        
        for (int i = 0; i < numdocs; i++)
        {
            doc = alloc(1,0 ); 
            ISymUnmanagedDocument *pDoc = docsC[i];
            Store_field(doc,0,copy_nativeint((long) pDoc));
            Store_field(docs,i,doc);
        }
        delete [] docsC;
    }

    CAMLreturn(docs);

}

extern "C"
CAMLprim value pdbReaderGetDocumentCaml(value pdbReader, value url, value lang, value vendor, value doctype)
{
    CAMLparam5(pdbReader, url, lang, vendor, doctype);

    ISymUnmanagedReader *pSymReader = (ISymUnmanagedReader *) Nativeint_val(Field(pdbReader,0));
    WCHAR urlC[_MAX_PATH];
    MultiByteToWideChar(CP_ACP, 0, String_val(url), -1, urlC, _MAX_PATH);
    GUID langC;
    memcpy(&langC, String_val(lang), sizeof(GUID));
    GUID vendorC;
    memcpy(&vendorC, String_val(vendor), sizeof(GUID));
    GUID doctypeC;
    memcpy(&doctypeC, String_val(doctype), sizeof(GUID));
    ISymUnmanagedDocument *pDocument;
    IfFailThrow(pdbReaderGetDocument(pSymReader, urlC,&langC, &vendorC, &doctypeC, &pDocument), "GetDocument");

    CAMLlocal1(doc);
    doc = alloc(1,0 ); 
    Store_field(doc,0,copy_nativeint((long) pDocument));

    CAMLreturn (doc);

}

extern "C"
CAMLprim value pdbReaderGetMethodCaml(value pdbReader, value token)
{
    CAMLparam2(pdbReader, token);

    ISymUnmanagedReader *pSymReader = (ISymUnmanagedReader *) Nativeint_val(Field(pdbReader,0));
    mdToken tok = Int32_val(token);

    ISymUnmanagedMethod *pMethod;
    IfFailThrow(pdbReaderGetMethod(pSymReader,tok, &pMethod), "GetMethod");
    
    CAMLlocal1(res);
    res = alloc(2,0);
    Store_field(res,0,copy_nativeint((long) pMethod));
    Store_field(res,1,pdbReader);

    CAMLreturn(res);

}
extern "C"
CAMLprim value pdbReaderGetMethodFromDocumentPositionCaml(value pdbReader, value pdbDocument,value line, value col)
{
    CAMLparam4(pdbReader, pdbDocument, line, col);

    ISymUnmanagedReader *pSymReader = (ISymUnmanagedReader *) Nativeint_val(Field(pdbReader,0));
    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));
    int l = Int_val(line);
    int c = Int_val(col);

    ISymUnmanagedMethod *pMethod;
    IfFailThrow(pdbReaderGetMethodFromDocumentPosition(pSymReader,pDocument, l,c, &pMethod), "GetMethodFromDocumentPosition");
    
    CAMLlocal1(res);
    res = alloc(2,0);
    Store_field(res,0,copy_nativeint((long) pMethod));
    Store_field(res,1,pdbReader);

    CAMLreturn(res);

}


extern "C"
CAMLprim value pdbDocumentGetURLCaml(value pdbDocument)
{
    CAMLparam1(pdbDocument);

    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));

    ULONG32 urlCount;
    IfFailThrow(pdbDocumentGetURL(pDocument,NULL,&urlCount), "GetURL");

    WCHAR *urlC = new WCHAR[urlCount];
    IfFailThrow(pdbDocumentGetURL(pDocument,urlC,&urlCount), "GetURL");
    
    char res[_MAX_PATH];
    WideCharToMultiByte(CP_ACP, 0, urlC, -1, res, _MAX_PATH, NULL, NULL);

    CAMLlocal1(url);
    url = copy_string(res);
    CAMLreturn(url);
}
extern "C"
CAMLprim value pdbDocumentGetLanguageCaml(value pdbDocument)
{
    CAMLparam1(pdbDocument);

    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));

    GUID res;
    IfFailThrow(pdbDocumentGetLanguage(pDocument,&res), "GetLanguage");

    CAMLlocal1(resV);
    resV = alloc_string(sizeof(GUID));
    memcpy(String_val(resV), &res, sizeof(GUID));
    CAMLreturn(resV);
}

extern "C"
CAMLprim value pdbDocumentGetTypeCaml(value pdbDocument)
{

    CAMLparam1(pdbDocument);

    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));

    GUID res;
    IfFailThrow(pdbDocumentGetType(pDocument,&res), "GetType");

    CAMLlocal1(resV);
    resV = alloc_string(sizeof(GUID));
    memcpy(String_val(resV), &res, sizeof(GUID));
    CAMLreturn(resV);
}

extern "C"
CAMLprim value pdbDocumentGetLanguageVendorCaml(value pdbDocument)
{
    CAMLparam1(pdbDocument);

    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));

    GUID res;
    IfFailThrow(pdbDocumentGetLanguageVendor(pDocument,&res), "GetVendor");

    CAMLlocal1(resV);
    resV = alloc_string(sizeof(GUID));
    memcpy(String_val(resV), &res, sizeof(GUID));
    CAMLreturn(resV);
}

extern "C"
CAMLprim value pdbDocumentFindClosestLineCaml(value pdbDocument, value line)
{
    CAMLparam2(pdbDocument, line);

    ISymUnmanagedDocument *pDocument = (ISymUnmanagedDocument *) Nativeint_val(Field(pdbDocument,0));
    long lineC = Int_val(line);

    ULONG32 resC;
    IfFailThrow(pdbDocumentFindClosestLine(pDocument,lineC,&resC), "FindClosestLine");

    CAMLlocal1(resV);
    resV = Val_int((int) resC);
    CAMLreturn(resV);
}

extern "C"
CAMLprim value pdbMethodGetTokenCaml(value pdbMethod)
{
    CAMLparam1(pdbMethod);

    ISymUnmanagedMethod *pMethod = (ISymUnmanagedMethod *) Nativeint_val(Field(pdbMethod,0));

    mdToken tok;
    IfFailThrow(pdbMethodGetToken(pMethod,&tok), "GetToken");
    pMethod->GetToken(&tok);
    CAMLreturn(copy_int32(tok));
}

extern "C"
CAMLprim value pdbMethodGetRootScopeCaml(value pdbMethod)
{
    CAMLparam1(pdbMethod);

    ISymUnmanagedMethod *pMethod = (ISymUnmanagedMethod *) Nativeint_val(Field(pdbMethod,0));

    ISymUnmanagedScope *pScope;
    IfFailThrow(pdbMethodGetRootScope(pMethod,&pScope), "GetRootScope");

    CAMLlocal1(resV);
    resV = alloc(1,0);
    Store_field(resV,0,copy_nativeint((long) pScope));
    CAMLreturn(resV);
}



extern "C"
CAMLprim value pdbMethodGetSequencePointsCaml(value pdbMethod)
{
    CAMLparam1(pdbMethod);
    ISymUnmanagedMethod *pMethod = (ISymUnmanagedMethod *) Nativeint_val(Field(pdbMethod,0));

    // Make the call and find out how many there are.
    ULONG32 count = 0;
    IfFailThrow(pMethod->GetSequencePointCount(&count), "GetSequencePointCount");

    CAMLlocal4(sps,docPtr,doc,sp);

    sps = (count == 0) ? Atom(0) : alloc(count,0);

    if (count > 0)
    {
        // Allocate a unmanaged array for all the unmanaged document
        // references.
        ULONG32 *offsetsC = new ULONG32[count];
        ISymUnmanagedDocument **documentsC = new ISymUnmanagedDocument *[count];
        ULONG32 *linesC = new ULONG32[count];
        ULONG32 *columnsC = new ULONG32[count];
        ULONG32 *endLinesC = new ULONG32[count];
        ULONG32 *endColumnsC = new ULONG32[count];

        IfFailThrow(pdbMethodGetSequencePoints(pMethod,
				  &count,
				  offsetsC,
				  documentsC,
				  linesC,
				  columnsC,
				  endLinesC,
				  endColumnsC), "GetSequencePoints");

        for (int i = 0; i < count; i++)
        {
              ISymUnmanagedDocument *pDoc = documentsC[i];
	      docPtr = copy_nativeint((long) pDoc);

            doc = alloc(1,0 );
            Store_field(doc,0,docPtr);

            sp = alloc(6,0 ); 
            Store_field(sp,0,Val_int(offsetsC[i]));
            Store_field(sp,1,doc);
            Store_field(sp,2,Val_int(linesC[i]));
            Store_field(sp,3,Val_int(columnsC[i]));
            Store_field(sp,4,Val_int(endLinesC[i]));
            Store_field(sp,5,Val_int(endColumnsC[i]));
            Store_field(sps,i,sp);
        }
        
        delete [] offsetsC;
        delete [] documentsC;
        delete [] linesC;
        delete [] columnsC;
        delete [] endLinesC;
        delete [] endColumnsC;
    }

    CAMLreturn(sps);
}


extern "C"
CAMLprim value pdbScopeGetChildrenCaml(value pdbScope)
{
    CAMLparam1(pdbScope);

    ISymUnmanagedScope *pScope = (ISymUnmanagedScope *) Nativeint_val(Field(pdbScope,0));

    // Make the call and find out how many there are.
    ULONG32 count = 0;

    IfFailThrow(pdbScopeGetChildren(pScope,NULL,&count), "GetChildren");
    
    CAMLlocal2(children,child);

    children = (count == 0) ? Atom(0) : alloc(count,0);

    if (count > 0)
    {
        ISymUnmanagedScope** childrenC = new ISymUnmanagedScope*[count];
        IfFailThrow(pdbScopeGetChildren(pScope,childrenC,&count), "GetChildren");
        
        // Make a managed document object for each unmanaged reference
        // and place it in the managed document array.
        for (int i = 0; i < count; i++)
        {
            child = alloc(1,0 ); 
            Store_field(child,0,copy_nativeint((long) childrenC[i]));
            Store_field(children,i,child);
        }
        
        delete [] childrenC;
    }

    CAMLreturn(children);
}


extern "C"
CAMLprim value pdbScopeGetOffsetsCaml(value pdbScope)
{
    CAMLparam1(pdbScope);

    ISymUnmanagedScope *pScope = (ISymUnmanagedScope *) Nativeint_val(Field(pdbScope,0));

    ULONG32 start, end;
    IfFailThrow(pdbScopeGetOffsets(pScope,&start,&end),"GetOffsets");

    CAMLlocal1(resV);
    resV = alloc(2,0);
    Store_field(resV,0,Val_int(start));
    Store_field(resV,1,Val_int(end));
    CAMLreturn(resV);
}

extern "C"
CAMLprim value pdbScopeGetLocalsCaml(value pdbScope)
{
    CAMLparam1(pdbScope);

    ISymUnmanagedScope *pScope = (ISymUnmanagedScope *) Nativeint_val(Field(pdbScope,0));

    // Make the call and find out how many there are.
    ULONG32 count = 0;
    IfFailThrow(pdbScopeGetLocals(pScope,NULL, &count), "GetLocals");
    
    CAMLlocal2(vars,var);

    vars = (count == 0) ? Atom(0) : alloc(count,0);

    if (count > 0)
    {
        // Allocate a unmanaged array for all the unmanaged document
        // references.
        ISymUnmanagedVariable** varsC = new ISymUnmanagedVariable*[count];
        IfFailThrow(pdbScopeGetLocals(pScope,varsC, &count), "GetLocals");
        
        for (int i = 0; i < count; i++)
        {
            var = alloc(1,0 ); 
            Store_field(var,0,copy_nativeint((long) varsC[i]));
            Store_field(vars,i,var);
        }
        
        delete [] varsC;
    }
    CAMLreturn(vars);
}



extern "C"
CAMLprim value pdbVariableGetNameCaml(value pdbVariable)
{
    CAMLparam1(pdbVariable);

    ISymUnmanagedVariable *pVariable = (ISymUnmanagedVariable *) Nativeint_val(Field(pdbVariable,0));

    ULONG32 nameCount;
    IfFailThrow(pdbVariableGetName(pVariable,NULL,&nameCount), "GetName");
    WCHAR *nameC = new WCHAR[nameCount];
    IfFailThrow(pdbVariableGetName(pVariable,nameC,&nameCount), "GetName");
    
    char res[_MAX_PATH];
    WideCharToMultiByte(CP_ACP, 0, nameC, -1, res, _MAX_PATH, NULL, NULL);

    CAMLlocal1(name);
    name = copy_string(res);
    CAMLreturn(name);
}

extern "C"
CAMLprim value pdbVariableGetSignatureCaml(value pdbVariable)
{
    CAMLparam1(pdbVariable);

    ISymUnmanagedVariable *pVariable = (ISymUnmanagedVariable *) Nativeint_val(Field(pdbVariable,0));

    ULONG32 sigCount;
    IfFailThrow(pdbVariableGetSignature(pVariable,NULL,&sigCount), "GetSignature");
    BYTE *sigC = new BYTE[sigCount];
    IfFailThrow(pdbVariableGetSignature(pVariable,sigC,&sigCount), "GetSignature");

    CAMLlocal1(sig);
    sig = alloc_string(sigCount);
    memcpy(String_val(sig), sigC, sigCount);
    CAMLreturn(sig);
}


extern "C"
CAMLprim value pdbVariableGetAddressAttributesCaml(value pdbVariable)
{
    CAMLparam1(pdbVariable);

    ISymUnmanagedVariable *pVariable = (ISymUnmanagedVariable *) Nativeint_val(Field(pdbVariable,0));

    ULONG32 kind;
    ULONG32 idx;
    IfFailThrow(pdbVariableGetAddressAttributes(pVariable,&kind,&idx), "GetAddressKind");
    CAMLlocal1(res);
    res = alloc(2,0);
    Store_field(res,0,copy_int32(kind));
    Store_field(res,1,copy_int32(idx));
    CAMLreturn(res);
}

#endif
