@if "%_echo%"=="" echo off

setlocal

REM ------------------------------------------------------------------
REM Configure the sample, i.e. where to find the F# compiler and C# compiler.


if "%FSHARP_HOME%"=="" ( set FSHARP_HOME=..\..\..)
if "%FSC%"=="" ( set FSC=%FSHARP_HOME%\bin\fsc.exe )
if "%CSC%"=="" ( 
   set CSC=csc.exe
   for /f %%i in ('%FSHARP_HOME%\setup\cordir') do ( 
      if exist %%i\csc.exe ( set CSC=%%i\csc.exe )
   )
)

REM ------------------------------------------------------------------
REM Work out if this version of the CLR supports generics.
REM This also affects which version of the F# library we use.

set CORDIR=unknown
if exist %FSHARP_HOME%\setup\cordir.exe (
  for /f "usebackq" %%i in (`%FSHARP_HOME%\setup\cordir.exe`) do (
    if exist %%i (
      set CORDIR=%%i
    )
  )
)

set SUPPORTING_GENERICS=true
if NOT "%CORDIR%"=="unknown" (
  if NOT "%CORDIR:v1.0=XXX%" == "%CORDIR%" (set SUPPORTING_GENERICS=false)
  if NOT "%CORDIR:v1.1=XXX%" == "%CORDIR%" (set SUPPORTING_GENERICS=false)
)

if "%SUPPORTING_GENERICS%"=="false" (
  set ILX_SUFFIX=10
  set CSC_DEFINES=/define:NOGENERICS
)

REM ------------------------------------------------------------------
REM Compile the F# code as a library

@echo on
%FSC% -a -g FSharpLibrary.fsi FSharpLibrary.fs
@echo off
if ERRORLEVEL 1 goto Exit

REM ------------------------------------------------------------------
REM Now compile the C# code.  You should reference appropriate versions
REM of FSharp.Core.dll and FSharp.Compatibility.dll whenever compiling C# code that uses F# 
REM code.

@echo on
%CSC% /nologo /out:CSharpProgram.exe /r:FSharpLibrary.dll %CSC_DEFINES% /r:%FSHARP_HOME%\bin\FSharp.Core%ILX_SUFFIX%.dll  /r:%FSHARP_HOME%\bin\FSharp.Compatibility%ILX_SUFFIX%.dll CSharpProgram.cs
@echo off
@if ERRORLEVEL 1 (
  @echo You may need to adjust the version of the F# library referenced when compiling
  @echo C# code in order to reference the correct version of the F# library, e.g. use
  @echo   csc /r:%FSHARP_HOME%\bin\fslib10.dll /r:%FSHARP_HOME%\bin\mllib10.dll
  @echo when compiling C# code that references F# code compiled for .NET version 1.0 or 1.1.
)
goto Exit


echo ********************************************
echo Built ok, you may now run CSharpProgram.exe
echo ********************************************


:Exit
endlocal

exit /b %ERRORLEVEL%



