// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Compatibility.FSharp

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Collections
#if CLI_AT_LEAST_2_0
open System.Collections.Generic
#else
open Microsoft.FSharp.Compatibility
#endif

type 'a ReadonlyArray = ReadonlyArray of 'a array
type 'a roarray = 'a ReadonlyArray

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module ReadonlyArray =
    type 'a t = 'a ReadonlyArray // For use when not opening module, e.g. ReadonlyArray.t

    let length (ReadonlyArray x) = Array.length x
    let get (ReadonlyArray x) i = Array.get x i
    let init (n:int) (f: int -> 'a) = ReadonlyArray(Array.init n f)
    let concat vs = ReadonlyArray(Array.concat (List.map (fun (ReadonlyArray x) -> x) vs))
    let append (ReadonlyArray arr1) (ReadonlyArray arr2) = ReadonlyArray(Array.append arr1 arr2)
    let sub (ReadonlyArray a) s l = ReadonlyArray(Array.sub a s l)
    let to_list (ReadonlyArray a) = Array.to_list a  
    let of_list x = ReadonlyArray(Array.of_list x)
    let iter f (ReadonlyArray arr) = Array.iter f arr
    let map f (ReadonlyArray arr) = ReadonlyArray(Array.map f arr)
    let iteri f (ReadonlyArray arr) = Array.iteri f arr
    let mapi f (ReadonlyArray arr) = ReadonlyArray(Array.mapi f arr)
    let fold_left f acc (ReadonlyArray arr) = Array.fold_left f acc arr
    let fold_right f (ReadonlyArray arr) acc = Array.fold_right f arr acc

    let to_seq (ReadonlyArray s) = Array.to_seq s
    let of_seq c = ReadonlyArray(Array.of_seq c)
    let to_IEnumerable rarr = to_seq rarr
    let of_IEnumerable seq = of_seq seq


    #if CLI_AT_LEAST_2_0

    // Create a new object to ensure underlying array may not be mutated by a backdoor cast 
    let to_ICollection (ReadonlyArray s) = 
      let c : ICollection<'a> = Array.to_ICollection(s) in
      { new ICollection<'a> 
          with Add(x) = raise (new System.NotSupportedException("ReadOnlyCollection"));
          and Clear() = raise (new System.NotSupportedException("ReadOnlyCollection"));
          and Remove(x) = raise (new System.NotSupportedException("ReadOnlyCollection"));
          and Contains(x) = c.Contains(x)
          and CopyTo(arr,i) = c.CopyTo(arr,i)
          and get_IsReadOnly() = true
          and get_Count() = c.Count
        interface IEnumerable<'a>
          with GetEnumerator() = (c :> IEnumerable<'a>).GetEnumerator() 
        interface System.Collections.IEnumerable
          with GetEnumerator() = (c :> System.Collections.IEnumerable).GetEnumerator() }


    #endif


    #if CLI_AT_LEAST_2_0
    let of_ICollection c = ReadonlyArray(Array.of_ICollection c)
      
    let to_List (ReadonlyArray l) = Array.to_ResizeArray l
    let of_List (l : List<'a>) = ReadonlyArray(Array.of_ResizeArray l)
      
    let to_ResizeArray (ReadonlyArray l) = Array.to_ResizeArray l
    let of_ResizeArray (l : List<'a>) = ReadonlyArray(Array.of_ResizeArray l)
      
    #endif

