//==========================================================================
// (c) Microsoft Corporation 2005-2007.  
//==========================================================================

#light

namespace Microsoft.FSharp.Compatibility.OCaml

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Char = 

    let compare (x:char) y = compare x y

    let code (c:char) = (# "" c : int #)
    let chr (n:int) =  (# "conv.u2" n : char #)

    let lowercase (c:char) = System.Char.ToLower(c)
    let uppercase (c:char) = System.Char.ToUpper(c)
