// (c) Microsoft Corporation 2005-2007. 

#light

/// Definitions internal for this library.
module Microsoft.FSharp.Primitives.Basics 

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections

val ( @ ) : 'a list -> 'a list -> 'a list

module internal List =
    val append : 'a list -> 'a list -> 'a list
    val init : int -> (int -> 'a) -> 'a list
    val iter : ('a -> unit) -> 'a list -> unit
    val filter : ('a -> bool) -> 'a list -> 'a list
    val partition : ('a -> bool) -> 'a list -> 'a list * 'a list
    val nonempty : 'a list -> bool
    val length : 'a list -> int
    val map : ('a -> 'b) -> 'a list -> 'b list
    val mapi : (int -> 'a -> 'b) -> 'a list -> 'b list
    val find : ('a -> bool) -> 'a list -> 'a
    val for_all : ('a -> bool) -> 'a list -> bool
    val exists : ('a -> bool) -> 'a list -> bool
    val tryfind : ('a -> bool) -> 'a list -> 'a option
    val rev : 'a list -> 'a list
    val rev_append : 'a list -> 'a list -> 'a list
    val concat : #seq<'a list> -> 'a list
    val iteri : (int -> 'a -> unit) -> 'a list -> unit
    val unzip : ('a * 'b) list -> 'a list * 'b list
    val unzip3 : ('a * 'b * 'c) list -> 'a list * 'b list * 'c list
    val zip : 'a list -> 'b list -> ('a * 'b) list
    val zip3 : 'a list -> 'b list -> 'c list -> ('a * 'b * 'c) list
    val of_array: 'a array -> 'a list
    val to_array: 'a list -> 'a array

module internal Char =
    val code : char -> int
    val chr : int -> char

module internal Array =
    val inline geta : 'a[] -> int -> 'a nativeptr
    val inline length : 'a array -> int
    val inline get : 'a array -> int -> 'a
    val inline set : 'a array -> int -> 'a -> unit
    val inline zero_create : int -> 'a array
    val make : int -> 'a -> 'a array
    val create : int -> 'a -> 'a array
    val init : int -> (int -> 'a) -> 'a array
    val map : ('a -> 'b) -> 'a array -> 'b array
    val sub : 'a array -> int -> int -> 'a array
    val blit : 'a array -> int -> 'a array -> int -> int -> unit
    val copy : 'a array -> 'a array
    val fold_right : ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b
    val fold_left  : ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a
    val to_list : 'a array -> 'a list
    val of_list : 'a list -> 'a array

module internal Bytearray =
    val length : byte[] -> int
    val get : byte[] -> int -> byte
    val set : byte[] -> int -> byte -> unit
    val zero_create : int -> byte[]
    val init : int -> (int -> byte) -> byte[]
    val sub : byte[] -> int -> int -> byte[]
    val blit : byte[] -> int -> byte[] -> int -> int -> unit

module internal NativeOps =
    [<Unverifiable>]
    val inline of_nativeint : nativeint -> 'a nativeptr
    [<Unverifiable>]
    val inline to_nativeint : 'a nativeptr -> nativeint
    [<Unverifiable>]
    val inline of_ilsigptr : 'a nativeptr -> 'a nativeptr
    [<Unverifiable>]
    val inline to_ilsigptr : 'a nativeptr -> 'a nativeptr
    [<Unverifiable>]
    val inline pinAny : obj -> (System.Runtime.InteropServices.GCHandle -> 'c) -> 'c
    [<Unverifiable>]
    val inline pinUnscoped : obj -> System.Runtime.InteropServices.GCHandle

module internal RangeOps =
    type range = int * int // start,finish

    val inline foldR   : ('a -> int -> 'a) -> 'a -> range -> 'a 
    val inline sumfR   : (int -> float) -> range -> float

