module Data

(* This file has been automatically generated by EverParse. *)
open FStar.Bytes
module U8 = FStar.UInt8
module U16 = FStar.UInt16
module U32 = FStar.UInt32
module U64 = FStar.UInt64
module LP = LowParse.Spec
module LS = LowParse.SLow
module LPI = LowParse.Spec.AllIntegers
module LL = LowParse.Low
module L = FStar.List.Tot
module B = LowStar.Buffer
module BY = FStar.Bytes
module HS = FStar.HyperStack
module HST = FStar.HyperStack.ST
module LWP = LowParse.Writers.Instances

#reset-options "--using_facts_from '* -FStar.Tactics -FStar.Reflection' --z3rlimit 16 --z3cliopt smt.arith.nl=false --max_fuel 2 --max_ifuel 2"

friend Boolean

// Need high Z3 limits for large sum types
#set-options "--z3rlimit 120"

inline_for_extraction unfold let boolean_as_enum_key (x:boolean) : Pure (LP.enum_key boolean_enum)
  (requires norm [delta; zeta; iota; primops] (LP.list_mem x (LP.list_map fst boolean_enum)) == true) (ensures fun _ -> True) =
  [@inline_let] let _ = norm_spec [delta; zeta; iota; primops] (LP.list_mem x (LP.list_map fst boolean_enum)) in x

inline_for_extraction let key_of_data (x:data) : LP.enum_key boolean_enum =
  match x with
  | Payloads_TRUE _ -> boolean_as_enum_key TRUE
  | Payloads_FALSE _ -> boolean_as_enum_key FALSE

inline_for_extraction let data_case_of_boolean (x:boolean) : Type0 =
  match x with
  | TRUE -> U32.t
  | FALSE -> U16.t

unfold inline_for_extraction let to_data_case_of_boolean (x:boolean) (#x':boolean) (y:data_case_of_boolean x')  : Pure (norm [delta_only [(`%data_case_of_boolean)]; iota] (data_case_of_boolean x))
  (requires (x == x')) (ensures (fun y' -> y' == y)) =
  [@inline_let] let _ = norm_spec [delta_only [(`%data_case_of_boolean)] ; iota] (data_case_of_boolean x) in y

unfold inline_for_extraction let data_refine (k:LP.enum_key boolean_enum) (x:data)
  : Pure (LP.refine_with_tag key_of_data k)  (requires norm [delta; iota; zeta] (key_of_data x) == k) (ensures (fun y -> y == x)) =
  [@inline_let] let _ = norm_spec [delta; iota; zeta] (key_of_data x) in x

inline_for_extraction let synth_data_cases (x:LP.enum_key boolean_enum) (y:data_case_of_boolean x)
  : LP.refine_with_tag key_of_data x =
  match x with
  | TRUE -> data_refine x (Payloads_TRUE (to_data_case_of_boolean TRUE y))
  | FALSE -> data_refine x (Payloads_FALSE (to_data_case_of_boolean FALSE y))

unfold inline_for_extraction let from_data_case_of_boolean (#x':boolean) (x:boolean)
  (y: norm [delta_only [(`%data_case_of_boolean)]; iota] (data_case_of_boolean x))
  : Pure (data_case_of_boolean x') (requires (x == x')) (ensures (fun y' -> y' == y)) =
  [@inline_let] let _ = norm_spec [delta_only [(`%data_case_of_boolean)] ; iota] (data_case_of_boolean x) in y

let synth_data_cases_recip_pre (k:LP.enum_key boolean_enum)
  (x:LP.refine_with_tag key_of_data k) : GTot bool =
  match k with
  | TRUE -> Payloads_TRUE? x
  | FALSE -> Payloads_FALSE? x

let synth_data_cases_recip_pre_intro (k:LP.enum_key boolean_enum) (x:LP.refine_with_tag key_of_data k)
  : Lemma (synth_data_cases_recip_pre k x == true) =
  norm_spec [delta; iota] (synth_data_cases_recip_pre k x)

inline_for_extraction let synth_data_cases_recip (k:LP.enum_key boolean_enum)
  (x:LP.refine_with_tag key_of_data k) : (data_case_of_boolean k) =
  match k with
  | TRUE -> [@inline_let] let _ = synth_data_cases_recip_pre_intro TRUE x in
    (match x with Payloads_TRUE y -> (from_data_case_of_boolean TRUE y))
  | FALSE -> [@inline_let] let _ = synth_data_cases_recip_pre_intro FALSE x in
    (match x with Payloads_FALSE y -> (from_data_case_of_boolean FALSE y))

inline_for_extraction let data_sum = LP.make_sum' boolean_enum key_of_data
  data_case_of_boolean synth_data_cases synth_data_cases_recip
  (_ by (LP.make_sum_synth_case_recip_synth_case_tac ()))
  (_ by (LP.synth_case_synth_case_recip_tac ()))

noextract let parse_data_cases (x:LP.sum_key data_sum)
  : k:LP.parser_kind & LP.parser k (data_case_of_boolean x) =
  match x with
  | TRUE -> [@inline_let] let u : (k: LP.parser_kind & LP.parser k (data_case_of_boolean TRUE)) = (| _, LPI.parse_u32 |) in u
  | FALSE -> [@inline_let] let u : (k: LP.parser_kind & LP.parser k (data_case_of_boolean FALSE)) = (| _, LPI.parse_u16 |) in u
  | _ -> (| _, LP.parse_false |)

noextract let serialize_data_cases (x:LP.sum_key data_sum)
  : LP.serializer (dsnd (parse_data_cases x)) =
  match x with
  | TRUE -> [@inline_let] let u : LP.serializer (dsnd (parse_data_cases TRUE)) = LPI.serialize_u32 in u
  | FALSE -> [@inline_let] let u : LP.serializer (dsnd (parse_data_cases FALSE)) = LPI.serialize_u16 in u
  | _ -> LP.serialize_false

inline_for_extraction noextract let parse32_data_cases (x:LP.sum_key data_sum)
  : LS.parser32 (dsnd (parse_data_cases x)) =
  match x with
  | TRUE -> [@inline_let] let u : LS.parser32 (dsnd (parse_data_cases TRUE)) = LS.parse32_u32 in u
  | FALSE -> [@inline_let] let u : LS.parser32 (dsnd (parse_data_cases FALSE)) = LS.parse32_u16 in u
  | _ -> LS.parse32_false

inline_for_extraction noextract let serialize32_data_cases (x:LP.sum_key data_sum)
  : LS.serializer32 (serialize_data_cases x) =
  match x with
  | TRUE -> [@inline_let] let u : LS.serializer32 (serialize_data_cases TRUE) = LS.serialize32_u32 in u
  | FALSE -> [@inline_let] let u : LS.serializer32 (serialize_data_cases FALSE) = LS.serialize32_u16 in u
  | _ -> LS.serialize32_false

inline_for_extraction noextract let size32_data_cases (x:LP.sum_key data_sum)
  : LS.size32 (serialize_data_cases x) =
  match x with
  | TRUE -> [@inline_let] let u : LS.size32 (serialize_data_cases TRUE) = LS.size32_u32 in u
  | FALSE -> [@inline_let] let u : LS.size32 (serialize_data_cases FALSE) = LS.size32_u16 in u
  | _ -> LS.size32_false

inline_for_extraction noextract let validate_data_cases (x:LP.sum_key data_sum)
  : LL.validator (dsnd (parse_data_cases x)) =
  match x with
  | TRUE -> [@inline_let] let u : LL.validator (dsnd (parse_data_cases TRUE)) = (LL.validate_u32 ()) in u
  | FALSE -> [@inline_let] let u : LL.validator (dsnd (parse_data_cases FALSE)) = (LL.validate_u16 ()) in u
  | _ -> LL.validate_false ()

inline_for_extraction noextract let jump_data_cases (x:LP.sum_key data_sum)
  : LL.jumper (dsnd (parse_data_cases x)) =
  match x with
  | TRUE -> [@inline_let] let u : LL.jumper (dsnd (parse_data_cases TRUE)) = LL.jump_u32 in u
  | FALSE -> [@inline_let] let u : LL.jumper (dsnd (parse_data_cases FALSE)) = LL.jump_u16 in u
  | _ -> LL.jump_false

inline_for_extraction noextract let read_data_cases (x:LP.sum_key data_sum)
  : LL.leaf_reader (dsnd (parse_data_cases x)) =
  match x with
  | TRUE -> [@inline_let] let u : LL.leaf_reader (dsnd (parse_data_cases TRUE)) = LL.read_u32 in u
  | FALSE -> [@inline_let] let u : LL.leaf_reader (dsnd (parse_data_cases FALSE)) = LL.read_u16 in u
  | _ -> LL.read_false

inline_for_extraction noextract let lserialize_data_cases (x:LP.sum_key data_sum)
  : LL.serializer32 (serialize_data_cases x) =
  match x with
  | TRUE -> [@inline_let] let u : LL.serializer32 (serialize_data_cases TRUE) = LL.serialize32_u32 in u
  | FALSE -> [@inline_let] let u : LL.serializer32 (serialize_data_cases FALSE) = LL.serialize32_u16 in u
  | _ -> LL.serialize32_false

let data_parser =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LP.parse_sum data_sum boolean_repr_parser parse_data_cases

let data_serializer =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LP.serialize_sum data_sum boolean_repr_serializer serialize_data_cases

let data_bytesize (x:data) : GTot nat = Seq.length (data_serializer x)

let data_bytesize_eq x = ()

let data_parser32 =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LS.parse32_sum2 data_sum boolean_repr_parser boolean_repr_parser32 parse_data_cases parse32_data_cases (_ by (LP.enum_destr_tac boolean_enum)) (_ by (LP.maybe_enum_key_of_repr_tac boolean_enum))

let data_serializer32 =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  assert_norm (LS.serializer32_sum_gen_precond (LP.get_parser_kind boolean_repr_parser) (LP.weaken_parse_cases_kind data_sum parse_data_cases));
  LS.serialize32_sum2 data_sum boolean_repr_serializer boolean_repr_serializer32 serialize_data_cases serialize32_data_cases (_ by (LP.dep_enum_destr_tac ())) (_ by (LP.enum_repr_of_key_tac boolean_enum)) ()

let data_size32 =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  assert_norm (LS.size32_sum_gen_precond (LP.get_parser_kind boolean_repr_parser) (LP.weaken_parse_cases_kind data_sum parse_data_cases));
  LS.size32_sum2 data_sum boolean_repr_serializer boolean_repr_size32 serialize_data_cases size32_data_cases (_ by (LP.dep_enum_destr_tac ())) (_ by (LP.enum_repr_of_key_tac boolean_enum)) ()

let data_validator =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LL.validate_sum data_sum boolean_repr_validator boolean_repr_reader parse_data_cases validate_data_cases (_ by (LP.dep_maybe_enum_destr_t_tac ()))

let data_jumper =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LL.jump_sum data_sum boolean_repr_jumper boolean_repr_reader parse_data_cases jump_data_cases (_ by (LP.dep_maybe_enum_destr_t_tac ()))

let data_reader =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LL.read_sum data_sum boolean_repr_parser read_boolean_key boolean_repr_jumper parse_data_cases read_data_cases (_ by (LP.dep_enum_destr_tac ()))

let data_lserializer =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LL.serialize32_sum data_sum boolean_repr_serializer lserialize_boolean_key serialize_data_cases lserialize_data_cases (_ by (LP.dep_enum_destr_tac ()))

let lemma_valid_data_valid_boolean #_ #_ s pos h =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  LL.valid_sum_elim_tag h data_sum boolean_repr_parser parse_data_cases s pos;
  lemma_synth_boolean_inj ();
  LL.valid_synth h parse_boolean_key synth_boolean s pos

let data_gaccessor_tag =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  lemma_synth_boolean_inj ();
  lemma_synth_boolean_inv ();
  LL.gaccessor_ext
    (LL.gaccessor_compose
      (LL.gaccessor_sum_tag data_sum boolean_repr_parser parse_data_cases)
      (LL.gaccessor_synth_inv parse_boolean_key synth_boolean synth_boolean_inv ())
    )
    data_clens_tag
    ()

let data_accessor_tag =
  assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
  lemma_synth_boolean_inj ();
  lemma_synth_boolean_inv ();
  LL.accessor_ext
    (LL.accessor_compose
      (LL.accessor_sum_tag data_sum boolean_repr_parser parse_data_cases)
      (LL.accessor_synth_inv parse_boolean_key synth_boolean synth_boolean_inv ())
      ()
    )
    data_clens_tag
    ()

let data_bytesize_eqn_TRUE x =
    assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);

  LP.serialize_sum_eq data_sum boolean_repr_serializer serialize_data_cases (Payloads_TRUE x);
  (let ln = FStar.Seq.length (LP.serialize (LP.serialize_enum_key _ boolean_repr_serializer (LP.sum_enum data_sum)) (key_of_data (Payloads_TRUE x))) in assert (1 <= ln /\ ln <= 1));
  (assert (FStar.Seq.length (LP.serialize LP.serialize_u32 (x)) == 4))

let data_bytesize_eqn_FALSE x =
    assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);

  LP.serialize_sum_eq data_sum boolean_repr_serializer serialize_data_cases (Payloads_FALSE x);
  (let ln = FStar.Seq.length (LP.serialize (LP.serialize_enum_key _ boolean_repr_serializer (LP.sum_enum data_sum)) (key_of_data (Payloads_FALSE x))) in assert (1 <= ln /\ ln <= 1));
  (assert (FStar.Seq.length (LP.serialize LP.serialize_u16 (x)) == 2))

noextract let data_clens'_TRUE : LL.clens data U32.t = LL.clens_sum_payload data_sum (boolean_as_enum_key TRUE)

let data_gaccessor'_TRUE : LL.gaccessor data_parser LPI.parse_u32 data_clens'_TRUE =
[@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
 () in
  LL.gaccessor_clens_sum_payload
    data_sum
    boolean_repr_parser
    parse_data_cases
    (boolean_as_enum_key TRUE)

inline_for_extraction
let data_accessor'_TRUE : LL.accessor data_gaccessor'_TRUE =
[@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
 () in
  LL.accessor_clens_sum_payload
    data_sum
    boolean_repr_jumper
    parse_data_cases
    (boolean_as_enum_key TRUE)

let data_clens_eq_TRUE : squash (LL.clens_eq data_clens'_TRUE data_clens_TRUE) =
    (_ by (LL.sum_accessor_ext (`data)))

let data_gaccessor_TRUE =
  LL.gaccessor_ext
    data_gaccessor'_TRUE
    data_clens_TRUE
    data_clens_eq_TRUE

let data_accessor_TRUE =
  LL.accessor_ext
    data_accessor'_TRUE
    data_clens_TRUE
    data_clens_eq_TRUE

noextract let data_clens'_FALSE : LL.clens data U16.t = LL.clens_sum_payload data_sum (boolean_as_enum_key FALSE)

let data_gaccessor'_FALSE : LL.gaccessor data_parser LPI.parse_u16 data_clens'_FALSE =
[@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
 () in
  LL.gaccessor_clens_sum_payload
    data_sum
    boolean_repr_parser
    parse_data_cases
    (boolean_as_enum_key FALSE)

inline_for_extraction
let data_accessor'_FALSE : LL.accessor data_gaccessor'_FALSE =
[@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
 () in
  LL.accessor_clens_sum_payload
    data_sum
    boolean_repr_jumper
    parse_data_cases
    (boolean_as_enum_key FALSE)

let data_clens_eq_FALSE : squash (LL.clens_eq data_clens'_FALSE data_clens_FALSE) =
    (_ by (LL.sum_accessor_ext (`data)))

let data_gaccessor_FALSE =
  LL.gaccessor_ext
    data_gaccessor'_FALSE
    data_clens_FALSE
    data_clens_eq_FALSE

let data_accessor_FALSE =
  LL.accessor_ext
    data_accessor'_FALSE
    data_clens_FALSE
    data_clens_eq_FALSE

let finalize_data_TRUE #_ #_ input pos =
  [@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
    let tg = boolean_as_enum_key TRUE in
    let len = LL.serialized_length (LP.serialize_enum_key _ boolean_repr_serializer (LP.sum_enum data_sum)) tg in
    let pk = LP.get_parser_kind (LP.parse_enum_key boolean_repr_parser (LP.sum_enum data_sum)) in
    assert_norm (pk.LP.parser_kind_low == 1 /\ pk.LP.parser_kind_high == Some 1);
    assert (1 <= len /\ len <= 1);
    assert_norm (pow2 32 == 4294967296)
  in
  LL.finalize_sum_case data_sum boolean_repr_serializer boolean_repr_writer parse_data_cases (_ by (LP.enum_repr_of_key_tac boolean_enum)) (boolean_as_enum_key TRUE) input pos

let finalize_data_FALSE #_ #_ input pos =
  [@inline_let] let _ =   assert_norm (LP.parse_sum_kind (LP.get_parser_kind boolean_repr_parser) data_sum parse_data_cases == data_parser_kind);
    let tg = boolean_as_enum_key FALSE in
    let len = LL.serialized_length (LP.serialize_enum_key _ boolean_repr_serializer (LP.sum_enum data_sum)) tg in
    let pk = LP.get_parser_kind (LP.parse_enum_key boolean_repr_parser (LP.sum_enum data_sum)) in
    assert_norm (pk.LP.parser_kind_low == 1 /\ pk.LP.parser_kind_high == Some 1);
    assert (1 <= len /\ len <= 1);
    assert_norm (pow2 32 == 4294967296)
  in
  LL.finalize_sum_case data_sum boolean_repr_serializer boolean_repr_writer parse_data_cases (_ by (LP.enum_repr_of_key_tac boolean_enum)) (boolean_as_enum_key FALSE) input pos

