/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.search.MultiValueMode;

class DateMethodValueSource
extends FieldDataValueSource {
    final String methodName;
    final int calendarType;

    DateMethodValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, int calendarType) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.calendarType = calendarType;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        AtomicNumericFieldData leafData = (AtomicNumericFieldData)this.fieldData.load(leaf);
        final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues(), 0.0);
        return new DoubleDocValues(this){

            public double doubleVal(int docId) throws IOException {
                if (docValues.advanceExact(docId)) {
                    long millis = (long)docValues.doubleValue();
                    calendar.setTimeInMillis(millis);
                    return calendar.get(DateMethodValueSource.this.calendarType);
                }
                return 0.0;
            }
        };
    }

    @Override
    public String description() {
        return this.methodName + ": field(" + this.fieldData.getFieldName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateMethodValueSource that = (DateMethodValueSource)((Object)o);
        if (this.calendarType != that.calendarType) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.calendarType;
        return result;
    }
}

