/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.MultiValueMode;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final Long dMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.LongComparator(numHits, null, null){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDocValues selectedValues;
                SortedNumericDocValues values = ((AtomicNumericFieldData)LongValuesComparatorSource.this.indexFieldData.load(context)).getLongValues();
                if (LongValuesComparatorSource.this.nested == null) {
                    selectedValues = LongValuesComparatorSource.this.sortMode.select(values, dMissingValue);
                } else {
                    BitSet rootDocs = LongValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = LongValuesComparatorSource.this.nested.innerDocs(context);
                    selectedValues = LongValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return selectedValues;
            }
        };
    }
}

