/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class LinearLocation
implements Comparable {
    private int componentIndex = 0;
    private int segmentIndex = 0;
    private double segmentFraction = 0.0;

    public static LinearLocation getEndLocation(Geometry linear) {
        LinearLocation loc = new LinearLocation();
        loc.setToEnd(linear);
        return loc;
    }

    public static Coordinate pointAlongSegmentByFraction(Coordinate p0, Coordinate p1, double frac) {
        if (frac <= 0.0) {
            return p0;
        }
        if (frac >= 1.0) {
            return p1;
        }
        double x = (p1.x - p0.x) * frac + p0.x;
        double y = (p1.y - p0.y) * frac + p0.y;
        double z = (p1.z - p0.z) * frac + p0.z;
        return new Coordinate(x, y, z);
    }

    public LinearLocation() {
    }

    public LinearLocation(int segmentIndex, double segmentFraction) {
        this(0, segmentIndex, segmentFraction);
    }

    public LinearLocation(int componentIndex, int segmentIndex, double segmentFraction) {
        this.componentIndex = componentIndex;
        this.segmentIndex = segmentIndex;
        this.segmentFraction = segmentFraction;
        this.normalize();
    }

    public LinearLocation(LinearLocation loc) {
        this.componentIndex = loc.componentIndex;
        this.segmentIndex = loc.segmentIndex;
        this.segmentFraction = loc.segmentFraction;
    }

    private void normalize() {
        if (this.segmentFraction < 0.0) {
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction > 1.0) {
            this.segmentFraction = 1.0;
        }
        if (this.componentIndex < 0) {
            this.componentIndex = 0;
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentIndex < 0) {
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction == 1.0) {
            this.segmentFraction = 0.0;
            ++this.segmentIndex;
        }
    }

    public void clamp(Geometry linear) {
        if (this.componentIndex >= linear.getNumGeometries()) {
            this.setToEnd(linear);
            return;
        }
        if (this.segmentIndex >= linear.getNumPoints()) {
            LineString line = (LineString)linear.getGeometryN(this.componentIndex);
            this.segmentIndex = line.getNumPoints() - 1;
            this.segmentFraction = 1.0;
        }
    }

    public void snapToVertex(Geometry linearGeom, double minDistance) {
        double lenToEnd;
        if (this.segmentFraction <= 0.0 || this.segmentFraction >= 1.0) {
            return;
        }
        double segLen = this.getSegmentLength(linearGeom);
        double lenToStart = this.segmentFraction * segLen;
        if (lenToStart <= (lenToEnd = segLen - lenToStart) && lenToStart < minDistance) {
            this.segmentFraction = 0.0;
        } else if (lenToEnd <= lenToStart && lenToEnd < minDistance) {
            this.segmentFraction = 1.0;
        }
    }

    public double getSegmentLength(Geometry linearGeom) {
        LineString lineComp = (LineString)linearGeom.getGeometryN(this.componentIndex);
        int segIndex = this.segmentIndex;
        if (this.segmentIndex >= lineComp.getNumPoints() - 1) {
            segIndex = lineComp.getNumPoints() - 2;
        }
        Coordinate p0 = lineComp.getCoordinateN(segIndex);
        Coordinate p1 = lineComp.getCoordinateN(segIndex + 1);
        return p0.distance(p1);
    }

    public void setToEnd(Geometry linear) {
        this.componentIndex = linear.getNumGeometries() - 1;
        LineString lastLine = (LineString)linear.getGeometryN(this.componentIndex);
        this.segmentIndex = lastLine.getNumPoints() - 1;
        this.segmentFraction = 1.0;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public double getSegmentFraction() {
        return this.segmentFraction;
    }

    public boolean isVertex() {
        return this.segmentFraction <= 0.0 || this.segmentFraction >= 1.0;
    }

    public Coordinate getCoordinate(Geometry linearGeom) {
        LineString lineComp = (LineString)linearGeom.getGeometryN(this.componentIndex);
        Coordinate p0 = lineComp.getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= lineComp.getNumPoints() - 1) {
            return p0;
        }
        Coordinate p1 = lineComp.getCoordinateN(this.segmentIndex + 1);
        return LinearLocation.pointAlongSegmentByFraction(p0, p1, this.segmentFraction);
    }

    public LineSegment getSegment(Geometry linearGeom) {
        LineString lineComp = (LineString)linearGeom.getGeometryN(this.componentIndex);
        Coordinate p0 = lineComp.getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= lineComp.getNumPoints() - 1) {
            Coordinate prev = lineComp.getCoordinateN(lineComp.getNumPoints() - 2);
            return new LineSegment(prev, p0);
        }
        Coordinate p1 = lineComp.getCoordinateN(this.segmentIndex + 1);
        return new LineSegment(p0, p1);
    }

    public boolean isValid(Geometry linearGeom) {
        if (this.componentIndex < 0 || this.componentIndex >= linearGeom.getNumGeometries()) {
            return false;
        }
        LineString lineComp = (LineString)linearGeom.getGeometryN(this.componentIndex);
        if (this.segmentIndex < 0 || this.segmentIndex > lineComp.getNumPoints()) {
            return false;
        }
        if (this.segmentIndex == lineComp.getNumPoints() && this.segmentFraction != 0.0) {
            return false;
        }
        return !(this.segmentFraction < 0.0) && !(this.segmentFraction > 1.0);
    }

    public int compareTo(Object o) {
        LinearLocation other = (LinearLocation)o;
        if (this.componentIndex < other.componentIndex) {
            return -1;
        }
        if (this.componentIndex > other.componentIndex) {
            return 1;
        }
        if (this.segmentIndex < other.segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > other.segmentIndex) {
            return 1;
        }
        if (this.segmentFraction < other.segmentFraction) {
            return -1;
        }
        if (this.segmentFraction > other.segmentFraction) {
            return 1;
        }
        return 0;
    }

    public int compareLocationValues(int componentIndex1, int segmentIndex1, double segmentFraction1) {
        if (this.componentIndex < componentIndex1) {
            return -1;
        }
        if (this.componentIndex > componentIndex1) {
            return 1;
        }
        if (this.segmentIndex < segmentIndex1) {
            return -1;
        }
        if (this.segmentIndex > segmentIndex1) {
            return 1;
        }
        if (this.segmentFraction < segmentFraction1) {
            return -1;
        }
        if (this.segmentFraction > segmentFraction1) {
            return 1;
        }
        return 0;
    }

    public static int compareLocationValues(int componentIndex0, int segmentIndex0, double segmentFraction0, int componentIndex1, int segmentIndex1, double segmentFraction1) {
        if (componentIndex0 < componentIndex1) {
            return -1;
        }
        if (componentIndex0 > componentIndex1) {
            return 1;
        }
        if (segmentIndex0 < segmentIndex1) {
            return -1;
        }
        if (segmentIndex0 > segmentIndex1) {
            return 1;
        }
        if (segmentFraction0 < segmentFraction1) {
            return -1;
        }
        if (segmentFraction0 > segmentFraction1) {
            return 1;
        }
        return 0;
    }

    public boolean isOnSameSegment(LinearLocation loc) {
        if (this.componentIndex != loc.componentIndex) {
            return false;
        }
        if (this.segmentIndex == loc.segmentIndex) {
            return true;
        }
        if (loc.segmentIndex - this.segmentIndex == 1 && loc.segmentFraction == 0.0) {
            return true;
        }
        return this.segmentIndex - loc.segmentIndex == 1 && this.segmentFraction == 0.0;
    }

    public boolean isEndpoint(Geometry linearGeom) {
        LineString lineComp = (LineString)linearGeom.getGeometryN(this.componentIndex);
        int nseg = lineComp.getNumPoints() - 1;
        return this.segmentIndex >= nseg || this.segmentIndex == nseg && this.segmentFraction >= 1.0;
    }

    public Object clone() {
        return new LinearLocation(this.componentIndex, this.segmentIndex, this.segmentFraction);
    }

    public String toString() {
        return "LinearLoc[" + this.componentIndex + ", " + this.segmentIndex + ", " + this.segmentFraction + "]";
    }
}

