/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class EComp
extends AExpression {
    private final Operation operation;
    private AExpression left;
    private AExpression right;
    private Definition.Type promotedType;

    public EComp(Location location, Operation operation, AExpression left, AExpression right) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        if (this.operation == Operation.EQ) {
            this.analyzeEq(locals);
        } else if (this.operation == Operation.EQR) {
            this.analyzeEqR(locals);
        } else if (this.operation == Operation.NE) {
            this.analyzeNE(locals);
        } else if (this.operation == Operation.NER) {
            this.analyzeNER(locals);
        } else if (this.operation == Operation.GTE) {
            this.analyzeGTE(locals);
        } else if (this.operation == Operation.GT) {
            this.analyzeGT(locals);
        } else if (this.operation == Operation.LTE) {
            this.analyzeLTE(locals);
        } else if (this.operation == Operation.LT) {
            this.analyzeLT(locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    private void analyzeEq(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply equals [==] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Boolean.TYPE) {
                this.constant = ((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue();
            } else if (sort == Integer.TYPE) {
                this.constant = ((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue();
            } else if (sort == Long.TYPE) {
                this.constant = ((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue();
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = ((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeEqR(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference equals [===] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.left.expected = this.promotedType;
        this.right.expected = this.promotedType;
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Class<?> sort = this.promotedType.clazz;
            this.constant = sort == Boolean.TYPE ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() == ((Boolean)this.right.constant).booleanValue()) : (sort == Integer.TYPE ? Boolean.valueOf(((Integer)this.left.constant).intValue() == ((Integer)this.right.constant).intValue()) : (sort == Long.TYPE ? Boolean.valueOf(((Long)this.left.constant).longValue() == ((Long)this.right.constant).longValue()) : (sort == Float.TYPE ? Boolean.valueOf(((Float)this.left.constant).floatValue() == ((Float)this.right.constant).floatValue()) : (sort == Double.TYPE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() == ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant == this.right.constant)))));
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeNE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply not equals [!=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Boolean.TYPE) {
                this.constant = ((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue();
            } else if (sort == Integer.TYPE) {
                this.constant = ((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue();
            } else if (sort == Long.TYPE) {
                this.constant = ((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue();
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = ((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue();
            } else if (!this.left.isNull) {
                this.constant = !this.left.constant.equals(this.right.constant);
            } else if (!this.right.isNull) {
                this.constant = !this.right.constant.equals(null);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeNER(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteEquality(this.left.actual, this.right.actual);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply reference not equals [!==] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        this.left.expected = this.promotedType;
        this.right.expected = this.promotedType;
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.isNull && this.right.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous comparison of null constants."));
        }
        if ((this.left.constant != null || this.left.isNull) && (this.right.constant != null || this.right.isNull)) {
            Class<?> sort = this.promotedType.clazz;
            this.constant = sort == Boolean.TYPE ? Boolean.valueOf(((Boolean)this.left.constant).booleanValue() != ((Boolean)this.right.constant).booleanValue()) : (sort == Integer.TYPE ? Boolean.valueOf(((Integer)this.left.constant).intValue() != ((Integer)this.right.constant).intValue()) : (sort == Long.TYPE ? Boolean.valueOf(((Long)this.left.constant).longValue() != ((Long)this.right.constant).longValue()) : (sort == Float.TYPE ? Boolean.valueOf(((Float)this.left.constant).floatValue() != ((Float)this.right.constant).floatValue()) : (sort == Double.TYPE ? Boolean.valueOf(((Double)this.left.constant).doubleValue() != ((Double)this.right.constant).doubleValue()) : Boolean.valueOf(this.left.constant != this.right.constant)))));
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeGTE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than or equals [>=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Integer.TYPE) {
                this.constant = (Integer)this.left.constant >= (Integer)this.right.constant;
            } else if (sort == Long.TYPE) {
                this.constant = (Long)this.left.constant >= (Long)this.right.constant;
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() >= ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = (Double)this.left.constant >= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeGT(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply greater than [>] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Integer.TYPE) {
                this.constant = (Integer)this.left.constant > (Integer)this.right.constant;
            } else if (sort == Long.TYPE) {
                this.constant = (Long)this.left.constant > (Long)this.right.constant;
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() > ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = (Double)this.left.constant > (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeLTE(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than or equals [<=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Integer.TYPE) {
                this.constant = (Integer)this.left.constant <= (Integer)this.right.constant;
            } else if (sort == Long.TYPE) {
                this.constant = (Long)this.left.constant <= (Long)this.right.constant;
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() <= ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = (Double)this.left.constant <= (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    private void analyzeLT(Locals variables) {
        this.left.analyze(variables);
        this.right.analyze(variables);
        this.promotedType = variables.getDefinition().caster.promoteNumeric(this.left.actual, this.right.actual, true);
        if (this.promotedType == null) {
            throw this.createError(new ClassCastException("Cannot apply less than [>=] to types [" + this.left.actual.name + "] and [" + this.right.actual.name + "]."));
        }
        if (this.promotedType.dynamic) {
            this.left.expected = this.left.actual;
            this.right.expected = this.right.actual;
        } else {
            this.left.expected = this.promotedType;
            this.right.expected = this.promotedType;
        }
        this.left = this.left.cast(variables);
        this.right = this.right.cast(variables);
        if (this.left.constant != null && this.right.constant != null) {
            Class<?> sort = this.promotedType.clazz;
            if (sort == Integer.TYPE) {
                this.constant = (Integer)this.left.constant < (Integer)this.right.constant;
            } else if (sort == Long.TYPE) {
                this.constant = (Long)this.left.constant < (Long)this.right.constant;
            } else if (sort == Float.TYPE) {
                this.constant = ((Float)this.left.constant).floatValue() < ((Float)this.right.constant).floatValue();
            } else if (sort == Double.TYPE) {
                this.constant = (Double)this.left.constant < (Double)this.right.constant;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = variables.getDefinition().booleanType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void write(MethodWriter writer, Globals globals) {
        boolean writejump;
        Label end;
        Label jump;
        block31: {
            boolean ne;
            boolean eq;
            block37: {
                Type descriptor;
                boolean gte;
                boolean gt;
                boolean lte;
                boolean lt;
                block39: {
                    block38: {
                        block33: {
                            block36: {
                                block35: {
                                    block34: {
                                        Class<?> sort;
                                        block32: {
                                            writer.writeDebugInfo(this.location);
                                            this.left.write(writer, globals);
                                            if (!this.right.isNull) {
                                                this.right.write(writer, globals);
                                            }
                                            jump = new Label();
                                            end = new Label();
                                            eq = this.operation == Operation.EQ || this.operation == Operation.EQR;
                                            ne = this.operation == Operation.NE || this.operation == Operation.NER;
                                            lt = this.operation == Operation.LT;
                                            lte = this.operation == Operation.LTE;
                                            gt = this.operation == Operation.GT;
                                            gte = this.operation == Operation.GTE;
                                            writejump = true;
                                            sort = this.promotedType.clazz;
                                            if (sort == Void.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (sort == Byte.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (sort == Short.TYPE) throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            if (sort == Character.TYPE) {
                                                throw this.createError(new IllegalStateException("Illegal tree structure."));
                                            }
                                            if (sort != Boolean.TYPE) break block32;
                                            if (eq) {
                                                writer.ifCmp(this.promotedType.type, 153, jump);
                                                break block31;
                                            } else {
                                                if (!ne) {
                                                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                                                }
                                                writer.ifCmp(this.promotedType.type, 154, jump);
                                            }
                                            break block31;
                                        }
                                        if (sort != Integer.TYPE && sort != Long.TYPE && sort != Float.TYPE && sort != Double.TYPE) break block33;
                                        if (!eq) break block34;
                                        writer.ifCmp(this.promotedType.type, 153, jump);
                                        break block31;
                                    }
                                    if (!ne) break block35;
                                    writer.ifCmp(this.promotedType.type, 154, jump);
                                    break block31;
                                }
                                if (!lt) break block36;
                                writer.ifCmp(this.promotedType.type, 155, jump);
                                break block31;
                            }
                            if (lte) {
                                writer.ifCmp(this.promotedType.type, 158, jump);
                                break block31;
                            } else if (gt) {
                                writer.ifCmp(this.promotedType.type, 157, jump);
                                break block31;
                            } else {
                                if (!gte) {
                                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                                }
                                writer.ifCmp(this.promotedType.type, 156, jump);
                            }
                            break block31;
                        }
                        if (!this.promotedType.dynamic) break block37;
                        Type booleanType = Type.getType(Boolean.TYPE);
                        descriptor = Type.getMethodType((Type)booleanType, (Type[])new Type[]{this.left.actual.type, this.right.actual.type});
                        if (!eq) break block38;
                        if (this.right.isNull) {
                            writer.ifNull(jump);
                            break block31;
                        } else {
                            if (!this.left.isNull && this.operation == Operation.EQ) {
                                writer.invokeDefCall("eq", descriptor, 8, 1);
                                return;
                            }
                            writer.ifCmp(this.promotedType.type, 153, jump);
                        }
                        break block31;
                    }
                    if (!ne) break block39;
                    if (this.right.isNull) {
                        writer.ifNonNull(jump);
                        break block31;
                    } else if (!this.left.isNull && this.operation == Operation.NE) {
                        writer.invokeDefCall("eq", descriptor, 8, 1);
                        writer.ifZCmp(153, jump);
                        break block31;
                    } else {
                        writer.ifCmp(this.promotedType.type, 154, jump);
                    }
                    break block31;
                }
                if (lt) {
                    writer.invokeDefCall("lt", descriptor, 8, 0);
                    return;
                }
                if (lte) {
                    writer.invokeDefCall("lte", descriptor, 8, 0);
                    return;
                }
                if (gt) {
                    writer.invokeDefCall("gt", descriptor, 8, 0);
                    return;
                }
                if (!gte) {
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                writer.invokeDefCall("gte", descriptor, 8, 0);
                return;
            }
            if (eq) {
                if (this.right.isNull) {
                    writer.ifNull(jump);
                } else {
                    if (this.operation == Operation.EQ) {
                        writer.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        return;
                    }
                    writer.ifCmp(this.promotedType.type, 153, jump);
                }
            } else {
                if (!ne) {
                    throw this.createError(new IllegalStateException("Illegal tree structure."));
                }
                if (this.right.isNull) {
                    writer.ifNonNull(jump);
                } else if (this.operation == Operation.NE) {
                    writer.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                    writer.ifZCmp(153, jump);
                } else {
                    writer.ifCmp(this.promotedType.type, 154, jump);
                }
            }
        }
        if (!writejump) return;
        writer.push(false);
        writer.goTo(end);
        writer.mark(jump);
        writer.push(true);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.left, this.operation.symbol, this.right);
    }
}

