# t40003 - Dependants and dependencies include diagram filter test
## Config
```yaml
diagrams:
  t40003_include:
    type: include
    # Provide the files to parse in order to look
    # for #include directives
    glob:
      - src/dependants/t1.cc
      - src/dependencies/t2.cc
    # Render the paths relative to this directory
    include:
      # Include files which depend on t1.h
      dependants:
        - include/dependants/t1.h
      # and dependencies of t2.cc
      dependencies:
        - src/dependencies/t2.cc
    exclude:
      # Exclude files which depend on t10.h
      dependants:
        - include/dependants/t10.h
      # and other dependencies of t8.h
      dependencies:
        - include/dependencies/t8.h
    plantuml:
      before:
        - "' t40003 test include diagram"
```
## Source code
File `tests/t40003/src/dependencies/t2.cc`
```cpp
#include "../../include/dependencies/t3.h"
#include "../../include/dependencies/t5.h"

namespace clanguml::t40003::dependencies {
void t()
{
    t3();
    t5();
    t8();
}
}
```
File `tests/t40003/src/dependants/t1.cc`
```cpp
#include "../../include/dependants/t3.h"
#include "../../include/dependants/t4.h"

namespace clanguml::t40003::dependants {
void t()
{
    t3();
    t4();
}
}
```
File `tests/t40003/include/dependencies/t3.h`
```cpp
#pragma once

#include "t2.h"

namespace clanguml::t40003::dependencies {
void t3() { t2(); }
}
```
File `tests/t40003/include/dependencies/t8.h`
```cpp
#pragma once

#include "t7.h"

namespace clanguml::t40003::dependencies {
void t8() { t7(); }
}
```
File `tests/t40003/include/dependencies/t1.h`
```cpp
#pragma once

namespace clanguml::t40003::dependencies {
void t1() { }
}
```
File `tests/t40003/include/dependencies/t6.h`
```cpp
#pragma once

#include "t1.h"

namespace clanguml::t40003::dependencies {
void t6() { t1(); }
}
```
File `tests/t40003/include/dependencies/t5.h`
```cpp
#pragma once

#include "t1.h"
#include "t8.h"

namespace clanguml::t40003::dependencies {
void t5()
{
    t1();
    t8();
}
}
```
File `tests/t40003/include/dependencies/t2.h`
```cpp
#pragma once

#include "t1.h"

namespace clanguml::t40003::dependencies {
void t2() { t1(); }
}
```
File `tests/t40003/include/dependencies/t7.h`
```cpp
#pragma once

namespace clanguml::t40003::dependencies {
void t7() { }
}
```
File `tests/t40003/include/dependants/t3.h`
```cpp
#pragma once

#include "t2.h"

namespace clanguml::t40003::dependants {
void t3() { t2(); }
}
```
File `tests/t40003/include/dependants/t10.h`
```cpp
#pragma once

#include "t3.h"

namespace clanguml::t40003::dependants {
void t10() { t3(); }
}
```
File `tests/t40003/include/dependants/t4.h`
```cpp
#pragma once

namespace clanguml::t40003::dependants {
void t4() { }
}
```
File `tests/t40003/include/dependants/t1.h`
```cpp
#pragma once

namespace clanguml::t40003::dependants {
void t1() { }
}
```
File `tests/t40003/include/dependants/t11.h`
```cpp
#pragma once

#include "t10.h"

namespace clanguml::t40003::dependants {
void t11() { t10(); }
}
```
File `tests/t40003/include/dependants/t2.h`
```cpp
#pragma once

#include "t1.h"

namespace clanguml::t40003::dependants {
void t2() { t1(); }
}
```
## Generated PlantUML diagrams
![t40003_include](./t40003_include.svg "Dependants and dependencies include diagram filter test")
## Generated Mermaid diagrams
![t40003_include](./t40003_include_mermaid.svg "Dependants and dependencies include diagram filter test")
## Generated JSON models
```json
{
  "diagram_type": "include",
  "elements": [
    {
      "display_name": "src",
      "elements": [
        {
          "display_name": "src/dependants",
          "elements": [
            {
              "display_name": "src/dependants/t1.cc",
              "file_kind": "implementation",
              "id": "9722595473477539496",
              "name": "t1.cc",
              "type": "file"
            }
          ],
          "id": "9028452799776030089",
          "name": "dependants",
          "type": "folder"
        },
        {
          "display_name": "src/dependencies",
          "elements": [
            {
              "display_name": "src/dependencies/t2.cc",
              "file_kind": "implementation",
              "id": "17726793412846848469",
              "name": "t2.cc",
              "type": "file"
            }
          ],
          "id": "16123094630178690530",
          "name": "dependencies",
          "type": "folder"
        }
      ],
      "id": "11100957978370531577",
      "name": "src",
      "type": "folder"
    },
    {
      "display_name": "include",
      "elements": [
        {
          "display_name": "include/dependants",
          "elements": [
            {
              "display_name": "include/dependants/t3.h",
              "file_kind": "header",
              "id": "480008165374689457",
              "is_system": false,
              "name": "t3.h",
              "type": "file"
            },
            {
              "display_name": "include/dependants/t2.h",
              "file_kind": "header",
              "id": "15374743137536360107",
              "is_system": false,
              "name": "t2.h",
              "type": "file"
            },
            {
              "display_name": "include/dependants/t1.h",
              "file_kind": "header",
              "id": "18362174245200108524",
              "is_system": false,
              "name": "t1.h",
              "type": "file"
            }
          ],
          "id": "14108210646791327956",
          "name": "dependants",
          "type": "folder"
        },
        {
          "display_name": "include/dependencies",
          "elements": [
            {
              "display_name": "include/dependencies/t3.h",
              "file_kind": "header",
              "id": "9814745789083909391",
              "is_system": false,
              "name": "t3.h",
              "type": "file"
            },
            {
              "display_name": "include/dependencies/t2.h",
              "file_kind": "header",
              "id": "14794790605173081035",
              "is_system": false,
              "name": "t2.h",
              "type": "file"
            },
            {
              "display_name": "include/dependencies/t1.h",
              "file_kind": "header",
              "id": "8962059906444515418",
              "is_system": false,
              "name": "t1.h",
              "type": "file"
            },
            {
              "display_name": "include/dependencies/t5.h",
              "file_kind": "header",
              "id": "16849033273915995749",
              "is_system": false,
              "name": "t5.h",
              "type": "file"
            }
          ],
          "id": "14667830350821396139",
          "name": "dependencies",
          "type": "folder"
        }
      ],
      "id": "7915299339925655008",
      "name": "include",
      "type": "folder"
    }
  ],
  "name": "t40003_include",
  "relationships": [
    {
      "destination": "480008165374689457",
      "source": "9722595473477539496",
      "type": "association"
    },
    {
      "destination": "9814745789083909391",
      "source": "17726793412846848469",
      "type": "association"
    },
    {
      "destination": "16849033273915995749",
      "source": "17726793412846848469",
      "type": "association"
    },
    {
      "destination": "15374743137536360107",
      "source": "480008165374689457",
      "type": "association"
    },
    {
      "destination": "18362174245200108524",
      "source": "15374743137536360107",
      "type": "association"
    },
    {
      "destination": "14794790605173081035",
      "source": "9814745789083909391",
      "type": "association"
    },
    {
      "destination": "8962059906444515418",
      "source": "14794790605173081035",
      "type": "association"
    },
    {
      "destination": "8962059906444515418",
      "source": "16849033273915995749",
      "type": "association"
    }
  ]
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_system" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd2">src</data>
   <data key="nd1">folder</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">dependants</data>
     <data key="nd1">folder</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t1.cc]]></data>
       <data key="nd3">source</data>
      </node>
     </graph>
    </node>
    <node id="n3">
     <data key="nd2">dependencies</data>
     <data key="nd1">folder</data>
     <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n4">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t2.cc]]></data>
       <data key="nd3">source</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n5">
   <data key="nd2">include</data>
   <data key="nd1">folder</data>
   <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n6">
     <data key="nd2">dependants</data>
     <data key="nd1">folder</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n7">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t3.h]]></data>
       <data key="nd3">header</data>
      </node>
      <node id="n8">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t2.h]]></data>
       <data key="nd3">header</data>
      </node>
      <node id="n9">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t1.h]]></data>
       <data key="nd3">header</data>
      </node>
     </graph>
    </node>
    <node id="n10">
     <data key="nd2">dependencies</data>
     <data key="nd1">folder</data>
     <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n11">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t3.h]]></data>
       <data key="nd3">header</data>
      </node>
      <node id="n12">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t2.h]]></data>
       <data key="nd3">header</data>
      </node>
      <node id="n13">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t1.h]]></data>
       <data key="nd3">header</data>
      </node>
      <node id="n14">
       <data key="nd1">file</data>
       <data key="nd2"><![CDATA[t5.h]]></data>
       <data key="nd3">header</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n2" target="n7">
   <data key="ed0">association</data>
  </edge>
  <edge id="e1" source="n7" target="n8">
   <data key="ed0">association</data>
  </edge>
  <edge id="e2" source="n8" target="n9">
   <data key="ed0">association</data>
  </edge>
  <edge id="e3" source="n4" target="n11">
   <data key="ed0">association</data>
  </edge>
  <edge id="e4" source="n4" target="n14">
   <data key="ed0">association</data>
  </edge>
  <edge id="e5" source="n11" target="n12">
   <data key="ed0">association</data>
  </edge>
  <edge id="e6" source="n12" target="n13">
   <data key="ed0">association</data>
  </edge>
  <edge id="e7" source="n14" target="n13">
   <data key="ed0">association</data>
  </edge>
 </graph>
</graphml>

```
