# t20028 - Conditional (ternary) '?:' operator test case
## Config
```yaml
diagrams:
  t20028_sequence:
    type: sequence
    glob:
      - t20028.cc
    include:
      namespaces:
        - clanguml::t20028
    exclude:
      namespaces:
        - clanguml::t20028::detail
    using_namespace: clanguml::t20028
    from:
      - function: "clanguml::t20028::tmain()"
```
## Source code
File `tests/t20028/t20028.cc`
```cpp
namespace clanguml {
namespace t20028 {

struct A {
    int a() { return 0; }
    int b() { return 1; }
    int c() { return 2; }
    int d() { return 3; }
};

namespace detail {
struct B {
    int e() { return 4; }
};
} // namespace detail

int tmain()
{
    A a;
    detail::B b;

    int result{};

    result = b.e() ? b.e() : 12;

    result += a.a() ? a.b() + a.c() : a.d();

    return result;
}
}
}
```
## Generated PlantUML diagrams
![t20028_sequence](./t20028_sequence.svg "Conditional (ternary) '?:' operator test case")
## Generated Mermaid diagrams
![t20028_sequence](./t20028_sequence_mermaid.svg "Conditional (ternary) '?:' operator test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20028_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20028::tmain()",
      "id": "10777653297551465558",
      "name": "tmain",
      "namespace": "clanguml::t20028",
      "source_location": {
        "column": 5,
        "file": "t20028.cc",
        "line": 17,
        "translation_unit": "t20028.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20028::A::a()",
          "id": "5329686679215526252",
          "name": "a",
          "namespace": "clanguml::t20028",
          "source_location": {
            "column": 9,
            "file": "t20028.cc",
            "line": 5,
            "translation_unit": "t20028.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b()",
          "full_name": "clanguml::t20028::A::b()",
          "id": "6350347713472302364",
          "name": "b",
          "namespace": "clanguml::t20028",
          "source_location": {
            "column": 9,
            "file": "t20028.cc",
            "line": 6,
            "translation_unit": "t20028.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c()",
          "full_name": "clanguml::t20028::A::c()",
          "id": "12657220541584880625",
          "name": "c",
          "namespace": "clanguml::t20028",
          "source_location": {
            "column": 9,
            "file": "t20028.cc",
            "line": 7,
            "translation_unit": "t20028.cc"
          },
          "type": "method"
        },
        {
          "display_name": "d()",
          "full_name": "clanguml::t20028::A::d()",
          "id": "9426149503611941573",
          "name": "d",
          "namespace": "clanguml::t20028",
          "source_location": {
            "column": 9,
            "file": "t20028.cc",
            "line": 8,
            "translation_unit": "t20028.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20028::A",
      "id": "16587839391225031190",
      "name": "A",
      "namespace": "clanguml::t20028",
      "source_location": {
        "column": 8,
        "file": "t20028.cc",
        "line": 4,
        "translation_unit": "t20028.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "10777653297551465558",
        "location": "clanguml::t20028::tmain()"
      },
      "messages": [
        {
          "activity_id": "10777653297551465558",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "name": "a()",
                  "return_type": "int",
                  "scope": "condition",
                  "source_location": {
                    "column": 15,
                    "file": "t20028.cc",
                    "line": 26,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "5329686679215526252",
                    "participant_id": "16587839391225031190"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "5329686679215526252",
                    "participant_id": "16587839391225031190"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20028.cc",
                    "line": 5,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "name": "b()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 23,
                    "file": "t20028.cc",
                    "line": 26,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "6350347713472302364",
                    "participant_id": "16587839391225031190"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "6350347713472302364",
                    "participant_id": "16587839391225031190"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20028.cc",
                    "line": 6,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "type": "return"
                },
                {
                  "from": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "name": "c()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 31,
                    "file": "t20028.cc",
                    "line": 26,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "12657220541584880625",
                    "participant_id": "16587839391225031190"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "12657220541584880625",
                    "participant_id": "16587839391225031190"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20028.cc",
                    "line": 7,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "type": "return"
                }
              ],
              "type": "consequent"
            },
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "name": "d()",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 39,
                    "file": "t20028.cc",
                    "line": 26,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "9426149503611941573",
                    "participant_id": "16587839391225031190"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "9426149503611941573",
                    "participant_id": "16587839391225031190"
                  },
                  "name": "",
                  "return_type": "int",
                  "scope": "normal",
                  "source_location": {
                    "column": 15,
                    "file": "t20028.cc",
                    "line": 8,
                    "translation_unit": "t20028.cc"
                  },
                  "to": {
                    "activity_id": "10777653297551465558",
                    "participant_id": "10777653297551465558"
                  },
                  "type": "return"
                }
              ],
              "type": "alternative"
            }
          ],
          "name": "conditional",
          "type": "alt"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20028"
}
```
## Generated GraphML models
