# t00030 - PlantUML relationship decorators test case
## Config
```yaml
diagrams:
  t00030_class:
    type: class
    glob:
      - t00030.cc
    using_namespace: clanguml::t00030
    include:
      namespaces:
        - clanguml::t00030

```
## Source code
File `tests/t00030/t00030.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00030 {

class A { };

class B { };

class C { };

class D { };

class E { };

struct R {
    /// @uml{association[]}
    A aaa;

    /// @uml{composition[0..1:1..*]}
    std::vector<B> bbb;

    /// @uml{aggregation[0..1:1..5]}
    std::vector<C> ccc;

    /// @uml{association[:1]}
    D ddd;

    /// @uml{aggregation[:1]}
    E *eee;
};

} // namespace t00030
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00030_class](./t00030_class.svg "PlantUML relationship decorators test case")
## Generated Mermaid diagrams
![t00030_class](./t00030_class_mermaid.svg "PlantUML relationship decorators test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "518155878140115392",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 7,
        "file": "t00030.cc",
        "line": 7,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "1255385584849778459",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 7,
        "file": "t00030.cc",
        "line": 9,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "13212459188461299198",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 7,
        "file": "t00030.cc",
        "line": 11,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "8718248582018097265",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 7,
        "file": "t00030.cc",
        "line": 13,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E",
      "id": "3407717135048436859",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 7,
        "file": "t00030.cc",
        "line": 15,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "2107749887523848735",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{association[]}",
            "raw": "/// @uml{association[]}"
          },
          "is_static": false,
          "name": "aaa",
          "source_location": {
            "column": 7,
            "file": "t00030.cc",
            "line": 19,
            "translation_unit": "t00030.cc"
          },
          "type": "A"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{composition[0..1:1..*]}",
            "raw": "/// @uml{composition[0..1:1..*]}"
          },
          "is_static": false,
          "name": "bbb",
          "source_location": {
            "column": 20,
            "file": "t00030.cc",
            "line": 22,
            "translation_unit": "t00030.cc"
          },
          "type": "std::vector<B>"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{aggregation[0..1:1..5]}",
            "raw": "/// @uml{aggregation[0..1:1..5]}"
          },
          "is_static": false,
          "name": "ccc",
          "source_location": {
            "column": 20,
            "file": "t00030.cc",
            "line": 25,
            "translation_unit": "t00030.cc"
          },
          "type": "std::vector<C>"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{association[:1]}",
            "raw": "/// @uml{association[:1]}"
          },
          "is_static": false,
          "name": "ddd",
          "source_location": {
            "column": 7,
            "file": "t00030.cc",
            "line": 28,
            "translation_unit": "t00030.cc"
          },
          "type": "D"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "@uml{aggregation[:1]}",
            "raw": "/// @uml{aggregation[:1]}"
          },
          "is_static": false,
          "name": "eee",
          "source_location": {
            "column": 8,
            "file": "t00030.cc",
            "line": 31,
            "translation_unit": "t00030.cc"
          },
          "type": "E *"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00030",
      "source_location": {
        "column": 8,
        "file": "t00030.cc",
        "line": 17,
        "translation_unit": "t00030.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00030_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "518155878140115392",
      "label": "aaa",
      "source": "2107749887523848735",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "1255385584849778459",
      "label": "bbb",
      "multiplicity_destination": "1..*",
      "multiplicity_source": "0..1",
      "source": "2107749887523848735",
      "type": "composition"
    },
    {
      "access": "public",
      "destination": "13212459188461299198",
      "label": "ccc",
      "multiplicity_destination": "1..5",
      "multiplicity_source": "0..1",
      "source": "2107749887523848735",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "8718248582018097265",
      "label": "ddd",
      "multiplicity_destination": "1",
      "source": "2107749887523848735",
      "type": "association"
    },
    {
      "access": "public",
      "destination": "3407717135048436859",
      "label": "eee",
      "multiplicity_destination": "1",
      "source": "2107749887523848735",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00030"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00030</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n5" target="n0">
   <data key="ed0">association</data>
   <data key="ed2">aaa</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n5" target="n1">
   <data key="ed0">composition</data>
   <data key="ed2">bbb</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n5" target="n2">
   <data key="ed0">aggregation</data>
   <data key="ed2">ccc</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n5" target="n3">
   <data key="ed0">association</data>
   <data key="ed2">ddd</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n5" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">eee</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
