/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.format.FormatParser;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;

public final class IntFormat
extends FormatParser {
    private final boolean hasExplicitRadix;

    public IntFormat(byte[] picture, InputInfo info) throws QueryException {
        super(info);
        int sc = Token.lastIndexOf(picture, 59);
        int rc = Token.indexOf(picture, 94);
        if (rc != -1) {
            int xuc = Token.indexOf(picture, 88, rc + 1);
            int xlc = Token.indexOf(picture, 120, rc + 1);
            if (sc != -1 && xuc > sc) {
                xuc = -1;
            }
            if (sc != -1 && xlc > sc) {
                xlc = -1;
            }
            if (xuc == -1 && xlc == -1) {
                rc = -1;
            } else {
                this.radix = Token.toInt(Token.substring(picture, 0, rc));
                if (this.radix < 2 || this.radix > 36) {
                    rc = -1;
                    this.radix = 10;
                } else if (xuc != -1 && xlc != -1) {
                    throw QueryError.DIFFMAND_X.get(info, new Object[]{picture});
                }
            }
        }
        this.hasExplicitRadix = rc != -1;
        byte[] pres = Token.substring(picture, rc + 1, sc == -1 ? picture.length : sc);
        if (pres.length == 0) {
            throw QueryError.PICEMPTY.get(info, new Object[]{picture});
        }
        this.finish(this.presentation(pres, Token.cpToken(49), false, false));
        if (sc == -1) {
            return;
        }
        byte[] mod = Token.substring(picture, sc + 1);
        TokenParser tp = new TokenParser(mod);
        if (tp.consume(111)) {
            this.numType = FormatParser.NumeralType.ORDINAL;
        } else if (tp.consume(99)) {
            this.numType = FormatParser.NumeralType.CARDINAL;
        }
        if (this.numType != FormatParser.NumeralType.NUMBERING) {
            TokenBuilder tb = new TokenBuilder();
            if (tp.consume(40)) {
                while (!tp.consume(41)) {
                    if (!tp.more()) {
                        throw QueryError.INVMODIFIER_X.get(info, new Object[]{mod});
                    }
                    tb.add(tp.next());
                }
                if (tb.isEmpty()) {
                    throw QueryError.INVMODIFIER_X.get(info, new Object[]{mod});
                }
                this.modifier = tb.finish();
            }
        }
        if (!tp.consume(97)) {
            tp.consume(116);
        }
        if (tp.more()) {
            throw QueryError.INVMODIFIER_X.get(info, new Object[]{mod});
        }
    }

    public boolean isSpelloutFormat() {
        return this.first == 119;
    }

    @Override
    public int zeroes(int ch) {
        if (this.hasExplicitRadix && (ch == 120 || ch == 88)) {
            return 48;
        }
        if (this.radix == 10) {
            return super.zeroes(ch);
        }
        for (int r = 0; r < this.radix; ++r) {
            byte c = Token.DIGITS[r];
            if (ch != c && (ch <= 57 || ch != Token.uc(c))) continue;
            return 48;
        }
        return -1;
    }

    @Override
    public boolean digit(int ch, int zero) {
        if (this.hasExplicitRadix && (ch == 88 || ch == 120)) {
            return true;
        }
        if (this.radix == 10) {
            return super.digit(ch, zero);
        }
        int num = ch <= 57 ? ch : (ch & 0xDF) - 55;
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 && num < this.radix;
    }
}

