/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.util.Util;

public final class UriParser {
    private static final String ALPHA = "A-Za-z";
    private static final String DIGIT = "0-9";
    private static final String HEXDIG = "[0-9A-Fa-f]";
    private static final String SUB_DELIMS = "[!$&'()*+,;=]";
    private static final String UNRESERVED = "[A-Za-z0-9._~-]";
    private static final String PCT_ENCODED = "%[0-9A-Fa-f][0-9A-Fa-f]";
    private static final String PCHAR = "([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)";
    private static final String SEGMENT = "([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*";
    private static final String SEGMENT_NZ = "([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)+";
    private static final String SEGMENT_NZ_NC = "([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|@)+";
    private static final String PATH_ABEMPTY = "(?<pathAbempty>(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*)";
    private static final String PATH_ABSOLUTE = "(?<pathAbsolute>/(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*)?)";
    private static final String PATH_NO_SCHEME = "(?<pathNoScheme>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*)";
    private static final String PATH_ROOTLESS = "(?<pathRootless>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*)";
    private static final String REG_NAME = "([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=])*";
    private static final String DEC_OCTET = "([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))";
    private static final String IPV4_ADDRESS = "([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))";
    private static final String H16 = "[0-9A-Fa-f]{1,4}";
    private static final String LS32 = "(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))))";
    private static final String IPV6_ADDRESS = "((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::))";
    private static final String IPV_FUTURE = "v[0-9A-Fa-f]+\\.([A-Za-z0-9._~-]|[!$&'()*+,;=]|:)+";
    private static final String IP_LITERAL = "\\[(((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::))|v[0-9A-Fa-f]+\\.([A-Za-z0-9._~-]|[!$&'()*+,;=]|:)+)\\]";
    private static final String HOST = "(?<host>(\\[(((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::))|v[0-9A-Fa-f]+\\.([A-Za-z0-9._~-]|[!$&'()*+,;=]|:)+)\\]|([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))|([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=])*))";
    private static final String PORT = "(?<port>[0-9]*)";
    private static final String USERINFO = "(?<userinfo>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:)*)";
    private static final String AUTHORITY = "(?<authority>((?<userinfo>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:)*)@)?(?<host>(\\[(((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::))|v[0-9A-Fa-f]+\\.([A-Za-z0-9._~-]|[!$&'()*+,;=]|:)+)\\]|([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))|([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=])*))(:(?<port>[0-9]*))?)";
    private static final String SCHEME = "(?<scheme>[A-Za-z][A-Za-z0-9+.-]*)";
    private static final String QUERY = "(?<query>(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)|/|\\?)*)";
    private static final String FRAGMENT = "(?<fragment>(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)|/|\\?)*)";
    private static final Pattern URI_REF = Pattern.compile("^(((?<scheme>[A-Za-z][A-Za-z0-9+.-]*):)?((//(?<authority>((?<userinfo>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:)*)@)?(?<host>(\\[(((([0-9A-Fa-f]{1,4}:){6}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(::([0-9A-Fa-f]{1,4}:){5}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|(([0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){4}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,1}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){3}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})?::([0-9A-Fa-f]{1,4}:){2}(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4}:(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})?::(([0-9A-Fa-f]{1,4}:[0-9A-Fa-f]{1,4})|(([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5])))))|((([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})?::[0-9A-Fa-f]{1,4})|((([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})?::))|v[0-9A-Fa-f]+\\.([A-Za-z0-9._~-]|[!$&'()*+,;=]|:)+)\\]|([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))\\.([0-9]|([1-9][0-9])|(1[0-9]{2})|(2[0-4][0-9])|(25[0-5]))|([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=])*))(:(?<port>[0-9]*))?)(?<pathAbempty>(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*))|(?<pathAbsolute>/(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*)?)|(((?<=:)(?<pathRootless>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*))|((?<!:)(?<pathNoScheme>([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|@)+(/([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)*)*))))?(\\?(?<query>(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)|/|\\?)*))?(#(?<fragment>(([A-Za-z0-9._~-]|%[0-9A-Fa-f][0-9A-Fa-f]|[!$&'()*+,;=]|:|@)|/|\\?)*))?)$");

    private UriParser() {
    }

    public static ParsedUri parse(String uri) {
        Matcher matcher = URI_REF.matcher(uri);
        try {
            if (uri.length() <= 2048 && matcher.matches()) {
                ParsedUri pu = new ParsedUri();
                pu.absolute = matcher.group("scheme") != null;
                pu.valid = true;
                return pu;
            }
        }
        catch (StackOverflowError er) {
            Util.debug(er);
        }
        return ParsedUri.INVALID;
    }

    public static final class ParsedUri {
        private static final ParsedUri INVALID = new ParsedUri();
        private boolean absolute;
        private boolean valid;

        public boolean valid() {
            return this.valid;
        }

        public boolean absolute() {
            return this.absolute;
        }
    }
}

