/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.format.DecFormatOptions;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FnFormatNumber
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        String name;
        Item value = this.arg(0).atomItem(qc, this.info);
        byte[] picture = this.toToken(this.arg(1), qc);
        Item options = this.arg(2).item(qc, this.info);
        Type type = value.type;
        if (value.isEmpty()) {
            value = Dbl.NAN;
        } else if (type.isUntyped()) {
            value = Dbl.get(value.dbl(this.info));
        } else if (!type.isNumberOrUntyped()) {
            throw QueryError.numberError(this, value);
        }
        DecFormatOptions dfo = null;
        if (options instanceof XQMap) {
            dfo = this.toOptions(options, new DecFormatOptions(), qc);
            name = dfo.get(DecFormatOptions.FORMAT_NAME);
        } else {
            name = this.toStringOrNull(options, qc);
        }
        DecFormatter df = null;
        try {
            df = this.sc().decFormat(name != null ? QNm.parse(Token.trim(Token.token(name)), this.sc()) : QNm.EMPTY, this.info);
        }
        catch (QueryException ex) {
            Util.debug(ex);
        }
        if (df == null) {
            throw QueryError.FORMATWHICH_X.get(this.info, name);
        }
        if (dfo != null) {
            try {
                df = new DecFormatter(this.toOptions(options, df.options(), qc), this.info);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.FORMATINV_X.get(this.info, ex.getLocalizedMessage());
            }
        }
        return Str.get(df.format((ANum)value, picture, this.info));
    }
}

