/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.BoolList;

public final class FTScope
extends FTFilter {
    private final boolean same;

    public FTScope(InputInfo info, FTExpr expr, boolean same, FTUnit unit) {
        super(info, expr, unit);
        this.same = same;
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) {
        if (this.same) {
            int s = -1;
            for (FTStringMatch sm : match) {
                if (sm.exclude) continue;
                int p = this.pos(sm.start, lexer);
                if (s == -1) {
                    s = p;
                } else if (s != p) {
                    return false;
                }
                if (sm.start == sm.end || s == this.pos(sm.end, lexer)) continue;
                return false;
            }
            return true;
        }
        int c = 0;
        BoolList bl = new BoolList();
        for (FTStringMatch sm : match) {
            int size;
            if (sm.exclude) continue;
            ++c;
            int pos = this.pos(sm.start, lexer);
            if (pos < (size = bl.size()) && bl.get(pos) && pos == this.pos(sm.end, lexer)) {
                return false;
            }
            bl.set(pos, true);
        }
        return c > 1;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new FTScope(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjectMap)vm), this.same, this.unit));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FTScope)) return false;
        FTScope fts = (FTScope)obj;
        if (this.same != fts.same) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{this.same ? "same" : "different", this.unit}), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.exprs[0]).token(this.same ? "same" : "different").token((Object)this.unit);
    }
}

