/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Occurrence;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Alt
extends Node {
    private final List<Term> terms = new ArrayList<Term>();
    private int reductionId;

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setReductionId(int reductionId) {
        this.reductionId = reductionId;
    }

    public int getReductionId() {
        return this.reductionId;
    }

    public Term removeLast() {
        return this.terms.remove(this.terms.size() - 1);
    }

    public Alt addNonterminal(Mark mark, String alias, String name) {
        this.terms.add(new Nonterminal(mark, alias, name));
        return this;
    }

    public void addString(boolean deleted, String value) {
        this.terms.add(new Literal(deleted, value, false));
    }

    public void addCodepoint(boolean deleted, String value) {
        this.terms.add(new Literal(deleted, value, true));
    }

    public Alt addCharset(Charset charset) {
        this.terms.add(charset);
        return this;
    }

    public void addAlts(Alts alts) {
        this.terms.add(alts);
    }

    public void addControl(Occurrence occurrence, Term term, Term separator) {
        this.terms.add(new Control(occurrence, term, separator));
    }

    public void addStringInsertion(String string) {
        this.terms.add(new Insertion(string, false));
    }

    public void addHexInsertion(String hex) {
        this.terms.add(new Insertion(hex, true));
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public Alt copy() {
        Alt alt = new Alt();
        for (Term term : this.terms) {
            alt.getTerms().add((Term)term.copy());
        }
        return alt;
    }

    public String toString() {
        return this.terms.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.terms == null ? 0 : this.terms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Alt)) {
            return false;
        }
        Alt other = (Alt)obj;
        return !(this.terms == null ? other.terms != null : !this.terms.equals(other.terms));
    }
}

