/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene84.Lucene84Codec;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCodecFactory
extends CodecFactory
implements SolrCoreAware {
    public static final String COMPRESSION_MODE = "compressionMode";
    public static final Lucene50StoredFieldsFormat.Mode SOLR_DEFAULT_COMPRESSION_MODE = Lucene50StoredFieldsFormat.Mode.BEST_SPEED;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Codec codec;
    private volatile SolrCore core;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(NamedList args) {
        Lucene50StoredFieldsFormat.Mode compressionMode;
        super.init(args);
        assert (this.codec == null);
        String compressionModeStr = (String)args.get(COMPRESSION_MODE);
        if (compressionModeStr != null) {
            try {
                compressionMode = Lucene50StoredFieldsFormat.Mode.valueOf((String)compressionModeStr.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid compressionMode: '" + compressionModeStr + "'. Value must be one of " + Arrays.toString(Lucene50StoredFieldsFormat.Mode.values()));
            }
            log.debug("Using compressionMode: " + compressionMode);
        } else {
            compressionMode = SOLR_DEFAULT_COMPRESSION_MODE;
            log.debug("Using default compressionMode: " + compressionMode);
        }
        this.codec = new Lucene84Codec(compressionMode){

            public PostingsFormat getPostingsFormatForField(String field) {
                String postingsFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (postingsFormatName = schemaField.getType().getPostingsFormat()) != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }

            public DocValuesFormat getDocValuesFormatForField(String field) {
                String docValuesFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (docValuesFormatName = schemaField.getType().getDocValuesFormat()) != null) {
                    return DocValuesFormat.forName((String)docValuesFormatName);
                }
                return super.getDocValuesFormatForField(field);
            }
        };
    }

    @Override
    public Codec getCodec() {
        assert (this.core != null) : "inform must be called first";
        return this.codec;
    }
}

