/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.DecimalNumericConversionFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.LongValue;

class ConvertDoubleValueFunction
extends LongValue.AbstractLongValue {
    private final String name;
    private final DoubleValue param;
    private final DecimalNumericConversionFunction.ConvertDoubleFunction conv;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public ConvertDoubleValueFunction(String name, DoubleValue param, DecimalNumericConversionFunction.ConvertDoubleFunction conv) {
        this.name = name;
        this.param = param;
        this.conv = conv;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, param);
    }

    @Override
    public long getLong() {
        return this.conv.convert(this.param.getDouble());
    }

    @Override
    public boolean exists() {
        return this.param.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

