/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class DataSourceResourceLoader
extends ResourceLoader {
    private String dataSourceName;
    private String tableName;
    private String keyColumn;
    private String templateColumn;
    private String timestampColumn;
    private InitialContext ctx;
    private DataSource dataSource;
    private Connection connection = null;
    private PreparedStatement templatePrepStatement = null;
    private PreparedStatement timestampPrepStatement = null;

    @Override
    public void init(ExtProperties extProperties) {
        this.dataSourceName = StringUtils.trim((String)extProperties.getString("resource.datasource"));
        this.tableName = StringUtils.trim((String)extProperties.getString("resource.table"));
        this.keyColumn = StringUtils.trim((String)extProperties.getString("resource.keycolumn"));
        this.templateColumn = StringUtils.trim((String)extProperties.getString("resource.templatecolumn"));
        this.timestampColumn = StringUtils.trim((String)extProperties.getString("resource.timestampcolumn"));
        if (this.dataSource != null) {
            this.log.debug("DataSourceResourceLoader: using dataSource instance with table \"{}\"", (Object)this.tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", new Object[]{this.keyColumn, this.templateColumn, this.timestampColumn});
            this.log.trace("DataSourceResourceLoader initialized.");
        } else if (this.dataSourceName != null) {
            this.log.debug("DataSourceResourceLoader: using \"{}\" datasource with table \"{}\"", (Object)this.dataSourceName, (Object)this.tableName);
            this.log.debug("DataSourceResourceLoader: using columns \"{}\", \"{}\" and \"{}\"", new Object[]{this.keyColumn, this.templateColumn, this.timestampColumn});
            this.log.trace("DataSourceResourceLoader initialized.");
        } else {
            String string = "DataSourceResourceLoader not properly initialized. No DataSource was identified.";
            this.log.error(string);
            throw new RuntimeException(string);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.readLastModified(resource, "checking timestamp");
    }

    @Override
    public long getLastModified(Resource resource) {
        return this.readLastModified(resource, "getting timestamp");
    }

    @Override
    public synchronized Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new ResourceNotFoundException("DataSourceResourceLoader: Template name was empty or null");
        }
        ResultSet resultSet = null;
        try {
            this.checkDBConnection();
            resultSet = this.fetchResult(this.templatePrepStatement, string);
            if (resultSet.next()) {
                Reader reader = this.getReader(resultSet, this.templateColumn, string2);
                if (reader == null) {
                    throw new ResourceNotFoundException("DataSourceResourceLoader: template column for '" + string + "' is null");
                }
                return new SelfCleaningReader(reader, resultSet);
            }
            throw new ResourceNotFoundException("DataSourceResourceLoader: could not find resource '" + string + "'");
        }
        catch (SQLException | NamingException exception) {
            String string3 = "DataSourceResourceLoader: database problem while getting resource '" + string + "': ";
            this.log.error(string3, (Throwable)exception);
            throw new ResourceNotFoundException(string3);
        }
    }

    private long readLastModified(Resource resource, String string) {
        long l = 0L;
        String string2 = resource.getName();
        if (string2 == null || string2.length() == 0) {
            String string3 = "DataSourceResourceLoader: Template name was empty or null";
            this.log.error(string3);
            throw new NullPointerException(string3);
        }
        ResultSet resultSet = null;
        try {
            this.checkDBConnection();
            resultSet = this.fetchResult(this.timestampPrepStatement, string2);
            if (!resultSet.next()) {
                String string4 = "DataSourceResourceLoader: could not find resource " + string2 + " while " + string;
                this.log.error(string4);
                throw new ResourceNotFoundException(string4);
            }
            Timestamp timestamp = resultSet.getTimestamp(this.timestampColumn);
            l = timestamp != null ? timestamp.getTime() : 0L;
            this.closeResultSet(resultSet);
        }
        catch (SQLException | NamingException exception) {
            try {
                String string5 = "DataSourceResourceLoader: database problem while " + string + " of '" + string2 + "': ";
                this.log.error(string5, (Throwable)exception);
                throw new VelocityException(string5, exception);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                throw throwable;
            }
        }
        return l;
    }

    private void openDBConnection() throws NamingException, SQLException {
        if (this.dataSource == null) {
            if (this.ctx == null) {
                this.ctx = new InitialContext();
            }
            this.dataSource = (DataSource)this.ctx.lookup(this.dataSourceName);
        }
        if (this.connection != null) {
            this.closeDBConnection();
        }
        this.connection = this.dataSource.getConnection();
        this.templatePrepStatement = this.prepareStatement(this.connection, this.templateColumn, this.tableName, this.keyColumn);
        this.timestampPrepStatement = this.prepareStatement(this.connection, this.timestampColumn, this.tableName, this.keyColumn);
    }

    private void checkDBConnection() throws NamingException, SQLException {
        if (this.connection == null || !this.connection.isValid(0)) {
            this.openDBConnection();
        }
    }

    protected void finalize() throws Throwable {
        this.closeDBConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDBConnection() {
        if (this.templatePrepStatement != null) {
            try {
                this.templatePrepStatement.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.templatePrepStatement = null;
            }
        }
        if (this.timestampPrepStatement != null) {
            try {
                this.timestampPrepStatement.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.timestampPrepStatement = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            // empty if block
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + string + " FROM " + string2 + " WHERE " + string3 + " = ?");
        return preparedStatement;
    }

    protected ResultSet fetchResult(PreparedStatement preparedStatement, String string) throws SQLException {
        preparedStatement.setString(1, string);
        return preparedStatement.executeQuery();
    }

    protected Reader getReader(ResultSet resultSet, String string, String string2) throws SQLException {
        return resultSet.getCharacterStream(string);
    }

    private static class SelfCleaningReader
    extends FilterReader {
        private ResultSet resultSet;

        public SelfCleaningReader(Reader reader, ResultSet resultSet) {
            super(reader);
            this.resultSet = resultSet;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.resultSet.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

