/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.mockfile.FilterPath;

public class FilterDirectoryStream
implements DirectoryStream<Path> {
    protected final DirectoryStream<Path> delegate;
    protected final FileSystem fileSystem;

    public FilterDirectoryStream(DirectoryStream<Path> delegate, FileSystem fileSystem) {
        this.delegate = Objects.requireNonNull(delegate);
        this.fileSystem = Objects.requireNonNull(fileSystem);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> delegateIterator = this.delegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return new FilterPath((Path)delegateIterator.next(), FilterDirectoryStream.this.fileSystem);
            }

            @Override
            public void remove() {
                delegateIterator.remove();
            }
        };
    }
}

