/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigSetService
extends ConfigSetService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkController zkController;

    public CloudConfigSetService(SolrResourceLoader loader, ZkController zkController) {
        super(loader);
        this.zkController = zkController;
    }

    @Override
    public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
        String configName;
        try {
            if (!this.zkController.getZkClient().exists("/collections/" + cd.getCollectionName(), true).booleanValue()) {
                CreateCollectionCmd.createCollectionZkNode(this.zkController.getSolrCloudManager().getDistribStateManager(), cd.getCollectionName(), cd.getCloudDescriptor().getParams());
            }
        }
        catch (KeeperException e) {
            SolrException.log((Logger)log, null, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            SolrException.log((Logger)log, null, (Throwable)e);
        }
        try {
            configName = this.zkController.getZkStateReader().readConfigName(cd.getCollectionName());
        }
        catch (KeeperException ex) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Specified config does not exist in ZooKeeper: " + cd.getCollectionName());
        }
        return new ZkSolrResourceLoader(cd.getInstanceDir(), configName, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties(), this.zkController);
    }

    @Override
    public String configName(CoreDescriptor cd) {
        return "collection " + cd.getCloudDescriptor().getCollectionName();
    }
}

