/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.util.Constants;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.cloud.SocketProxy;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.util.TimeOut;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewritePatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JettySolrRunner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int THREAD_POOL_MAX_THREADS = 10000;
    private static final int THREAD_POOL_MAX_IDLE_TIME_MS = 260000;
    Server server;
    volatile FilterHolder dispatchFilter;
    volatile FilterHolder debugFilter;
    private boolean waitOnSolr = false;
    private int jettyPort = -1;
    private final JettyConfig config;
    private final String solrHome;
    private final Properties nodeProperties;
    private volatile boolean startedBefore = false;
    private LinkedList<FilterHolder> extraFilters;
    private static final String excludePatterns = "/partials/.+,/libs/.+,/css/.+,/js/.+,/img/.+,/templates/.+";
    private int proxyPort = -1;
    private final boolean enableProxy;
    private SocketProxy proxy;
    private String protocol;
    private String host;
    private volatile boolean started = false;

    public JettySolrRunner(String solrHome, String context, int port) {
        this(solrHome, JettyConfig.builder().setContext(context).setPort(port).build());
    }

    public JettySolrRunner(String solrHome, JettyConfig config) {
        this(solrHome, new Properties(), config);
    }

    public JettySolrRunner(String solrHome, Properties nodeProperties, JettyConfig config) {
        this(solrHome, nodeProperties, config, false);
    }

    public JettySolrRunner(String solrHome, Properties nodeProperties, JettyConfig config, boolean enableProxy) {
        this.enableProxy = enableProxy;
        this.solrHome = solrHome;
        this.config = config;
        this.nodeProperties = nodeProperties;
        if (enableProxy) {
            try {
                this.proxy = new SocketProxy(0, config.sslConfig != null && config.sslConfig.isSSLMode());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setProxyPort(this.proxy.getListenPort());
        }
        this.init(this.config.port);
    }

    private void init(int port) {
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMaxThreads(10000);
        qtp.setIdleTimeout(260000);
        qtp.setReservedThreads(0);
        this.server = new Server((ThreadPool)qtp);
        this.server.manage((Object)qtp);
        this.server.setStopAtShutdown(this.config.stopAtShutdown);
        if (System.getProperty("jetty.testMode") != null) {
            ServerConnector connector;
            SslContextFactory sslcontext = SSLConfig.createContextFactory((SSLConfig)this.config.sslConfig);
            HttpConfiguration configuration = new HttpConfiguration();
            if (sslcontext != null) {
                configuration.setSecureScheme("https");
                configuration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                HttpConnectionFactory http1ConnectionFactory = new HttpConnectionFactory(configuration);
                if (this.config.onlyHttp1 || !Constants.JRE_IS_MINIMUM_JAVA9) {
                    connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslcontext, http1ConnectionFactory.getProtocol()), http1ConnectionFactory});
                } else {
                    sslcontext.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    connector = new ServerConnector(this.server);
                    SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslcontext, "alpn");
                    connector.addConnectionFactory((ConnectionFactory)sslConnectionFactory);
                    connector.setDefaultProtocol(sslConnectionFactory.getProtocol());
                    HTTP2ServerConnectionFactory http2ConnectionFactory = new HTTP2ServerConnectionFactory(configuration);
                    ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[]{http2ConnectionFactory.getProtocol(), http1ConnectionFactory.getProtocol()});
                    alpn.setDefaultProtocol(http1ConnectionFactory.getProtocol());
                    connector.addConnectionFactory((ConnectionFactory)alpn);
                    connector.addConnectionFactory((ConnectionFactory)http1ConnectionFactory);
                    connector.addConnectionFactory((ConnectionFactory)http2ConnectionFactory);
                }
            } else {
                connector = this.config.onlyHttp1 ? new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration)}) : new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration), new HTTP2CServerConnectionFactory(configuration)});
            }
            connector.setReuseAddress(true);
            connector.setSoLingerTime(-1);
            connector.setPort(port);
            connector.setHost("127.0.0.1");
            connector.setIdleTimeout(260000L);
            connector.setStopTimeout(0L);
            this.server.setConnectors(new Connector[]{connector});
            this.server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this.server, new Random()));
        } else {
            HttpConfiguration configuration = new HttpConfiguration();
            ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(configuration)});
            connector.setPort(port);
            connector.setSoLingerTime(-1);
            connector.setIdleTimeout(260000L);
            this.server.setConnectors(new Connector[]{connector});
        }
        final ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, this.config.context, 1);
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle arg0) {
            }

            public void lifeCycleStopped(LifeCycle arg0) {
            }

            public void lifeCycleStarting(LifeCycle arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lifeCycleStarted(LifeCycle arg0) {
                JettySolrRunner.this.jettyPort = JettySolrRunner.this.getFirstConnectorPort();
                int port = JettySolrRunner.this.jettyPort;
                if (JettySolrRunner.this.proxyPort != -1) {
                    port = JettySolrRunner.this.proxyPort;
                }
                JettySolrRunner.this.nodeProperties.setProperty("hostPort", Integer.toString(port));
                JettySolrRunner.this.nodeProperties.setProperty("hostContext", ((JettySolrRunner)JettySolrRunner.this).config.context);
                root.getServletContext().setAttribute("solr.properties", (Object)JettySolrRunner.this.nodeProperties);
                root.getServletContext().setAttribute("solr.solr.home", (Object)JettySolrRunner.this.solrHome);
                log.info("Jetty properties: {}", (Object)JettySolrRunner.this.nodeProperties);
                JettySolrRunner.this.debugFilter = root.addFilter(DebugFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
                JettySolrRunner.this.extraFilters = new LinkedList();
                for (Class<? extends Filter> filterClass : ((JettySolrRunner)JettySolrRunner.this).config.extraFilters.keySet()) {
                    JettySolrRunner.this.extraFilters.add(root.addFilter(filterClass, ((JettySolrRunner)JettySolrRunner.this).config.extraFilters.get(filterClass), EnumSet.of(DispatcherType.REQUEST)));
                }
                for (ServletHolder servletHolder : ((JettySolrRunner)JettySolrRunner.this).config.extraServlets.keySet()) {
                    String pathSpec = ((JettySolrRunner)JettySolrRunner.this).config.extraServlets.get(servletHolder);
                    root.addServlet(servletHolder, pathSpec);
                }
                JettySolrRunner.this.dispatchFilter = root.getServletHandler().newFilterHolder(Source.EMBEDDED);
                JettySolrRunner.this.dispatchFilter.setHeldClass(SolrDispatchFilter.class);
                JettySolrRunner.this.dispatchFilter.setInitParameter("excludePatterns", JettySolrRunner.excludePatterns);
                root.addFilter(JettySolrRunner.this.dispatchFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                JettySolrRunner jettySolrRunner = JettySolrRunner.this;
                synchronized (jettySolrRunner) {
                    JettySolrRunner.this.waitOnSolr = true;
                    JettySolrRunner.this.notify();
                }
            }

            public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
                System.clearProperty("hostPort");
            }
        });
        root.addServlet(Servlet404.class, "/");
        ServletContextHandler chain = root;
        chain = this.injectJettyHandlers((HandlerWrapper)chain);
        if (this.config.enableV2) {
            RewriteHandler rwh = new RewriteHandler();
            rwh.setHandler((Handler)chain);
            rwh.setRewriteRequestURI(true);
            rwh.setRewritePathInfo(false);
            rwh.setOriginalPathAttribute("requestedPath");
            rwh.addRule((Rule)new RewritePatternRule("/api/*", "/solr/____v2"));
            chain = rwh;
        }
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setHandler((Handler)chain);
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setCompressionLevel(-1);
        gzipHandler.setExcludedAgentPatterns(new String[]{".*MSIE.6\\.0.*"});
        gzipHandler.setIncludedMethods(new String[]{"GET"});
        this.server.setHandler((Handler)gzipHandler);
    }

    protected HandlerWrapper injectJettyHandlers(HandlerWrapper chain) {
        return chain;
    }

    public SolrDispatchFilter getSolrDispatchFilter() {
        return (SolrDispatchFilter)this.dispatchFilter.getFilter();
    }

    public CoreContainer getCoreContainer() {
        if (this.getSolrDispatchFilter() == null || this.getSolrDispatchFilter().getCores() == null) {
            return null;
        }
        return this.getSolrDispatchFilter().getCores();
    }

    public String getNodeName() {
        if (this.getCoreContainer() == null) {
            return null;
        }
        return this.getCoreContainer().getZkController().getNodeName();
    }

    public boolean isRunning() {
        return this.server.isRunning() && this.dispatchFilter != null && this.dispatchFilter.isRunning();
    }

    public boolean isStopped() {
        return this.server.isStopped() && this.dispatchFilter == null || this.server.isStopped() && this.dispatchFilter.isStopped() && ((QueuedThreadPool)this.server.getThreadPool()).isStopped();
    }

    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean reusePort) throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            int port = reusePort && this.jettyPort != -1 ? this.jettyPort : this.config.port;
            log.info("Start Jetty (configured port={}, binding port={})", (Object)this.config.port, (Object)port);
            if (this.startedBefore) {
                this.waitOnSolr = false;
                this.init(port);
            } else {
                this.startedBefore = true;
            }
            if (!this.server.isRunning()) {
                if (this.config.portRetryTime > 0) {
                    this.retryOnPortBindFailure(this.config.portRetryTime, port);
                } else {
                    this.server.start();
                }
            }
            JettySolrRunner jettySolrRunner = this;
            synchronized (jettySolrRunner) {
                int cnt = 0;
                while (!this.waitOnSolr || !this.dispatchFilter.isRunning() || this.getCoreContainer() == null) {
                    this.wait(100L);
                    if (cnt++ != 15) continue;
                    throw new RuntimeException("Jetty/Solr unresponsive");
                }
            }
            if (this.config.waitForLoadingCoresToFinishMs != null && this.config.waitForLoadingCoresToFinishMs > 0L) {
                this.waitForLoadingCoresToFinish(this.config.waitForLoadingCoresToFinishMs);
            }
            this.setProtocolAndHost();
            if (this.enableProxy) {
                if (this.started) {
                    this.proxy.reopen();
                } else {
                    this.proxy.open(this.getBaseUrl().toURI());
                }
            }
        }
        finally {
            this.started = true;
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    private void setProtocolAndHost() {
        String protocol = null;
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new IllegalStateException("Jetty Server has no Connectors");
        }
        ServerConnector c = (ServerConnector)conns[0];
        this.protocol = protocol = c.getDefaultProtocol().toLowerCase(Locale.ROOT).startsWith("ssl") ? "https" : "http";
        this.host = c.getHost();
    }

    private void retryOnPortBindFailure(int portRetryTime, int port) throws Exception, InterruptedException {
        TimeOut timeout = new TimeOut(portRetryTime, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        int tryCnt = 1;
        while (true) {
            try {
                log.info("Trying to start Jetty on port {} try number {} ...", (Object)port, (Object)tryCnt++);
                this.server.start();
            }
            catch (IOException ioe) {
                Exception e = this.lookForBindException(ioe);
                if (e instanceof BindException) {
                    log.info("Port is in use, will try again until timeout of " + timeout);
                    this.server.stop();
                    Thread.sleep(3000L);
                    if (!timeout.hasTimedOut()) continue;
                }
                throw e;
            }
            break;
        }
    }

    Exception lookForBindException(IOException ioe) {
        Exception e = ioe;
        while (e.getCause() != null && e != e.getCause() && !(e instanceof BindException)) {
            if (!(e.getCause() instanceof Exception) || !((e = (Exception)e.getCause()) instanceof BindException)) continue;
            return e;
        }
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            Filter filter = this.dispatchFilter.getFilter();
            SolrDispatchFilter sdf = this.getSolrDispatchFilter();
            ExecutorService customThreadPool = null;
            if (sdf != null) {
                customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jettyShutDown"));
                sdf.closeOnDestroy(false);
                try {
                    sdf.close();
                }
                catch (Throwable t) {
                    log.error("Error shutting down Solr", t);
                }
            }
            QueuedThreadPool qtp = (QueuedThreadPool)this.server.getThreadPool();
            ReservedThreadExecutor rte = (ReservedThreadExecutor)qtp.getBean(ReservedThreadExecutor.class);
            this.server.stop();
            if (this.server.getState().equals("FAILED")) {
                filter.destroy();
                if (this.extraFilters != null) {
                    for (FilterHolder f : this.extraFilters) {
                        f.getFilter().destroy();
                    }
                }
            }
            while (!qtp.isStopped()) {
                qtp.stop();
                if (!qtp.isStopped()) continue;
                Thread.sleep(50L);
            }
            qtp.setStopTimeout(Integer.MAX_VALUE);
            qtp.stop();
            qtp.join();
            if (rte != null) {
                rte.stop();
                TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
                timeout.waitFor("Timeout waiting for reserved executor to stop.", () -> rte.isStopped());
            }
            if (customThreadPool != null) {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
            }
            do {
                try {
                    this.server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.server.isStopped());
        }
        finally {
            if (this.enableProxy) {
                this.proxy.close();
            }
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    private int getFirstConnectorPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return ((ServerConnector)conns[0]).getLocalPort();
    }

    public int getLocalPort() {
        return this.getLocalPort(false);
    }

    public int getLocalPort(boolean internalPort) {
        if (this.jettyPort == -1) {
            throw new IllegalStateException("You cannot get the port until this instance has started");
        }
        if (internalPort) {
            return this.jettyPort;
        }
        return this.proxyPort != -1 ? this.proxyPort : this.jettyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public URL getBaseUrl() {
        try {
            return new URL(this.protocol, this.host, this.jettyPort, this.config.context);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getProxyBaseUrl() {
        try {
            return new URL(this.protocol, this.host, this.getLocalPort(), this.config.context);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SolrClient newClient() {
        return new HttpSolrClient.Builder(this.getBaseUrl().toString()).build();
    }

    public SolrClient newClient(int connectionTimeoutMillis, int socketTimeoutMillis) {
        return ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.getBaseUrl().toString()).withConnectionTimeout(connectionTimeoutMillis)).withSocketTimeout(socketTimeoutMillis)).build();
    }

    public DebugFilter getDebugFilter() {
        return (DebugFilter)this.debugFilter.getFilter();
    }

    public static void main(String[] args) {
        try {
            JettySolrRunner jetty = new JettySolrRunner(".", "/solr", 8983);
            jetty.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public Properties getNodeProperties() {
        return this.nodeProperties;
    }

    private void waitForLoadingCoresToFinish(long timeoutMs) {
        CoreContainer cores;
        if (this.dispatchFilter != null) {
            SolrDispatchFilter solrFilter = (SolrDispatchFilter)this.dispatchFilter.getFilter();
            cores = solrFilter.getCores();
            if (cores == null) {
                throw new IllegalStateException("The CoreContainer is not set!");
            }
        } else {
            throw new IllegalStateException("The dispatchFilter is not set!");
        }
        cores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public SocketProxy getProxy() {
        return this.proxy;
    }

    static class Delay {
        final AtomicInteger counter;
        final int delayValue;
        final String reason;

        public Delay(String reason, int counter, int delay) {
            this.reason = reason;
            this.counter = new AtomicInteger(counter);
            this.delayValue = delay;
        }
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }

    public static class DebugFilter
    implements Filter {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private AtomicLong nRequests = new AtomicLong();
        List<Delay> delays = new ArrayList<Delay>();

        public long getTotalRequests() {
            return this.nRequests.get();
        }

        public void addDelay(String reason, int count, int delay) {
            this.delays.add(new Delay(reason, count, delay));
        }

        public void unsetDelay() {
            this.delays.clear();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.nRequests.incrementAndGet();
            this.executeDelay();
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }

        private void executeDelay() {
            int delayMs = 0;
            for (Delay delay : this.delays) {
                log.info("Delaying " + delay.delayValue + ", for reason: " + delay.reason);
                if (delay.counter.decrementAndGet() != 0) continue;
                delayMs += delay.delayValue;
            }
            if (delayMs > 0) {
                log.info("Pausing this socket connection for " + delayMs + "ms...");
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                log.info("Waking up after the delay of " + delayMs + "ms...");
            }
        }
    }
}

