/*
 * makeopts.c
 *
 * Create a C source file containing an initialized string with the
 * compiler options used to compile VolPack.
 *
 * Copyright (c) 1994 The Board of Trustees of The Leland Stanford
 * Junior University.  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice and this permission notice appear in
 * all copies of this software and that you do not sell the software.
 * Commercial licensing is available by contacting the author.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Author:
 *    Phil Lacroute
 *    Computer Systems Laboratory
 *    Electrical Engineering Dept.
 *    Stanford University
 */

/*
 * $Date: 2001/12/17 16:16:20 $
 * $Revision: 1.1 $
 */

#include <stdio.h>

/*
 * Usage: makeopts output_file [compiler_options ...]
 */

main(argc, argv)
int argc;
char **argv;
{
    FILE *fp;
    int c;

    if (argc < 2) {
	fprintf(stderr, "Usage: %s output_file [compiler_options ...]\n",
		argv[0]);
	exit(1);
    }
    if ((fp = fopen(argv[1], "w")) == NULL) {
	fprintf(stderr, "%s: could not open %s\n", argv[0], argv[1]);
	exit(1);
    }
    fprintf(fp, "/*\n");
    fprintf(fp,
	    " * DO NOT EDIT THIS FILE! It was created automatically by %s.\n",
	    argv[0]);
    fprintf(fp, " */\n\n");
    fprintf(fp, "char *vpCompilerOptions = \"");
    for (c = 2; c < argc; c++) {
	if (c > 2)
	    fprintf(fp, " ");
	fprintf(fp, "%s", argv[c]);
    }
    fprintf(fp, "\";\n");
    exit(0);
}
